package jsal;
import robocode.*;
import java.awt.*;
//import java.awt.Color;

/**
 * Jsalbot - a robot by (your name here)
 */
public class Jsalbot extends AdvancedRobot
{	double bulletpower=1;
	double x=0;
	double y=0;
	double vx;
	double vy;
	double targetx;
	double targety;
	long scantime=0;
	boolean newscan=false;
	int forward=1;
	/**
	 * run: Jsalbot's default behavior
	 */
	public void run() {
		// After trying out your robot, try uncommenting the import at the top,
		// and the next line:
		//setColors(Color.red,Color.blue,Color.green);
		setAdjustRadarForGunTurn(true);
		setAdjustGunForRobotTurn(true);
		while(true) {
			if(getDistanceRemaining()==0) {
				setAhead(200*forward);
				forward*=-1;
			}
			// Replace the next 4 lines with any behavior you would like
			if(getRadarTurnRemaining()==0) {
				setTurnRadarRight(360);
			}
			long time=getTime();
			x+=vx*(time-scantime);
			y+=vy*(time-scantime);
			scantime=time;
			
			double distance=0; //appease the compiler
			double bullettime;
			targetx=x;
			targety=y;
			for(int i=0; i<10; i++) {
				distance=Math.sqrt((targetx-getX())*(targetx-getX()) +(targety-getY())*(targety-getY()));
				bullettime=distance/(20-3*bulletpower);
				targetx=x+vx*bullettime;
				targety=y+vy*bullettime;
			}
			if(targetx>getBattleFieldWidth()) {
				targetx=getBattleFieldWidth();
			}
			if(targetx<0) {
				targetx=0;
			}
			if(targety>getBattleFieldHeight()) {
				targety=getBattleFieldHeight();
			}
			if(targety<0) {
				targety=0;
			}
			scantime=time;
			double absoluteangle=Math.atan2( targety-getY(),targetx-getX());
			double gunrealangle=(Math.PI/2-getGunHeadingRadians());
			if(gunrealangle<0) {
				gunrealangle+=2*Math.PI;
			}
			if(absoluteangle<0) {
				absoluteangle+=2*Math.PI;
			}
			double diff=absoluteangle-gunrealangle;
			//out.println(""+distance+","+diff);
			if(Math.abs(diff)<=Math.PI) {
			} else {
				diff=-(Math.PI*2-Math.abs(diff));
			}
			if(diff*distance<=1) {
				fire(bulletpower);
			}
			setTurnGunLeftRadians(diff);
			execute();
		}
	}

	/**
	 * onScannedRobot: What to do when you see another robot
	 */
	public void onScannedRobot(ScannedRobotEvent e) {
		x=getX();
		y=getY();
		double angle=(e.getBearingRadians()+getHeadingRadians());
		y+=e.getDistance()*Math.cos(angle);
		x+=e.getDistance()*Math.sin(angle);
		double enemyangle=e.getHeadingRadians();
		vx=e.getVelocity()*Math.sin(enemyangle);
		vy=e.getVelocity()*Math.cos(enemyangle);
		//out.println(angle+","+Math.cos(angle)+","+Math.sin(angle));
		scantime=getTime();
	}

	/**
	 * onHitByBullet: What to do when you're hit by a bullet
	 */
	public void onHitByBullet(HitByBulletEvent e) {
		setTurnLeft(90 - e.getBearing());
	}
	public void onPaint(Graphics2D g) {
		g.drawString("0",(float)targetx,(float)targety);
	}
	
}
