/*
 * Class.java
 *
 * Created on April 7, 2002, 12:57 AM
 */

package tobe.firing;
import tobe.util.*;
import robocode.*;

/**
 *
 * @author  tobe
 * @version 
 */
public class JumpPredictor extends AbstractStrategy {
        private java.util.HashMap foeStats = new java.util.HashMap();
        private RobotStats target = null;
        private BearingVector position = new BearingVector();
        private BearingVector movement = new BearingVector();

        private BearingVector aimedPosition = new BearingVector();
        private BearingVector aimedMovement = new BearingVector();
        private BearingVector aimed2Position = new BearingVector();
        private BearingVector aimed2Movement = new BearingVector();
        private BearingVector aimed3Position = new BearingVector();
        private BearingVector aimed3Movement = new BearingVector();
        private double aimedHitTime;
		private double varianceX;
		private double varianceY;

		private BearingVector gunPoint = new BearingVector();
		private BearingVector gunAim = new BearingVector();
		
		private BearingVector radar = new BearingVector();
		
		final private boolean alpha;
		
		public JumpPredictor() {
			super();
			alpha = false;
		}
		
		public JumpPredictor(boolean isAlpha) {
			super();
			alpha = isAlpha;
		}
        
        /** This should be called by the robot at the start of each battle */
        public void init(AdvancedRobot bot){
            bot.setAdjustGunForRobotTurn(true);
			bot.setAdjustRadarForGunTurn(true);
            target = null;
            java.util.Iterator i = foeStats.values().iterator();
            while(i.hasNext()) {
                ((RobotStats) i.next()).init();
            }
        }
        
        public boolean go(AdvancedRobot bot) {
			if(bot.getOthers() > 1 || target == null || target.latestTime() < bot.getTime()-1)
            	bot.setTurnRadarRight(7200);
			else {
				radar.setVector(target.latestPosition());
				radar.changeOrigin(bot.getX(), bot.getY());
				double relativeAngle = normalizeAngle(radar.getBearing()-bot.getRadarHeadingRadians());
				if(relativeAngle < 0) relativeAngle -= Math.PI/20;
				else relativeAngle += Math.PI/20;
				bot.setTurnRadarRightRadians(relativeAngle);
			}
            return aim(bot);
        }
        
        private boolean aim(AdvancedRobot bot) {
            if(target == null) return false;
            aimedPosition.setVector(target.latestPosition());
            //new viewpoint
            aimedPosition.changeOrigin(bot.getX(), bot.getY());
            aimedMovement.setVector(target.latestMovement());
            aimed2Position.setVector(aimedPosition);
            aimed2Movement.setVector(aimedMovement);
            aimed3Position.setVector(aimedPosition);
            aimed3Movement.setVector(aimedMovement);
            double shotTravelTime = target.shotTravelTime;
			double maxPower = Math.max(0.1,Math.min(3.0,Math.min(target.getLife(), bot.getEnergy())));
			if(alpha || maxPower > 3) {
				if(aimedPosition.getDistance() > 900) maxPower = 0.1;
				else if(aimedPosition.getDistance() > 800) maxPower = 0.5;
				else if(aimedPosition.getDistance() > 700) maxPower = 1;
				else if(aimedPosition.getDistance() > 400) maxPower = 2;
				else maxPower = 3;
			}
			if(shotTravelTime > aimedPosition.getDistance()/(20-3*maxPower))
				shotTravelTime = aimedPosition.getDistance()/(20-3*maxPower);
                        double minPower = 0.1;
			if(shotTravelTime < aimedPosition.getDistance()/(20-3*minPower))
				shotTravelTime = aimedPosition.getDistance()/(20-3*minPower);
                        
			if(alpha) shotTravelTime = aimedPosition.getDistance()/(20-3*maxPower);

            double timeToHit=bot.getGunHeat()/bot.getGunCoolingRate() + shotTravelTime;
            aimedHitTime = target.latestTime() + timeToHit;
			if(aimedPosition.getDistance() > 64 && target.getLife() > 0) {
            	target.applyRandomFiredDeltas((int) timeToHit, aimedPosition, aimedMovement);
            	target.applyRandomFiredDeltas((int) timeToHit, aimed2Position, aimed2Movement);
            	target.applyRandomFiredDeltas((int) timeToHit, aimed3Position, aimed3Movement);
			}

            return shoot(bot);
        }
        
        private boolean shoot(AdvancedRobot bot) {
            double timeToHit = aimedHitTime - bot.getTime();

			double minAimedX = Math.min(aimedPosition.getToX(), Math.min(aimed2Position.getToX(), aimed3Position.getToX()));
			double minAimedY = Math.min(aimedPosition.getToY(), Math.min(aimed2Position.getToY(), aimed3Position.getToY()));
			double maxAimedX = Math.max(aimedPosition.getToX(), Math.max(aimed2Position.getToX(), aimed3Position.getToX()));
			double maxAimedY = Math.max(aimedPosition.getToY(), Math.max(aimed2Position.getToY(), aimed3Position.getToY()));
            
			gunAim.setPoints((aimedPosition.getToX()+aimed2Position.getToX()+aimed3Position.getToX())/3,
                (aimedPosition.getToY()+aimed2Position.getToY()+aimed3Position.getToY())/3,
                (aimedPosition.getFromX()+aimed2Position.getFromX()+aimed3Position.getFromX())/3,
                (aimedPosition.getFromY()+aimed2Position.getFromY()+aimed3Position.getFromY())/3);
			double varianceX = Math.min(gunAim.getToX() - minAimedX, maxAimedX - gunAim.getToX());
			varianceX /= 2;
			varianceX += 15;
			double varianceY = Math.min(gunAim.getToY() - minAimedY, maxAimedY - gunAim.getToY());
			varianceY /= 2;
			varianceY += 15;
			
            double impactBearing = gunAim.getBearing();
            double turnGunAngle=impactBearing-bot.getGunHeadingRadians();
            turnGunAngle=normalizeAngle(turnGunAngle);
            bot.setTurnGunRightRadians(turnGunAngle); //turn the gun
			
			gunPoint.setPolar(bot.getGunHeadingRadians(), gunAim.getDistance(), bot.getX(), bot.getY());
            if(gunPoint.getToX() < gunAim.getToX() - varianceX
				|| gunPoint.getToX() > gunAim.getToX() + varianceX
				|| gunPoint.getToY() < gunAim.getToY() - varianceY
				|| gunPoint.getToY() > gunAim.getToY() + varianceY) {
                return false;
            }
            
            if( timeToHit < 0 ) {
                return false;
            }

			double shotPower;
			double maxPower = Math.min(3.0,Math.min(target.getLife(), bot.getEnergy()));
			if(alpha) {
				shotPower = maxPower;//always! thanks, squigbot!
			} else {
            	double bulletVelocity = gunPoint.getDistance()/timeToHit;
            	shotPower = (20-bulletVelocity)/3;
			}
			
			if(shotPower > maxPower) shotPower = maxPower;
			if(shotPower < 0.1) shotPower = 0.1;

            if(shotPower >= 0.1){
                Bullet b = bot.fireBullet(shotPower);
				if( b != null ) {//could I fire?
				bot.addCustomEvent( new PredictedHitCondition(bot, b, timeToHit, target));
					target.markFired();
				}
            }
            return false;
        }
        
        public void printStatistics(AdvancedRobot bot) {
            bot.out.println("Shoot times:");
            java.util.Iterator i = foeStats.keySet().iterator();
            while(i.hasNext()) {
                String name = (String) i.next();
                RobotStats t = (RobotStats) foeStats.get(name);
                bot.out.println(name+" "+t.shotTravelTime);
            }
        }
        
        /** Event handler. Keep its execution time short. */
        public void handleBulletHitEvent(AdvancedRobot bot, BulletHitEvent e) {}
        
        /** Event handler. Keep its execution time short. */
        public void handleBulletMissedEvent(AdvancedRobot bot, BulletMissedEvent e) {}
        
        /** Event handler. Keep its execution time short. */
        public void handleCustomEvent(AdvancedRobot bot, CustomEvent e) {
			Condition c = e.getCondition();
			if( c instanceof PredictedHitCondition ) {
				PredictedHitCondition p = (PredictedHitCondition) c;
				bot.removeCustomEvent(p);
				if( p.bullet.isActive() ) p.target.shotTravelTime -= 0.2; //I missed
				else if( p.bullet.getVictim() == null ); //don't know
				else if( p.target.name == null ); //don't know
				else if( p.target.name.equals(p.bullet.getVictim())) p.target.shotTravelTime += 1; //I hit
			}
		}
        
        /** Event handler. Keep its execution time short.*/
        public void handleDeathEvent(AdvancedRobot bot, DeathEvent e) {
            printStatistics(bot);
		}
        
        /** Event handler. Keep its execution time short. */
        public void handleHitByBulletEvent(AdvancedRobot bot, HitByBulletEvent e) {}
        
        /** Event handler. Keep its execution time short. */
        public void handleHitRobotEvent(AdvancedRobot bot, HitRobotEvent e) {}
        
        /** Event handler. Keep its execution time short. */
        public void handleHitWallEvent(AdvancedRobot bot, HitWallEvent e) {}
        
        /** Event handler. Keep its execution time short. */
        public void handleRobotDeathEvent(AdvancedRobot bot, RobotDeathEvent e) {
            RobotStats enemy = (RobotStats) foeStats.get(e.getName());
            if( enemy != null) enemy.died();
        }
        
        /** Event handler. Keep its execution time short. */
        public void handleScannedRobotEvent(AdvancedRobot bot, ScannedRobotEvent e) {
            position.setOrigin(bot.getX(),bot.getY());
            position.setBearing(e.getBearingRadians()+bot.getHeadingRadians());
            position.setDistance(e.getDistance());
            movement.setBearing(e.getHeadingRadians());
            movement.setDistance(e.getVelocity());
            RobotStats enemy = (RobotStats) foeStats.get(e.getName());
            if( enemy == null ) {
                enemy = new RobotStats(e.getName());
                foeStats.put(e.getName(), enemy);
            }
            enemy.updateDeltas(position, movement, e.getTime(), e.getEnergy());
            if(!enemy.canBeAimedAt()) return;
            if(target == null) target = enemy;
            else if(!target.canBeAimedAt()) {
                target = enemy;
            } else if(enemy.latestDistance() < target.latestDistance()*2/3) {
                target = enemy;
            }
        }
        
        /** Event handler. Keep its execution time short.*/
        public void handleWinEvent(AdvancedRobot bot, WinEvent e) {
            printStatistics(bot);
		}
        
        /** Utility routine to take an angle in radians and returns its normal value between -PI and PI*/
        protected double normalizeAngle(double r) {
            while(r>Math.PI) r-=2*Math.PI;
            while(r<-Math.PI) r+=2*Math.PI;
            return r;
        }
}
