package bvh.micro;

import robocode.*;
import robocode.util.Utils;
import java.awt.Color;
import java.awt.geom.Point2D;
import java.awt.geom.RoundRectangle2D;
import java.util.*;

/**
 * <h2>bvh.micro.Freya</h2> <h3>- a robot by Bart "Loki" van Hest</h3>
 *
 * <p>Freya was the goddess of love, marriage, and fertility. Her identity and
 *   attributes were often confused with those of the goddess Frigg. As a deity
 *   of the dead, Freya was entitled to half the warriors killed in battle,
 *   the other half going to Odin.
 *   She was the daughter of Njord and the sister of the god Frey and originally
 *   one of the Vanir. She was frequently represented as riding in a chariot
 *   drawn by cats."</p>
 *
 *
 * @version 0.3
 * @author Bart van Hest
 */
public class Freya extends AdvancedRobot {
   static final double             TWEEPI = 2D * Math.PI; // 360 graden draaien
   static final double             HALFPI = Math.PI / 2D; //  90 graden draaien
   static final double             KWARTPI = Math.PI / 4D; //  45 graden draaien
   static final double             WANDAFSTAND = 44D; // minimale afstand tot wand: anders bewegingsrichting omkeren
   static final double             RONDING = 80D; // ronding van slagveld
   static final double             KORTSTELOOPAFSTAND = 36D;
   static final double             MAXIMUM_SNELHEID = 8D;
   static final double             MINIMUMVUURKRACHT = 0.5D;
   static final double             STANDAARDVUURKRACHT = 2.0D;
   static final double             MAXIMUMVUURKRACHT = 3.0D;
   static final double             STANDAARDKOGELSNELHEID = 14D;
   static final double             AFSTANDCORRECTIELINKANON = 750;

   // use static variables to minimise codesize...
   private static Hashtable        doelen = new Hashtable();
   private Doel                    doel = new Doel();
   private static Point2D.Double   positie;
   private static Point2D.Double   bestemming;

   public void run() {
      // set battlecolors:
      setColors(Color.pink, Color.pink, Color.pink);
      // just keep spinning the radar:
      setTurnRadarRightRadians(Double.POSITIVE_INFINITY);
   }

   /**
    * onScannedRobot: What to do when you see another robot
    * let op: van alle scanned bots tijdens een radar-sweep wordt de dichtstbijzijnde bot doorgegegeven!
    */
   public void onScannedRobot(ScannedRobotEvent evt) {
      positie = new Point2D.Double(getX(), getY());

      // process information from scanned opponent.
      Doel   d = null;
      if ((d = (Doel) doelen.get(evt.getName())) == null) {
         d = new Doel();
         doelen.put(evt.getName(), d);
      }
      d.actief = true;
      d.bewegingsrichting = evt.getHeadingRadians();
      d.snelheid = evt.getVelocity();
      d.setLocation(projecteerPositie(positie,
            d.richting = Utils.normalRelativeAngle(getHeadingRadians() + evt.getBearingRadians()), evt.getDistance()));

      // select target when no target is selected or when the opponent seems to
      // be a more favourable target.
      d.energie = evt.getEnergy();
      double afstandEnVuurkracht = positie.distance(doel);
      if (!doel.actief
       || d.distance(positie) < afstandEnVuurkracht
         ) {
         doel = d;
      }

      // NAVIGATION: codesize is smaller when the navigation is stored in a
      // separate method (like it is in mini.Freya).
      navigatie();

      // GUN: simple nano-bot gun based on TooZe's Gnome.
      // Added power-management and firepower depending on target distance.
		  double hoek = doel.richting + HALFPI - ((doel.snelheid < 0) ? doel.bewegingsrichting + Math.PI : doel.bewegingsrichting);
  		turnGunRightRadians(Utils.normalRelativeAngle(doel.richting + Math.atan2(Math.cos(hoek) * Math.abs(doel.snelheid), 14 + Math.sin(hoek)) - getGunHeadingRadians()));
		
      if (getGunTurnRemaining() == 0 && getEnergy() > STANDAARDVUURKRACHT ) {
         setFire(STANDAARDVUURKRACHT);
      }
   }

   public void onRobotDeath(RobotDeathEvent evt) {
      Doel d = (Doel) doelen.get(evt.getName());
      if (d != null) d.actief = false;
   }

   /**
    * onHitByBullet: n.a.v. een treffer door de tegenstander worden de volgende gegevens bijgewerkt:
    * <ul>
    *  <li>treffers door de tegenstander.</li>
    *  <li>energie van de tegenstander (deze wordt opgehoogd met 3 keer de kogel vuurkracht).</li>
    *  <li>eventueel bijwerken doelgolf-statistiek.</li>
    *  </ul>:
    *
    * @param evt Het HitByBulletEvent dat naar de robot wordt gestuurd als de robot
    * wordt geraakt door een vijandelijke kogel.
    */
/*
   public void onHitByBullet(HitByBulletEvent evt) {
      Doel d = (Doel) doelen.get(evt.getName());
      if (d != null) d.treffersDoorDoel++;
   }
*/

   /**
    * onBulletHit: n.a.v. een treffer op de tegenstander worden de volgende gegevens bijgewerkt:
    * <ul>
    *  <li>treffers op de tegenstander.</li>
    *  <li>energie van de tegenstander.</li>
    *  </ul>
    *
    * @param evt Het BulletHitEvent dat naar de robot wordt gestuurd als een kogel
    * een tegenstander raakt.
    */
/*
   public void onBulletHit(BulletHitEvent evt) {
      Doel d = (Doel) doelen.get(evt.getName());
      if (d != null) d.treffersOpDoel++;
   }
*/
   /**
    * De navigatie is gebaseerd op een anti-gravity/ minimum risk benadering (n.b. deze werd
    * door mij oorspronkelijk maximale entropie/bewegingsvrijheid methode genoemd).
    * De robot beweegd loodrecht op de richting naar de geselecteerde tegenstander, waarbij voor
    * een aantal afstanden en random richtingen in wordt bepaald wat het
    * risico is om naar deze positie te gaan. De positie met het laagste risico wordt gekozen.
    *
    * De maximale afstand is afhankelijk van de maximale ontsnappingshoek o.b.v. de afstand tot
    * de tegenstander en de laatst afgeschoten kogel vuurkracht van de tegenstander.
    *
    */
   private void navigatie() {
      // can i get rid of this code? how?
      if (bestemming == null) {
         bestemming = positie;
      }

      // the following variable is reused to shrink the code-size:
      double randomWaardeEnHoek;
      // the navigation-method is called from the onScannedRobot-event, so not every tick
      // and it is no longer necessary to end the movement fully.
      // beweging op basis van resterende afstand om botsingen, en daardoor stilstand,
      // te voorkomen. Dit treedt wel op bij bepaling van afstand tot (onbereikbare)
      // bestemming.
         if (Math.abs(getDistanceRemaining()) < KORTSTELOOPAFSTAND) {
         Point2D.Double testPositie;

         // try 200 times to ...
         for (int pogingen = 0; pogingen < 200; pogingen++) {
            // generate semi-random new position and ...
            testPositie = projecteerPositie( positie
                                           , TWEEPI * (randomWaardeEnHoek = Math.random())
                                           , (getOthers() > 3 ? 1D : 0.5D) * (108D + randomWaardeEnHoek * doel.distance(positie))
                                           );
            // test if it's better than the current destination (funny that after
            // shrinking the codesize this part of the code is now almost similar
            // to Rozu's code, although Rozu is far smarter and HawkOnFire out-classes
            // micro.Freya and her bigger sisters by far!)
            if (new RoundRectangle2D.Double(WANDAFSTAND, WANDAFSTAND, getBattleFieldWidth() - 2D * WANDAFSTAND,
            getBattleFieldHeight() - 2D * WANDAFSTAND, RONDING, RONDING).contains(testPositie) && weeg(testPositie,randomWaardeEnHoek) < weeg(bestemming,randomWaardeEnHoek)) {
               bestemming = testPositie;
            }
         }
      }

      // minimise the turning angle to the desired destination (nano-bot style of coding).
      setAhead(positie.distance(bestemming) * (double) ((randomWaardeEnHoek = Utils.normalRelativeAngle(bepaalRichting(positie, bestemming) - getHeadingRadians()))
                               != (randomWaardeEnHoek = Math.atan(Math.tan(randomWaardeEnHoek))) ? -1 : 1
                              )
              );
      setTurnRightRadians(randomWaardeEnHoek);
   }

   /**
    * Deze functie bepaalt het risico van de opgegeven positie. Bij de bepaling van het
    * risico worden de volgende afwegingen meegenomen:
    * <ul>
    * <li>afstand tot de huidige positie (verder weg is gunstiger)</li>
    * <li>de verhouding van de eigen energie tot die van de tegenstander (lager is gunstiger)</li>
    * <li>de hoek van de positie t.ov. de eigen positie en die van de tegenstander (de ontsnappingsrichting)</li>
    * <li>afstand tot de positie van de tegenstander (verder weg is gunstiger)</li>
    * </ul>
    *
    * @param p de positie waarvoo het risico moet worden bepaald
    * @param afstoting een parameter die aangeeft of de huidige positie moet worden afgestoten.
    *
    * @return het risico van de opgegeven positie
    */
   public double weeg(Point2D.Double p, double afstoting) {
      // (risk function taken from the description of Rozu's HawkOnFire on the robowiki.net)
      // determine risk of new position based on distance to current position
      double risico = Math.round(afstoting)/p.distanceSq(positie);

      // and distance, energy ratio and angle to all live opponents.
      //(d.treffersDoorDoel / d.treffersOpDoel)
//                     *
      for (Enumeration enm = doelen.elements(); enm.hasMoreElements();) {
         Doel d = (Doel) enm.nextElement();
         if (doel.actief) {
            risico += (Math.min((d.energie / getEnergy()), 3D)
                     * (1.0D + Math.abs(Math.cos(bepaalRichting(positie, p) - bepaalRichting(d, p)))))
                     / p.distanceSq(d);
         }
      }

      return risico;
   }

   /**
    * bepaal richting van bot tot doel-positie
    *
    * @param pos de start positie
    * @param richting de richting in radialen naar de te berekenen positie.
    * @param afstand de afstand tot de te berekenen positie.
    *
    * @return de berekende positie
    */
   private static Point2D.Double projecteerPositie(Point2D.Double pos, double richting, double afstand) {
      return new Point2D.Double(pos.x + afstand * Math.sin(richting), pos.y + afstand * Math.cos(richting));
   }

   /**
    * bepaal richting van bot tot doel-positie
    *
    * @param oorsprong de positie waar vandaan de hoek moet worden berekend
    * @param doel de positie waar naar de hoek moet worden berekend.
    *
    * @return de berekende hoek in radialen
    */
   private static double bepaalRichting(Point2D.Double oorsprong, Point2D.Double doel) {
      return Math.atan2((doel.x - oorsprong.x), (doel.y - oorsprong.y));
   }

   /**
    * innerclass voor de Tegenstander.
    */
   private static class Doel extends Point2D.Double {
//      String    naam;
      boolean   actief;
      double    richting;
      double    energie;
      double    snelheid;
      double    bewegingsrichting;
//      int       treffersOpDoel = 1; // door mij
//      int       treffersDoorDoel = 1; // op mij
   }
}
