package pa;
import robocode.*;
import java.util.Random;
import java.util.Date;
import java.awt.Color;
import java.awt.geom.Point2D;

public class Improved extends AdvancedRobot
{
	Random random = new Random();
	Date date = new Date();
	
	boolean walk = true;
	
	double xSize;
	double ySize;
	
	double stopped_ticks = 0;
	double unseen_ticks = 21;
	
	public void run() {
		random.setSeed(date.getTime());
		
		setColors(Color.black, Color.white, Color.gray, Color.red, Color.green);
		
		xSize = getBattleFieldWidth();
		ySize = getBattleFieldHeight();
		
		setAdjustGunForRobotTurn(true);
		
		while(true) {
			if (unseen_ticks > 20) {
				setTurnGunLeft(Double.POSITIVE_INFINITY);
				unseen_ticks = 0;
			}
			
			unseen_ticks++;
			execute();
		}
	}

	public void onScannedRobot(ScannedRobotEvent e) {
		double bearGun = nRelAngle(getHeading() + e.getBearing() - getGunHeading());

		if (Math.abs(bearGun) <= 3) {
			setTurnGunRight(bearGun);
			rFire (e.getDistance());
		}
		else {
			setTurnGunRight(bearGun);
		}
	
		if (bearGun == 0)
			setTurnGunRight(2);
	
		Walk(false);
		unseen_ticks = 0;
		execute();
	}

	public void onHitByBullet(HitByBulletEvent e) {
		Walk(true);
		execute();
	}

	public void onHitRobot (HitRobotEvent e) {
		double absBear = getHeadingRadians() + e.getBearingRadians();
		turnGunRightRadians(robocode.util.Utils.normalRelativeAngle(absBear - getGunHeadingRadians()));
		Walk(true);
		rFire(1);
	}			

	public void onHitWall (HitWallEvent e) {
		Walk (true);
	}

	public void rFire (double distance) {
		if (distance < 60)
			setFire(3);
		else if (distance < 130)
			setFire(2.5);
		else if (distance < 180)
			setFire(2);
		else if (distance < 230)
			setFire(1.5);
		else if (distance > 500)
			setFire(0.5);
		else
			setFire(1);
	}

	public void Walk (boolean isToWalk) {
		
		if (walk || isToWalk) {
			GoTo (getX(), getY(), random.nextInt((int)xSize)-25, random.nextInt((int)ySize)-25);
			walk = false;
		}
	
		if (stopped_ticks > 20) {
			stopped_ticks = 0;
			walk = true;
		}
	
		stopped_ticks++;
	}

	private void GoTo (double srcX, double srcY, double dstX, double dstY) {
		double distance = Point2D.distance(srcX, srcY, dstX, dstY);
		double angle = nRelAngle(absBear(srcX, srcY, dstX, dstY) - getHeading());
		if (Math.abs(angle) > 90) {
			distance *= -1;
			if (angle > 0.0)
				angle -= 180;
			else
				angle += 180;
		}
	
		setTurnRight(angle);
		setAhead(distance);
		
		walk = false;
	}

	private double absBear (double srcX, double srcY, double dstX, double dstY) {
		return Math.toDegrees(Math.atan2(dstX - srcX, dstY - srcY));
	}

	private double nRelAngle (double angle) {
		double relAngle = angle % 360;
		if (relAngle <= -180)
			return 180 + (relAngle % 180);
		else if (relAngle > 180)
			return -180 + (relAngle % 180);
		else
			return relAngle;
	}

}
																					