package lucasslf.wavesurfing.buffer;

import lucasslf.wavesurfing.EnemyWave;
import lucasslf.wavesurfing.BasicWaveSurfer;

public class SurfBufferO  extends SurfBuffer {
	private static double[][][][][]surfStats = new double[BasicWaveSurfer.SEG_WALL_PROXIMITY][BasicWaveSurfer.SEG_HEADING_DIFFERENCE][BasicWaveSurfer.SEG_VELOCITY][BasicWaveSurfer.SEG_DISTANCE][BasicWaveSurfer.BINS];
	public SurfBufferO(int weight) {
		super(weight);
	}
	public void setSegmentationOn(EnemyWave wave){
		wave.addSegmentedBuffer(getSegmentedBuffer(wave.getSegWallProximity(),wave.getSegHeadingDifference() , wave.getSegAdvancingVelocity(),wave.getSegInitialDistance()));
	}
	
	
	@Override
	public SegmentedBuffer getSegmentedBuffer(int... args) {
		if(args == null || args.length != 4)
			throw new IllegalArgumentException("args length must be 4");
		return new SegmentedBuffer(surfStats[args[0]][args[1]][args[2]][args[3]], this.getWeight());
	}

}
