package ph.intelligence;
import ph.*;
import robocode.util.*;
import java.awt.geom.*;

public class Wave {
    
    protected double power;
    protected double launchX;
    protected double launchY;
    protected long launchTime;
    protected double heading;
    protected int direction;
    protected int[] returnSegment;
    
    //protected long lastTime;
    
    /** Creates a new instance of Wave */
    public Wave(double launchX, double launchY, long launchTime,
    double power, double heading, int direction, int[] returnSegment) {
        this.launchX=launchX;
        this.launchY=launchY;
        this.launchTime=launchTime;
        this.power=power;
        this.heading=heading;
        this.direction=direction;
        this.returnSegment=returnSegment;
    }
    
    public static double getBulletSpeed(double power) {
        return 20-power*3;
    }
    
    public static double maxEscapeAngle(double power) {
        return Math.toDegrees(Math.asin(8/getBulletSpeed(power)));
    }
    
    public boolean checkHit(double enemyX, double enemyY, double enemyEnergy, long currentTime) {
        //if the distance from the wave origin to our enemy has passed the distance the bullet would have traveled...
        if (Point2D.distance(launchX, launchY, enemyX, enemyY) <= (currentTime-launchTime)*getBulletSpeed(power)) {
            if(enemyEnergy>0) {
                double desiredDirection = Math.toDegrees(Math.atan2(enemyX-launchX, enemyY-launchY));
                double angleOffset = utils.normalRelativeAngle(desiredDirection-heading);
                double guessFactor = Math.max(-1, Math.min(1, angleOffset/maxEscapeAngle(power)))*direction;
                int index = (int)Math.round(((returnSegment.length-1)*(guessFactor+1))/2);
                returnSegment[index]++;
            }
            return true;
        }
        return false;
    }
    
}
