package apv;
import robocode.*;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

/** MicroAspid - Aspid Series by Albert Prez 
* v 0.9 - First released version
* v 0.9.X (1,2,3) - Minor bugs fixed
* v 1.0 - Just found that 0.9 was to easy to hit, I concentrated on movement, but also the gun is improved
*		  Changed some parameters (pe. owindow)
*         Completely rewriten movement (now it is an avoider)
*		  Changed aiming by finding the best velocity/heading pattern independently
*		  Removed iterating aiming (just because I needed space for movement)
*		  Removed the (0,0)(800,600) limits check when firing (just because I needed space for movement)
*		  Added a check to avoid firing if it disables the bot (except when the other is disabled)
*		  Many tricks to reduce space
* v 1.1 - Reduced code size to make room for improvements
*		  Improved aiming algorithm (exp. smoothing weights more the recent points) 
* v 1.2 - Reduced codesize 
*		  Eliminated the adjutment based on pattern heading and actual heading
*		  Improved aiming - now pattern matching is truly independent
*		  Changed lenght of movement to variable arc based on robot name (hard coded)
* v 1.4 - Evolves from 1.2
*		  Completely new movement, similar to NekoNinja and DuelistMicro
*		  Random fire power selection
*		  Moved aiming to scan event to reduce size
*		  Eliminated iterative aiming to reduce size
*		  Eliminated enemy energy checks to reuce size
* v 1.4.1 Changed coordenates calculations to polar notation
* v 1.4.2 Optimized to keep firing when energy is low
*		  Optimized movement and radar codesize
* v 1.4.3 Evolves from 1.4.1
*		  Again a close range fighter
*		  Fires only at power 3
*		  Improved aiming (dimension and delay parameters added, value 7)
*		  Movement changed, now more agressive	
* v 1.4.4 Evolves from 1.4.1
*		  More distance to walls (now limit is  at 75)
*		  Codesize reduced without loosing functionality
*		  Improved aiming, now using embed and delay
* v 1.4.5 Improved aiming, now using a non parametric pattern matcher, that finds the longest sequence
*		  Uses a simplified version of Aspid 1.6.3 movement
*		  Fixed  bug in movement (nextMove was not initialized to 1)
*		  Changed the enemy position reconstruction algorithm (more precise, more efficient, smaller)
* v 1.4.6 Improved power management - keeps firing while available
*		  Change distance/5 to distance/10?
* v 1.5   Improved gun accuracy. Uses an exponential smooth to get better gun movement.
* 		  Radar changed to reduce codesize.
*         Rewrote some code to gain some bytes.
* v 1.5.1 Fixed a problem with radar (was lossing its lock from time to time)
* v 1.5.2 Back to previous movement
* v 1.6   Some changes to the pattern matcher to take advantage of the lessons learned in the PMC 
*         - added maxturn to divide difference in heading turn
*         - simplified pattern goodness calculation and reversed order
* v 1.7	  Released (failure) but code lost
* v 1.8   Evolves from 1.6
*		  Change in movement -> Movement adapted from RaikoNano
*/		  


public class MicroAspid extends AdvancedRobot
{

	static final double epsilon = 0.05;
			
	static double lastHeading; 
	static double[] ev = new double[75000];
	static double[] eh = new double[75000];
	static int n; 
	
	static double power;
	
	static double eGetDistance;
	static double targetBearing;
	
	static double predBearing;
	
	static double direction = 1, bulletVelocity;
	
	public void run() {

		setAdjustRadarForGunTurn(true);
		setAdjustGunForRobotTurn(true); 
		
		power = 3;
				
		do { if (getRadarTurnRemainingRadians() == 0) setTurnRadarRightRadians(Double.POSITIVE_INFINITY);
			 execute();
		} while (true); 
	}
	
	public void onScannedRobot(ScannedRobotEvent e) {
		//RADAR
		setTurnRadarRightRadians(Math.sin((targetBearing=e.getBearingRadians() + getHeadingRadians()) - getRadarHeadingRadians())*1.5);
		//ENEMY DATA
		eh[n] = e.getHeadingRadians() - lastHeading;
		lastHeading = e.getHeadingRadians();
		ev[n] = e.getVelocity();
		eGetDistance=e.getDistance();
		//AIMING & FIRING
		int match = 1+fitpattern();	
		double x = Math.sin(targetBearing)*eGetDistance; 
		double y = Math.cos(targetBearing)*eGetDistance;
		double ah = lastHeading; 
		int time = match;
		while (((match-time) * (20.0 - 3.0 * power)) < Point2D.distance(0,0,x,y)) {	
			x += Math.sin(ah)*ev[match];
			y += Math.cos(ah)*ev[match];	
			ah += eh[match];
			match++;
		}
		
		setTurnGunRightRadians(normalRelativeAngle((predBearing=0.7*predBearing+0.3*normalRelativeAngle(Math.atan2(x, y)-targetBearing))+targetBearing-getGunHeadingRadians()));

		if (getEnergy()<= 4) power = 0.2;
	    if (getEnergy()>= 2) setFire(power); 
		
		n = (++n) % 74900;		
		
		//MOVEMENT (Adapted from RaikoNano)
		double v1, v2, offset = 2;

		while(!new Rectangle2D.Double(18,18,764,564).contains(getX() + 160 * Math.sin(v2 = targetBearing + direction * (offset -= .02)), getY() + 160 * Math.cos(v2)));
		v1 = e.getDistance();
		if(Math.random() > Math.pow(v1 = 0.5952 * bulletVelocity / v1, v1) || offset < 0.7) direction = -direction; 

		setAhead(1000 * Math.cos(v2 -= getHeadingRadians()));
		setTurnRightRadians(Math.tan(v2));		
		
		
	}
		
	public int fitpattern() {	
		int match,len; match = len = 0; 
		for(int i = n-75; i > Math.max(0,n-5000); i--) {			
			double score = 0; int j = 0;  
			while (score<epsilon && i-j >= 0) {	
				score = Math.abs(ev[n-j] - ev[i-j])/8 + Math.abs(eh[n-j] - eh[i-j])/Math.toRadians(10-0.75*ev[n-j]);
				j++;
			}	
			if (j > len) { match = i; len = j; /* low = score; */ }	
		}
		return match;
	} 	
	
	public void onHitByBullet(HitByBulletEvent e) {	bulletVelocity = e.getVelocity(); }
			
	private double normalRelativeAngle(double angle) { return ((angle + 5*Math.PI) % (2*Math.PI)) - Math.PI; }			
		
}

														