package uccc.util;

public class Vec2 { 
	double x,y;
	public Vec2(Vec2 v)
	{
		x=v.getX();
		y=v.getY();
	}
	public Vec2(double angle, double mag) {
		x = mag*Math.cos(angle);
		y = mag*Math.sin(angle);
	}
	public void mult(double a) {
		x = x*a;
		y= y*a;
	}
	public void add(Vec2 v) {
		x += v.getX();
		y += v.getY();
	}
	public void sub(Vec2 v) {
		x -= v.getX();
		y -= v.getY();
	}
	public double getX() {
		return x;
	}
	public double getY() {
		return y;
	}
	public void set(double angle, double mag) {
		x = mag*Math.cos(angle);
		y = mag*Math.sin(angle);
	}
	public double dot(Vec2 v) {
		return x*v.getX() + y*v.getY();
	}
	public double getMag() {
		return Math.sqrt(x*x+y*y);
	}
	public double getMagSquared() {
		return x*x+y*y;
	}
	public double getAngle() {
		double a=0;
		if (x==0) {
			if (y>0) {
				return Math.PI/2;
			}	
			return 3*Math.PI/2;
		}
	
		if (y>0 && x>0) {
			a= Math.atan(y/x);
		}
		if (y>0 && x<0) {
			a = Math.PI - Math.atan(y/x*-1);	
		}
		if (y<0 && x<0) {
		 	a = Math.PI + Math.atan(y/x);	
		}
		if (y<0 && x>0) {
			a = 2 * Math.PI - Math.atan(y/x*-1);	
		}
		return a;
	}
	public void normalize() {
		double mag = getMag();
		x=x/mag;
		y=y/mag;	
	}
	public static Vec2 getOrtho(Vec2 v) {
		Vec2 w = new Vec2(v.getAngle()+1, 1);
		v.mult( v.dot(w) / (v.getMag() * v.getMag() ) );
		w.sub(v);
		return w;
	}
	public static Vec2 proj(Vec2 a, Vec2 basis) {
		Vec2 r = new Vec2(basis);
		r.mult(a.dot(basis)/basis.getMagSquared());
		return r;
	}
}
