/*
 * Created on Jun 14, 2004
 *
 * To change the template for this generated file go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
 */
package jekl.utils;

import robocode.util.Utils;
import java.awt.geom.*;
import jekl.*;



/**
 * @author Jim
 *
 * To change the template for this generated type comment go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
 */
public class JeklUtils implements Constants {
		
	//Helper to get the abs bearing between two points
	public static double getAbsBearing(Point2D.Double origin, Point2D.Double destination) {
		return Math.atan2(destination.x - origin.x, destination.y - origin.y);
	}

	//Retrieve the bullets velocity
	public static double bulletV(double shotPower) {
		return (20.0D - (3 * shotPower));
	}

	//Return the wall index
	public static int getOutIndex(Point2D.Double loc, double heading, int direction) {
		Point2D.Double location = new Point2D.Double();
		location.setLocation(loc);
		for (int i = 1; i <= 4; i++) {
			location.setLocation(location.x + (Math.sin(heading) * (WALL_OUT_TEST_DISTANCE * (i)) * direction), 
				(location.y + (Math.cos(heading) * (WALL_OUT_TEST_DISTANCE * (i)) * direction)));
			if (!DarkHallow.field.contains(location)) {
				return i;
			}
		}
		return (0);
	}

	public static int getDistanceIndex(Enemy target) {
		return (int)(target.getDistance() / DIST_BUCKET_SIZE);
	}

	public static double angleBetween(Point2D.Double origin, Point2D.Double p1, Point2D.Double p2){
		return Utils.normalRelativeAngle(getAbsBearing(origin, p1) - getAbsBearing(origin, p2));
	}

	public static void debugArray(int[] ints) {
		for (int i = 0; i < ints.length; i++) {
			if (i % 5 == 0) {
				System.out.print(" " +  i + " ");
			}
			System.out.print("[" + ints[i] + "]");
		}
		System.out.println("\n-------");
	}

	public static double minMax(double checkVal, double min, double max) {
		return Math.max(min, Math.min(max, checkVal));
	}
	
	public static int getFlightTime(double shotPower, Enemy target) {
		return (int)(target.getDistance() / bulletV(shotPower));
	}

	//Paul Evan's Rolling Average function
	public static float rollingAverage(float n, float oldVal, float entry){
		return (n*oldVal + entry)/(n + 1F);
	}

    //Stolen from kawigi
    public static boolean out(Point2D.Double p, double bearing, double distance, int direction) {
        return !(DarkHallow.field.contains(((Math.sin(bearing) * distance) * direction) + p.x, ((Math.cos(bearing) * distance) * direction) + p.y));
    }
    
    public static double sign (double value) {
    	return (Math.abs(value) / value);
    }

	public static double backAsFrontHeading(double angle) {
		return Math.atan(Math.tan(angle));
	}
	
	public static int backAsFrontDirection(double angle) {
		return (angle == backAsFrontHeading(angle)) ? 1 : -1;
	}

}
