package ags.rougedc.waves;

import ags.rougedc.robots.*;
import ags.utils.points.*;
import robocode.Rules;

/**
 * A class for enemy waves
 * 
 * @author Alexander Schultz
 */
public class EnemyWave extends Wave {
    private StatusRobot statictarget;
    private StatusRobot target;
    private EnemyRobot source;
    private double[][] dangerpoints = null;
    
    public EnemyWave(EnemyRobot source, AbsolutePoint sourcepoint, StatusRobot status, double power, long timeago) {
        // Use their location last tick, because that's where they fired from!
        super(sourcepoint, power, timeago*Rules.getBulletSpeed(power));
        // It us 2 ticks ago! (when their last scan before firing was from)
        this.statictarget = status;
        this.target = status;
        this.source = source;
    }
    
    public EnemyWave(EnemyWave w) {
        super(w);
        statictarget = w.statictarget;
        target = w.target;
        source = w.source;
        dangerpoints = w.dangerpoints;
    }
    public EnemyWave clone() {
        return new EnemyWave(this);
    }
    
    public void setDangerPoints(double [][] d) {
        dangerpoints = d;
        
        // If we haven't been hit yet, pretend we were at GF 0
        if (dangerpoints[1].length == 0) {
            dangerpoints = new double[2][1];
            dangerpoints[0][0] = 0.0;
            dangerpoints[1][0] = 1;
        }
    }
    
    public double[][] getDangerPoints() {
        return dangerpoints;
    }
    
    public EnemyRobot getSource() {
        return source;
    }
    
    @Override
    public void move() {
        super.move();
    }
    
    @Override
    public StatusRobot getStaticTarget() {
        return statictarget;
    }
    
    public StatusRobot getTarget() {
        return target;
    }
}
