package sam;
import robocode.*;
import bayen.*;
import java.awt.geom.*;
import robocode.util.*;
/**
 * ChipmunkDuelist - a robot by Sam
 */
public class ChipmunkDuelist extends DuelRobot
{
	double enemyEnergy = 100.0;
	double dir = 1;
	static boolean surf = true;
	static int move = 0;
	static double hits = 1;
	static double misses = 0;
	public void onMove() {
		if(surf)
		setDropSurf();
		else
		setMultiMode();
	}
	public void onHitWall(HitWallEvent e, boolean duel) {
		dir = -dir;
	}
	public void setMultiMode() {
		if(move == 0)setOrbit(dir);
		if(move == 1)setOrbit(dir);
		if(move == 2)setOrbit(dir);
		if(move == 3)setOrbit(dir);
	}
	public void setDropSurf() {
		if(enemyEnergy > (enemyEnergy = e.getEnergy())) {
			dir = -dir;
		}
		setOrbit(dir,225);
	}
	public void onHitByBullet(HitByBulletEvent e, boolean duel) {
		if(!surf) {
			move++;if(move > 3)move=0;
			surf = true;
		}
		else {
			surf = false;
		}
	}
	static double BULLET_POWER = 3.0;
    static double BULLET_VELOCITY = 20 - 3 * BULLET_POWER;

    static final int AIM_FACTORS = 25;
    static final int MIDDLE_FACTOR = (AIM_FACTORS - 1) / 2;

    static double enemyX;
    static double enemyY;
    static int[] aimFactors = new int[AIM_FACTORS];
	public void onGun() {
		double accuracy = hits / (hits + misses);
		BULLET_POWER = 600 / e.getDistance();
		if(BULLET_POWER > 3.0) BULLET_POWER = 3.0;
		BULLET_VELOCITY = 20 - 3 * BULLET_POWER;
		Wave wave;
		addCustomEvent(wave = new Wave());
		wave.wGunX = getX();
		wave.wGunY = getY();
        double enemyAbsoluteBearing = getHeadingRadians() + e.getBearingRadians();
		enemyX = wave.wGunX + Math.sin(enemyAbsoluteBearing) * e.getDistance();
		enemyY = wave.wGunY + Math.cos(enemyAbsoluteBearing) * e.getDistance();

		wave.wBearingDirection = (e.getVelocity() * Math.sin(e.getHeadingRadians() - enemyAbsoluteBearing) < 0 ? -1 : 1) * 0.8 / (double)MIDDLE_FACTOR;
		wave.wBearing = enemyAbsoluteBearing;

		int mostVisited = MIDDLE_FACTOR;
		for (int i = 0; i < AIM_FACTORS; i++) {
		    if (aimFactors[i] > aimFactors[mostVisited]) {
				mostVisited = i;
		    }
		}
		setTurnGunRightRadians(Utils.normalRelativeAngle(enemyAbsoluteBearing - getGunHeadingRadians() +
	    	wave.wBearingDirection * (mostVisited - MIDDLE_FACTOR)));

		setFire(BULLET_POWER);
	}
	public void onBulletHit(BulletHitEvent e, boolean duel) {
		hits++;
	}
	public void onBulletMissed(BulletMissedEvent e, boolean duel) {
		misses++;
	}
	class Wave extends Condition {
	double wGunX;
	double wGunY;
	double wBearing;
	double wBearingDirection;
	double wDistance;

	public boolean test() {
	    if ((wDistance += BULLET_VELOCITY) > Point2D.distance(wGunX, wGunY, enemyX, enemyY)) {
		try {
		    aimFactors[(int)((Utils.normalRelativeAngle(Math.atan2(enemyX - wGunX, enemyY - wGunY) - wBearing)) /
				wBearingDirection) + MIDDLE_FACTOR]++;
		}
		catch (Exception e) {
		}
		removeCustomEvent(this);
	    }
	    return false;
	}
    }
}
