package pl.Utilities;

/*******************************************************************************
 * A class with a few useful methods for use in Robocode that don't quite fit
 * anywhere else. All methods are static for ease of use.
 ******************************************************************************/
public class MiscUtils {
	/**
	 * Gives a value based on the value of the given number
	 * 
	 * @param a number to 'sign'
	 * @return 1 if the a >= 0; -1 if not
	 */
	public static int sign(double a) {
		return a < 0 ? -1 : 1;
	}

	/**
	 * Limits the value to whithin the minimum and maximum values (both
	 * inclusive)
	 * 
	 * @param min minimum value
	 * @param max maximum value
	 * @param value value to limit
	 * @return limited value
	 */
	public static double limit(double min, double max, double value) {
		return Math.min(max, Math.max(min, value));
	}

	/**
	 * Calculates a point using projection
	 * 
	 * CREDIT: PEZ
	 * 
	 * @param source location of original point
	 * @param angle angle to project
	 * @param length distance to project
	 * @return projected location
	 */
	public static java.awt.geom.Point2D.Double project(java.awt.geom.Point2D.Double source,
			double angle, double length) {
		return new java.awt.geom.Point2D.Double(source.x + Math.sin(angle) * length, source.y
				+ Math.cos(angle) * length);
	}
}
