package jeremyreeder;
import robocode.*;
import robocode.util.*;
import java.awt.Color;
import java.util.*;
import java.lang.Math;

// API help : http://robocode.sourceforge.net/docs/robocode/robocode/RateControlRobot.html

/**
 * Vincent - a robot by Jeremy Reeder
 */
public class Vincent extends RateControlRobot {
	private double enemyGunHeat = 0;
	private double lastEnemyEnergy = 0;
	private int enemyCount;
	private final double mediumHeat = 0.8;
	private int headingOffsetSign = 1;
	private void toggleHeadingOffsetSign() {
		headingOffsetSign = -headingOffsetSign;
	}
	private int getHeadingOffset() { // don't go directly toward or directly away from an enemy who has just fired
		int offsetAngle = -60;
		if (
			enemyGunHeat <= mediumHeat || ( // relatively cool gun means it probably hasn't just fired and is safe to approach directly
				getVelocity() > 0 && (
					getX() < 48 || getX() > getBattleFieldWidth() - 48 || getY() < 48 || getY() > getBattleFieldHeight() - 48
				) // if close to a wall, going directly toward enemy avoids wall collision
			)
		) return 0; // head directly toward enemy
		else
			return offsetAngle * headingOffsetSign; // approach at an angle when a bullet has just fired
	}
	public void run() {
		setColors(Color.blue, Color.white, Color.blue); // body,gun,radar
		setAdjustGunForRobotTurn(true);
		setAdjustRadarForGunTurn(true);
		enemyCount = getOthers() + 1;
		while (true) {
			if (getOthers() < enemyCount) { // each time an enemy dies, reinitialize scanner
				enemyCount--;
				enemyGunHeat = 1.1 + Rules.MAX_BULLET_POWER / 5;
				lastEnemyEnergy = 0;
				setVelocityRate(0);
				double turnRate = Rules.MAX_TURN_RATE;
				double gunRotationRate = turnRate + 20;
				double radarRotationRate = gunRotationRate + 45;
				if (getRadarRotationRate() > 0) {
					turnRate = -turnRate;
					gunRotationRate = -gunRotationRate;
					radarRotationRate = -radarRotationRate;
				}
				setTurnRate(turnRate);
				setGunRotationRate(gunRotationRate);
				setRadarRotationRate(radarRotationRate);
				setVelocityRate(0);
			}
			enemyGunHeat = max(0, enemyGunHeat - 0.1);
			execute();
		}
	}

	/**
	 * onScannedRobot: What to do when you see another robot
	 */
	public void onScannedRobot(ScannedRobotEvent e) {
		// dodge bullets
			double energyDrop = lastEnemyEnergy - e.getEnergy();
			if (energyDrop >= 0.1 && energyDrop <= 3) {
				enemyGunHeat += 1 + energyDrop / 5;
				enemyGunHeat = max(enemyGunHeat, 1.6);
			}
			final double widthFudge = 1.125; double robotWidth = 16 * widthFudge;
			double radarOffset = 2 * java.lang.Math.atan(robotWidth / (e.getDistance() - robotWidth) * 360 / (2 * 3.141592653)); // limit scan range
			if (getRadarRotationRate() > 0)
				radarOffset = -radarOffset; // alternate scan direction
			setRadarRotationRate(e.getBearing() + getHeading() - getRadarHeading() + radarOffset);
		// charge or retreat
			setVelocityRate(e.getDistance() - 96 - java.lang.Math.abs(e.getTime() % 64 - 32) * 6);
			if (e.getEnergy() == 0 || getEnergy() < Rules.MAX_BULLET_POWER)
				setVelocityRate(e.getDistance());
			// don't crash
				if (getX() < 48 || getX() > getBattleFieldWidth() - 48 || getY() < 48 || getY() > getBattleFieldHeight() - 48)
					setVelocityRate(max(getVelocityRate(), -1.999)); // back slowly into walls
			double turnRate = e.getBearing() + getHeadingOffset();
			while (turnRate > 180) turnRate -= 360;
			while (turnRate < -180) turnRate += 360;
			setTurnRate(turnRate);
		// shoot enemy
			double absoluteBearing = getHeadingRadians() + e.getBearingRadians();
			double gunRotationRate = (
				Utils.normalRelativeAngle(
					absoluteBearing - getGunHeadingRadians() + (
						e.getVelocity() * Math.sin(
							e.getHeadingRadians() - absoluteBearing
						) / 13.0
					)
				) * 360 / (2 * 3.141592653)
			);
			setGunRotationRate(gunRotationRate);
			if (java.lang.Math.abs(getGunRotationRate()) < 5 && getEnergy() > Rules.MAX_BULLET_POWER)
				setFire(Rules.MAX_BULLET_POWER); // fire it won't disable you and the enemy's in your sights
		// update variables
			lastEnemyEnergy = e.getEnergy();
			if (e.getDistance() > 1200 - Rules.MAX_VELOCITY * 2)
				enemyCount++; // force rescan, because we are in danger of losing this enemy if he moves quickly
	}
	public void onHitWall(HitWallEvent e) {
		toggleHeadingOffsetSign();
	}
	private double min(double x, double y) { if (x < y) return x; else return y; }
	private double max(double x, double y) { if (x > y) return x; else return y; }
}
	
