package tm;
import robocode.*;
import java.awt.Color;
import java.util.*;

/********************************************************************
* Yuugao.java -- based on YuugaoKAI15
*                YuugaoKAI -- "KAI" means "improved".
*
*
* Date:		2002/Nov/16 Version 0.1
*			2002/Nov/23	Version 0.2 JapanCup2002 version
*			2002/Dec/27 Version 0.9 Christmas version
*			2003/Jan/31 Version 1.0
*
* Author:	Matunaga Takateru@RISE, Eng, Kagawa Univ.
*			http://douglass.eng.kagawa-u.ac.jp/~matu/robocode.html
*
*******************************************************************/
public class Yuugao extends MyRobot {
	RadarTurnCompleteCondition radarCond = new RadarTurnCompleteCondition(this);
	WallNearCondition wallNearCond = new WallNearCondition(this);
	
	Move moveCorner, moveLR4, moveGravity2, moveCornerSq, move1on1Melee;
	Gun gun15B, gun16BFew, gun1on1Melee;
	Radar radar360B;
	
	boolean oneOnOne = false;
	
	public void run() {
		M.print("Hi! I am Yuugao.");
		M.print("Yuugao means a moonflower.");
		init();
			
		setColors(Color.orange, Color.orange, new Color(150, 255, 150));
		addCustomEvent(radarCond);

		ehis = new EnemyHistory3(100);
		robotKKZ = new RobotKKZ_YK04(this);
		
		moveCorner = new MoveCornerY(this);
		moveLR4 = new MoveLR4(this);
		moveGravity2 = new MoveGravity2(this);
		moveCornerSq = new MoveCornerSquare(this);
		move1on1Melee = new Move1on1LRrand4away5Melee(this);
				
		radar360B = new Radar360B(this);
		gun15B = new Gun15B(this);
		gun16BFew = new Gun16BFew(this);
		gun1on1Melee = new Gun1on1_102C22iMelee(this);
				
		if (getOthers() != 1) {
			//Melee
			M.print("Melee mode");
			
			selecter.setMelee();
			
			//for Eternal Rumble CL
			if (getOthers() > 3) gun = gun15B;
			else                 gun = gun16BFew;
			
			radar = radar360B;
			move = moveGravity2;

			setTurnRadarRight(360);
			execute();	

			while(true) {
				move.setNextPoint();
				gun.fire();
				execute();
				selectStrategy();
			}
		} else {
			//1 on 1
			M.print("1 on 1 mode");
			selecter.init();
			oneOnOne = true;
			gun = robotKKZ;
			radar = robotKKZ;
			move = robotKKZ;

			setTurnRadarRight(360);
			execute();	

			while (true) {
				robotKKZ.run();	
			}
		}
	}


	//------------------------------------------------------------------
	// selectStrategy()
	//
	//
	//------------------------------------------------------------------
	void selectStrategy() {

		double CMARGIN = 250;			//R[i[͈
		Enemy ene = map.getNearestEnemy(getTime());
		
		if (ene == null) return;
		if (getOthers() == 1) return;
		if (getTime() < 80) return;
		
		double xx = Math.min(getX(), fW - getX());
		double yy = Math.min(getY(), fH - getY());
		

		
		//G߂
		if (move instanceof MoveLR4) {
			if (ene.getDistance() >= 250) {
				removeCustomEvent(wallNearCond);
				move = moveGravity2;
				move.init();			
			}	
		}
		if (ene.getDistance() < 200) {
			if (move instanceof MoveLR4) return;
			removeCustomEvent(wallNearCond);
			move = moveLR4;
			move.init();
			return;	
		}

		
		//R[i[߂
		if (xx < CMARGIN && yy < CMARGIN) {
			if (getOthers() > 4) {
				if (move instanceof MoveCornerY) return;
				addCustomEvent(wallNearCond);
				move = moveCorner;
				move.init();
				return;
			} else {
				if (move instanceof MoveCornerSquare) return;
				removeCustomEvent(wallNearCond);
				move = moveCornerSq;
				move.init();
				return;			
			}
		}
		
	}

	
	//---------------------------------------------------------
	// isNearCorner() -- R[i[߂H
	//
	//
	//---------------------------------------------------------
	boolean isNearCorner() {
		final int CMARGIN = 250;
		double xx = Math.min(getX(), fW - getX());
		double yy = Math.min(getY(), fH - getY());
		
		if (xx < CMARGIN && yy < CMARGIN) {
			return true;
		}
		return false;
	}
	
	/**
	 * onScannedRobot: What to do when you see another robot
	 */
	public void onScannedRobot(ScannedRobotEvent e) {
		move.scannedRobot(e);
		
		//
		if (!oneOnOne) {
			double x, y;
			double absoluteBearing = (360 + e.getBearing() + getHeading() ) % 360;
			x = getX() + Math.cos(Math.toRadians(90-absoluteBearing)) * e.getDistance();
			y = getY() + Math.sin(Math.toRadians(90-absoluteBearing)) * e.getDistance();		
		
			gun.put(x, y, e.getDistance(), e.getVelocity(), e.getHeading(), absoluteBearing, getTime(), e.getName());
		}
	}

	/* death */
	public void onDeath(DeathEvent e) {
		print("I shall return.");
		if (oneOnOne) robotKKZ.death();
	}	
	
	/* win */
	public void onWin(WinEvent e) {
		print("I won!");
		if (oneOnOne) robotKKZ.win();
		
		removeCustomEvent(radarCond);
		map.clear();
		
		winDance();
	}

	/* onRobotDeath() */
	public void onRobotDeath(RobotDeathEvent e) {
		
		switch (getOthers()) {
			case 1:
				removeCustomEvent(wallNearCond);
				move = move1on1Melee;
				move.init();
				radar = robotKKZ;
				gun = gun1on1Melee;
				map.clear();
				break;
			case 5:
				if (move instanceof MoveCornerY) return;
				addCustomEvent(wallNearCond);
				move = moveCorner;
				move.init();
				break;
			case 3:
				gun = gun16BFew;
				break;
			default:
				;
		}

	}

	/* hit by bullet */
	public void onHitByBullet(HitByBulletEvent e) {
		move.hitByBullet(e);
	}

	/* onBulletHit  */
	public void onBulletHit(BulletHitEvent e) {
		gun.bulletHit(e);
	}
	
	/************************************
	 * JX^Cxg
	 */
	public void onCustomEvent(CustomEvent e) {
		Condition condition = e.getCondition();
		
		if (condition instanceof RadarTurnCompleteCondition) {
			//[_[]
			radar.radarTurnComplete();
		} else if (condition instanceof BulletTracker) {
			//CeC͂
			gun.bulletTrackComplete((BulletTracker)condition);	
		} else if (condition instanceof WallNearCondition) {
			//ǋ߂
			move.wallNear();	
		}
	}
	
}