package tjk.universe;

import robocode.Rules;
import tjk.utils.FastTrig;

/**
 * Segmentation - a class by tkiesel
 * Copyright (c) 2012 Tom Kiesel (Tkiesel @ Robowiki)
 * 
 * This software is provided 'as-is', without any express or implied warranty. In no event will the authors be held liable for any damages arising from the use of this software.
 * 
 * Permission is granted to anyone to use this software for any purpose, including commercial applications, and to alter it and redistribute it freely, subject to the following restrictions:
 * 
 *     1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. 
 *        If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
 * 
 *     2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
 * 
 *     3. This notice may not be removed or altered from any source distribution.
 * 
 */

public class Segmentation
{
	
	public static int DIMENSIONS = 10; //10 or 7
	
	// 10 version
	// distance, latV, flightTime, accel, advancingV, timeSinceVzero, timeSinceVChange, forwardWallD, backwardWallD, lateralWallD
	public static double[] WEIGHTS = {4.0, 3.0, 1.0, 1.0, 1.0, 1.0, 1.5, 1.25, 1.0, 1.25};
	
	// 7 version
	// distance, latV, flightTime, accel, advancingV, timeSinceVzero, timeSinceVChange, forwardWallD, lateralWallD
	//public static double[] WEIGHTS = {4.0, 3.0, 1.0, 1.0, 1.5, 1.25, 1.25};
	
	
	public static double MAX_FLIGHT_TIME = -1;
	
	public static double[] situation(Bot b, Bot e, boolean realWave, double power)
	{
	
		double bulletV = Rules.getBulletSpeed(power);
		
		// 10 version
		double[] sit = {distance(b,e),latV(b,e),flightTime(b,e,bulletV),accel(e),adV(b,e),timeSinceVZero(b,e,bulletV),timeSinceVChange(b,e,bulletV),closestForwardWallD(e),closestBackwardWallD(e),closestLateralWallD(e)};
		
		// 7 version
		//double[] sit = {distance(b,e),latV(b,e),accel(e),timeSinceVZero(b,e,bulletV),timeSinceVChange(b,e,bulletV),closestForwardWallD(e),closestLateralWallD(e)};
		
		return sit;
	}
	
	public static double distance(Bot b, Bot e)
	{
		return b.getLocation().distance(e.getLocation()) / Universe.bfDiag();
	}
	
	public static double flightTime(Bot b, Bot e, double bulletV)
	{
		if ( MAX_FLIGHT_TIME <= 0 )
		{
			MAX_FLIGHT_TIME = Universe.bfDiag()/Rules.getBulletSpeed(Rules.MAX_BULLET_POWER);
		}
		return ( b.getLocation().distance(e.getLocation())/bulletV  ) / MAX_FLIGHT_TIME;
	}
	
	public static double closestForwardWallD(Bot e)
	{
		return Math.pow( e.closestForwardWallD() / (Math.max(Universe.bfW(),Universe.bfH())/2.0) , 0.3333);
	}
	
	public static double closestBackwardWallD(Bot e)
	{
		return Math.pow( e.closestBackwardWallD() / (Math.max(Universe.bfW(),Universe.bfH())/2.0) , 0.3333);
	}

	public static double closestLateralWallD(Bot e)
	{
		return Math.pow( e.closestLateralWallD() / (Math.max(Universe.bfW(),Universe.bfH())/2.0) , 0.3333);
	}
	
	public static double accel(Bot e)
	{
		return Math.abs( e.getA() )/Rules.DECELERATION;
	}

	public static double latV(Bot b, Bot e)
	{
		return Math.abs( e.getV()*FastTrig.sin(e.getHeading()-Bot.headingFromTo(b,e)) )/Rules.MAX_VELOCITY;
	}
	
	public static double adV(Bot b, Bot e)
	{
		return ( e.getV()*FastTrig.cos(e.getHeading()-Bot.headingFromTo(b,e)) )/(2.0*Rules.MAX_VELOCITY)+0.5;
	}
	
	public static double timeSinceVZero(Bot b, Bot e, double bulletV)
	{
		double flightTime = b.getLocation().distance(e.getLocation())/bulletV;
		return Math.min(3.0,e.timeSinceVZero()/flightTime)/3.0;
	}
	
	public static double timeSinceVChange(Bot b, Bot e, double bulletV)
	{
		double flightTime = b.getLocation().distance(e.getLocation())/bulletV;
		return Math.min(3.0,e.timeSinceVChange()/flightTime)/3.0;
	}
	
}