/*
 * Created on 16/10/2003
 *
 * To change the template for this generated file go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
package axeBots.gunner;
import java.awt.geom.*;

import axeBots.AxeBot;
import axeBots.musashi.*;
import axeBots.util.*;

import robocode.Condition;

/**
 * @author Marcos
 *
 * To change the template for this generated type comment go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
public class AxeVB extends Condition {

    private AxeBot me= null;
    private AxeTarget target= null;
    private double bulletVel= 0;
    private double firedTime= 0;
    private int id= 0;
    private AxeVBListener listen= null;

    private double botDelta;
    private double targetAngle;
    private double targetDistance;
    private double opps;

    private AxeVector bulletPath= null;
    private Boolean hit= null;
    private double impactAngle= 0;
    private AxeVector impactVector= null;

    private Point2D.Double originalPos= null;
    private String dbgInfo= "";
    /**
     * 
     */
    public AxeVB(AxeBot me, AxeTarget target, AxeVBListener listen,

    //double firedAngle,
    double bullVel,
        int id,
        Point2D.Double targetPos,
        double targetAngle,
        double targetDist,
        double opps,
        String dbgInfo) {
        super();
        this.listen= listen;
        this.me= me;
        this.target= target;
        botDelta= me.getHeight() * (Math.sqrt(2)); // / 2;
        this.id= id;
        this.firedTime= me.getTime();
        this.bulletVel= bullVel;
        this.targetAngle= targetAngle;
        this.targetDistance= targetDist;
        this.opps= opps;
        this.originalPos= target.pos();
        this.dbgInfo= dbgInfo;
        bulletPath= new AxeVector(me.pos(), targetPos);
        me.addCustomEvent(this);
        //        me.out.println(
        //            " DISPAROU: ANG:" + firedAng + this +" " + (Object)listen);
    }

    /* (non-Javadoc)
     * @see robocode.Condition#test()
     */
    public boolean test() {
        //        me.out.println(
        //            " TESTANDO!!"
        //                + this
        //                + " "
        //                + (Object)listen
        //                + " BPATH:"
        //                + bulletPath.getRelativeModule()
        //                + " D:"
        //                + bulletPath.getStartPoint().distance(target.pos()));
        this.updateBulletPos();
        if (this.isImpactTime()) {
            impactVector=
                new AxeVector(bulletPath.getStartPoint(), target.pos());
            impactAngle=
                RoboMath.normalRelativeAngle(
                    this.impactVector.getRelativeTheta());
            //			me.out.println(
            //					            "VB: FIRED:"+this.firedTime +" now:" + me.getTime());
            listen.setImpactAngle(this);
        }
        if (target
            .getBotShape()
            .contains(bulletPath.getX(), bulletPath.getY())) {
//            me.out.println(">>>>>>>>>    ACERTOU!! " + this);
            hit= new Boolean(true);
            listen.updateVB(this);
            //            me.out.println(
            //                " ATUALIZOU!!"
            //                    + this
            //                    + " "
            //                    + ((AxeGunner)listen).getRatings().getString(
            //                        opps,
            //                        targetAngle,
            //                        targetDistance));
            me.removeCustomEvent(this);
        } else if (
            bulletPath.getRelativeModule()
                > (bulletPath.getStartPoint().distance(target.pos())
                    + botDelta)) {

            //						me.out.println(
            //													"%%%%%%%%%%%%%%%%%%    ERROU!! "
            //														+ this
            //														);
            //            me.out.println(
            //                " ERROU!!"
            //                    + this
            //                    + " "
            //                    + ((AxeGunner)listen).getRatings().getString(
            //                        opps,
            //                        targetAngle,
            //                        targetDistance));
            hit= new Boolean(false);
            listen.updateVB(this);
            //            me.out.println(
            //                " ATUALIZOU!!"
            //                    + this
            //                    + " "
            //                    + ((AxeGunner)listen).getRatings().getString(
            //                        opps,
            //                        targetAngle,
            //                        targetDistance));
            me.removeCustomEvent(this);
            //errou
        }

        return false;
    }

    private void updateBulletPos() {
        double mod= (me.getTime() - firedTime) * bulletVel;
        bulletPath.setModule(mod);
        //        me.out.println(
        //            "VB: at " + me.getTime() + " mod:" + mod + " bulvel:" + bulletVel);
    }

    private boolean isImpactTime() {
        return Math.abs(
            bulletPath.getRelativeModule()
                - (bulletPath.getStartPoint().distance(target.pos())))
            <= (this.bulletVel / 2);
    }

    public String toString() {
        return "VIRTUAL BULLET "
            + Stratego.getStratName(id)
            + " FIRED AT "
            + this.firedTime
            + " "
            + dbgInfo;
    }

    /**
     * @return
     */
    public Boolean getHit() {
        return hit;
    }

    /**
     * @return
     */
    public double getOpps() {
        return opps;
    }

    /**
     * @return
     */
    public double getTargetAngle() {
        return targetAngle;
    }

    /**
     * @return
     */
    public double getTargetDistance() {
        return targetDistance;
    }

    /**
     * @param boolean1
     */
    public void setHit(Boolean boolean1) {
        hit= boolean1;
    }

    /**
     * @param d
     */
    public void setOpps(double d) {
        opps= d;
    }

    /**
     * @param d
     */
    public void setTargetAngle(double d) {
        targetAngle= d;
    }

    /**
     * @param d
     */
    public void setTargetDistance(double d) {
        targetDistance= d;
    }

    /**
     * @return
     */
    public AxeBot getMe() {
        return me;
    }

    /**
     * @return
     */
    public AxeTarget getTarget() {
        return target;
    }

    /**
     * @return
     */
    public double getImpactAngleDiff() {
        double referenceZero=
            RoboMath.normalRelativeAngle(
                (new AxeVector(bulletPath.getStartPoint(), this.originalPos))
                    .getRelativeTheta());
        return RoboMath.normalRelativeAngle(impactAngle - referenceZero);
    }

    public double getImpactAngle() {
        return impactAngle;
    }

    /**
     * @param d
     */
    public void setImpactAngle(double d) {
        impactAngle= d;
    }

    /**
     * @return
     */
    public Point2D.Double getOriginalPos() {
        return originalPos;
    }

    /**
     * @return
     */
    public double getBulletVel() {
        return bulletVel;
    }

    /**
     * @param d
     */
    public void setBulletVel(double d) {
        bulletVel= d;
    }

}
