package ers.nano.iSuck;

/**
 * Creator: ER Samson
 * 
 * Credits:
 * Movement - https://mark.random-article.com/robocode/improved_movement.html
 * 			  https://robowiki.net/wiki/User:Exauge/snippets
 *            https://robowiki.net/wiki/Oscillator_Movement
 * 
 * Radar - http://robowiki.net/wiki/One_on_One_Radar
 * 
 * Gun Targetting - https://robowiki.net/wiki/User:Exauge/snippets#Pattern_Matching_Gun
 *                  https://robowiki.net/wiki/WeekendObsession
 * 
 * Tips from Sheldor and Skilgannon's Yatagan - https://robowiki.net/wiki/Yatagan
 * 
 * Symbolic Pattern String from Sheldor's Foilist - https://robowiki.net/wiki/Foilist
 */

import robocode.*;
import robocode.util.Utils;
//import java.awt.*;

public class ISuckNano extends AdvancedRobot {

	static final double bPow = 2; // Bullet Power
	static final int bVel = (int)(20-3*bPow);
	static final int patDep = 30;
	
	static int mvD = 1; // Move Direction
	static double he; // Enemy Energy

	public void run() {
		// Color Identification
		//setColors(Color.blue, Color.red, Color.orange);

		// Easy targeting and infinite radar movement
		//setAdjustGunForRobotTurn(true); // Saving 5 code size!
	    setTurnRadarRightRadians(Double.POSITIVE_INFINITY);
	}

	public void onScannedRobot(ScannedRobotEvent e) {
		// ---------- Generic Variables ----------
		int mLen = patDep; // for PM gun, arranged like so to save codesize!

		double absB, /*aRF,*/ eD;
		// absB - Absolute Bearing
		// aRF - Anti-Ram factor
		// eD - Enemy Distance

		int i, indX;  // for PM gun
		
		// ---------- Musashi Movement Logic ----------
		// Turn perpendicular to enemy, try to close in slowly, no wall avoidance D:
		//setTurnRightRadians(Math.cos((absB = e.getBearingRadians()) - (0.2 * mvD))); // Saving code size!	
		setTurnRightRadians(Math.cos((absB = e.getBearingRadians()) + 
						   ((180 - (eD = e.getDistance())) * (getVelocity() / 3000)))); // Yatagan D:
	  
		// ---------- Gun Logic ----------
		// PM Gun from Exauge in RoboWiki
		// Math.round function from Exauge makes this better (in parity with Yatagan)
		eLog = String.valueOf((char)Math.round(e.getVelocity() 
             * Math.sin(e.getHeadingRadians() - (absB += getHeadingRadians())))).concat(eLog);
		
		while((indX = eLog.indexOf(eLog.substring(0, mLen--), 
               i = (int)(eD) / bVel)) < 0);
		
		do {
			//absB += Math.asin(((byte)eLog.charAt(indX--))/eD); // Original line from Exauge PM gun
			absB += (short) eLog.charAt(indX--) / eD; // Nifty aiming from WeekendObsession_S! 
		} while (--i > 0);
		
		setTurnGunRightRadians(Utils.normalRelativeAngle(absB - getGunHeadingRadians()));
		//setFire(Math.min(bPow+(aRF=100/(int)eD),he/4)); // Energy conservation
		setFire(bPow + (int)(100 / eD)); // Shoot to kill, with Anti-Ram
		
		// ---------- Stop'n'Go Movement Logic ----------
		if (he > (he = e.getEnergy())) { 
			setAhead(((Math.random() * 70) + 50) * mvD);
			//setAhead((Math.random() * 120) * mvD / aRF); // This can save 4 code size!
			if (mLen % 3 == 0) { // Change direction randomizer based from PM gun
				onHitWall(null); // Code saving mechanism, idea from Yatagan
			}
		}

		// ---------- Radar Logic ---------- 
		// From RoboWiki
		setTurnRadarLeft(getRadarTurnRemaining());	
	}

	public void onHitWall(HitWallEvent e) {
		mvD = -mvD;
	}
	
	// Symbolic log of enemy movements for pattern matcher.
	// Preloaded to prevent StringIndexOutOfBoundsException.
	static String eLog = ""
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 1
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 2
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char)-1
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char)-2 + (char)-4 + (char)-6
		+ (char)-8 + (char)-8 + (char)-8 + (char)-8
		+ (char)-8 + (char)-8 + (char)-8 + (char)-8
		+ (char)-8 + (char)-8 + (char)-8 + (char)-8
		+ (char)-8 + (char)-8 + (char)-8 + (char)-8
		+ (char)-8 + (char)-8 + (char)-8 + (char)-8
		+ (char)-8 + (char)-8 + (char)-8 + (char)-8
		+ (char)-8 + (char)-8 + (char)-8 + (char)-8
		+ (char)-8 + (char)-8 + (char)-8 + (char)-8
		+ (char)-8 + (char)-8 + (char)-8 + (char)-8
		+ (char)-8 + (char)-8 + (char)-8 + (char)-8
		+ (char)-7 + (char)-6 + (char)-5 + (char)-4
		+ (char)-3 + (char)-2 + (char)-1 + (char) 0
		+ (char) 2 + (char) 4 + (char) 6 + (char) 8
		+ (char) 8 + (char) 8 + (char) 8 + (char) 8
		+ (char) 8 + (char) 8 + (char) 8 + (char) 8
		+ (char) 8 + (char) 8 + (char) 8 + (char) 8
		+ (char) 8 + (char) 8 + (char) 8 + (char) 8
		+ (char) 8 + (char) 8 + (char) 8 + (char) 8
		+ (char) 8 + (char) 8 + (char) 8 + (char) 8
		+ (char) 8 + (char) 8 + (char) 8 + (char) 8
		+ (char) 8 + (char) 8 + (char) 8 + (char) 8
		+ (char) 8 + (char) 8 + (char) 8 + (char) 8
		+ (char) 8 + (char) 8 + (char) 8 + (char) 8
		+ (char) 7 + (char) 6 + (char) 5 + (char) 4
		+ (char) 3 + (char) 2 + (char) 1 + (char) 0;
}
