package rh;
import robocode.*;
import robocode.Bullet;
import robocode.util.Utils;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.geom.Line2D;
import java.util.Iterator;
import java.util.List;
import java.util.ArrayList;
import java.util.ArrayDeque;
import java.util.Queue;
import java.util.HashMap;
import java.util.Arrays;
import java.util.stream.Stream;
import java.util.stream.Collectors;
import java.awt.Color;


/**
 * Intra - a robot by Damij
 */ 
public class Intra extends AdvancedRobot
{

	static final int WEAPON_NEIGHBORS = 9, SURF_NEIGHBORS = 37,
		MAX_WEAPON_MAP_SIZE = 9500, MAP_SHRINK_TARGET = 9400,
		MAX_SURF_MAP_SIZE = 255, SURF_SHRINK_TARGET = 254;

	static final Point2D ORIGIN = new Point2D.Double(0d,0d);
	
	static final Self self = new Self();
	
	static final List<Bullet> _shaders = new ArrayList<>();
	
	static final boolean IS_TC = false, IS_MC = false;
	
	static RoundRectangle2D playField, realField;

	static Tracks movement;

	static Transducer weapon;
	
	static VolatileMass enemy;
	
	static double battleWidth, battleHeight, maxDist;
	
	private static long colorUpdateTime;
	
	private static int shots, bhbs;
	

	/**
	 * run: Intra's default behavior
	 */
	public void run() {
		// Initialization of the robot should be put here
		battleWidth = super.getBattleFieldWidth();
		battleHeight = super.getBattleFieldHeight();
		maxDist = Math.sqrt(battleWidth*battleWidth+battleHeight*battleHeight);
		playField = new RoundRectangle2D.Double(30d,30d,battleWidth-60d,battleHeight-60d, 216.5d, 150d);
		realField = new RoundRectangle2D.Double(18d,18d,battleWidth-36d,battleHeight-36d,0d,0d);
		if(enemy == null) {
			enemy = new VolatileMass(self);
			weapon = new Transducer(self, enemy);
			movement = new Tracks(self, enemy);
		}
		
		super.setAdjustRadarForGunTurn(true);
		super.setAdjustRadarForRobotTurn(true);
		super.setAdjustGunForRobotTurn(true);
		
		super.setBulletColor(Color.MAGENTA.darker());

		// After trying out your robot, try uncommenting the import at the top,
		// and the next line:
		if(super.getRoundNum()==0)
			setColors(Color.BLACK.brighter().brighter(),
				//don't jynx it
					Color.YELLOW.brighter(),
					Color.BLACK); // body,gun,radar

		// Robot main loop
		while(true) {
			// Replace the next 4 lines with any behavior you would like
			if(!IS_MC)
				doMovement(movement.update(_shaders, super.getRoundNum()));
			enemy.dump();
			execute();
			setColors();
		}
	}
	
	public void doMovement(final double[] planOfDefense) {
		final double turnAmount = planOfDefense[1] * Double.compare(Math.abs(planOfDefense[0]), 0d);//Math.abs(planOfDefense[0]) > 1
				//? planOfDefense[1] : 0d;
		super.setTurnLeftRadians(turnAmount);
		super.setAhead(planOfDefense[0]);
		super.setMaxVelocity(
			Math.max(0d,
				8d-Math.min(1d,
						Math.max(0d,(enemy.distance(self.exposePos())-maxDist*.125d))
					*1.846d/maxDist) * (8d-Math.abs(planOfDefense[0])/planOfDefense[2])
				)
		);
	}
	
	public void onStatus(final StatusEvent e) {
		setTurnRadarRightRadians(Double.POSITIVE_INFINITY);
		self.update(e.getStatus());
	}
	
	/**
	 * onScannedRobot: What to do when you see another robot
	 */
	public void onScannedRobot(final ScannedRobotEvent e) {
	
		final double absBearing = enemy.update(super.getHeadingRadians(), e);
		super.setTurnRadarLeftRadians(1.7d *
			Utils.normalRelativeAngle(super.getRadarHeadingRadians() - absBearing)
		);
		
		self.setESide(sign(enemy.bearingTo()));
		self.setLatDir(sign(enemy.bearingTo())*self.dir());
		self.setLatVelocity((float)(Math.abs(self.getVelocity()*Math.sin(self.getHeading()-absBearing)+enemy.latVelocity())));
		self.setAdvVelocity((float)(self.getVelocity()*Math.cos(self.getHeading()-absBearing)+enemy.advVelocity()));
		self.setBearing(enemy.bearingTo());
		
		final Iterator<Bullet> bitt = _shaders.iterator();
		while(bitt.hasNext()) {
			final Bullet looker = bitt.next();
			if(looker == null || !looker.isActive()) {
				bitt.remove();
			}
		}

		if(!IS_TC) {

			
			final PlanOfAttack shotAndPlan = weapon.update(movement.isDodgeFree());
			
			
			self.setGunTurnRemaining(super.getGunTurnRemainingRadians());
			
			final double angleBonus = adjustForShielding();
			
			final double firingAngle;
			
			super.setTurnGunLeftRadians(
				firingAngle = Utils.normalRelativeAngle(
					self.getGunHeading()
						- shotAndPlan.aimAngle()
						+ angleBonus
				)
			);
			
			if(shotAndPlan.bullet() != null) {
				final Bullet realBullet
					= setFireBullet(weapon.bPower());
				_shaders.add(realBullet);
				shots ++;
			}
		
		}

	}

	/**
	 * onHitByBullet: What to do when you're hit by a bullet
	 */
	public void onHitByBullet(final HitByBulletEvent e) {
		// Replace the next line with any behavior you would like
		movement.storeBullet(e.getBullet(), true);
	}
	
	/**
	 * onHitWall: What to do when you hit a wall
	 */
	public void onHitWall(final HitWallEvent e) {
		// Replace the next line with any behavior you would like
	}
	
	@Override
	public void onBulletHit(final BulletHitEvent e) {
		weapon.chalkOneUp(e.getBullet());
		enemy.expectHealthDelta(-Rules.getBulletDamage(e.getBullet().getPower()));
	}
	
	@Override
	public void onBulletHitBullet(final BulletHitBulletEvent e) {
		bhbs ++;
		movement.storeBullet(e.getHitBullet(), false);
	}
	
	@Override
	public void onRoundEnded(final RoundEndedEvent e) {
		weapon.clear();
		movement.clear(super.getRoundNum());
		_shaders.clear();
	}	
	
	@Override
	public void onSkippedTurn(final SkippedTurnEvent e) {
		System.out.println("MapSize: " + weapon.mapSize());
	}
	
	@Override
	public void onPaint(final Graphics2D g) {
		weapon.paint(g);
		enemy.paint(g);
		movement.paint(g);
		g.setColor(Color.BLUE.darker());
		g.draw(playField);
		g.setColor(Color.MAGENTA.brighter());
		for(final Bullet b : _shaders) {
			if(b != null)
				g.fill(new Ellipse2D.Double(b.getX()-3.5,b.getY()-3.5,7,7));
		}
	}
	
	public double adjustForShielding() {
		double bonus = 0d;
		if((float)bhbs/(float)shots>0.5f) {
			bonus = (Math.random()-0.5d) * 18d / enemy.distance(self.exposePos());
		}
		return bonus;
	}
	
	//updating colors is still abusable
	void setColors() {
		if(movement.updateColors()) {
			setColors(
				new Color((int)Math.max(0,123+(int)(Math.sin((colorUpdateTime)*Math.PI*.1d+.25d*Math.PI)*(122))),
						(int)Math.max(0,123+(int)(Math.sin((colorUpdateTime)*Math.PI*.03+.5d*Math.PI)*(122))),
						(int)Math.max(0,123+(int)(Math.sin((colorUpdateTime)*Math.PI*.021d+.75d*Math.PI)*(122)))),
				new Color(Math.max(0,123+(int)(Math.sin((colorUpdateTime)*Math.PI*.021d+Math.PI)*(122))),
						Math.max(0,123+(int)(Math.sin((colorUpdateTime)*Math.PI*.1d)*(122))),
						Math.max(0,123+(int)(Math.sin((colorUpdateTime)*Math.PI*.03d+.25d*Math.PI)*(122)))),
				new Color(Math.max(0,123+(int)(Math.sin((colorUpdateTime)*Math.PI*.03d+.25d*Math.PI)*(122))),
						Math.max(0,123+(int)(Math.sin((colorUpdateTime)*Math.PI*.021d+.5d*Math.PI)*(122))),
						Math.max(0,123+(int)(Math.sin((colorUpdateTime)*Math.PI*.1d+.25d*Math.PI)*(122)))));
				colorUpdateTime ++;
		}
	}
	

	public static final int sign(final double value) {
		return value >= 0 ? 1 : -1;
	}
	
}

/////////////////////////////////////////////////
/////////////////////////////////////////////////
/////////////////////////////////////////////////
/////////////////////////////////////////////////
/////////////////////////////////////////////////
//Selfs

class Self {
	static final float UNREAL_FACTOR = 1f, SPACER_CONST = 0.618f;
	private final Point2D center = new Point2D.Double(0d,0d), lastCenter = new Point2D.Double(0d,0d);
	private double velocity, heading, gunHeading, gunHeat,
		gunTurnRemaining, turnRemaining, distRemaining, lastVelocity, energy,
		lastHeading, wallSpace, revWallSpace, lastWallSpace, lastRevWallSpace,
		headingChange, latVelocity, advVelocity, lastHeadChange, lastAdvVel, lastLatVel, lastBearing, bearing, distFromEnemy;
	private long currTime, timeSinceDirChange, timeSinceHeadingFlip, lastTimeSinceDirChange, lastTimeSinceHeadFlip;
	private int dir = -1, accel, latDir, roundNum, eSide, lastDir, lastAccel, lastLatDir, lastESide, currASeg, currVSeg;
	void update(final RobotStatus e) {
		this.lastTimeSinceDirChange = timeSinceDirChange;
		this.lastTimeSinceHeadFlip = timeSinceHeadingFlip;
		this.lastHeading = heading;
		this.lastAccel = accel;
		this.lastDir = dir;
		this.lastLatDir = latDir;
		this.lastVelocity = velocity;
		this.lastAdvVel = advVelocity;
		this.lastLatVel = latVelocity;
		this.lastWallSpace = wallSpace;
		this.lastRevWallSpace = revWallSpace;
		this.lastCenter.setLocation(center);
		this.lastESide = eSide;
		this.lastHeadChange = headingChange;
		this.velocity = e.getVelocity();
		this.heading = e.getHeadingRadians();
		this.gunHeading = e.getGunHeadingRadians();
		this.gunHeat = e.getGunHeat();
		this.currTime = e.getTime();
		this.gunTurnRemaining = e.getGunTurnRemainingRadians();
		this.turnRemaining = e.getTurnRemainingRadians();
		this.distRemaining = e.getDistanceRemaining();
		this.dir = velocity == 0 ? dir : Intra.sign(velocity);
		this.accel = Double.compare(Math.abs(velocity),Math.abs(lastVelocity));
		this.headingChange = Utils.normalRelativeAngle(heading-lastHeading);
		this.energy = e.getEnergy();
		this.roundNum = e.getRoundNum();
		center.setLocation(e.getX(), e.getY());
		this.timeSinceDirChange ++;
		if(lastDir*dir<0) {
			this.timeSinceDirChange = 0;
		}
		this.timeSinceHeadingFlip ++;
		if(lastESide*eSide<0) {
			this.timeSinceHeadingFlip = 0;
		}
		double eGoing = heading;
		final double wallDistLat = Utils.normalAbsoluteAngle(eGoing) < Math.PI ? (Intra.battleWidth-center.getX()) / (Math.cos((Math.PI/2d - eGoing)))
			: center.getX() / (Math.cos((3d*Math.PI/2d - eGoing)));
		final double wallDistVirt = Math.abs(Utils.normalRelativeAngle(eGoing)) < Math.PI / 2d  ?
				(Intra.battleHeight-center.getY()) / (Math.cos(eGoing)) : center.getY() / (Math.cos(Math.PI - eGoing));
		wallSpace = Math.max(0,Math.min(1,(float)(Math.min(wallDistLat, wallDistVirt) / Intra.maxDist)));
		eGoing += Math.PI;
		eGoing = Utils.normalRelativeAngle(eGoing);
		final double wallDistLatRev = Utils.normalAbsoluteAngle(eGoing) < Math.PI ? (Intra.battleWidth-center.getX()) / (Math.cos((Math.PI/2d - eGoing)))
			: center.getX() / (Math.cos((3d*Math.PI/2d - eGoing)));
		final double wallDistVirtRev = Math.abs(Utils.normalRelativeAngle(eGoing)) < Math.PI / 2d  ?
				(Intra.battleHeight-center.getY()) / (Math.cos(eGoing)) : center.getY() / (Math.cos(Math.PI-Utils.normalAbsoluteAngle(eGoing)));
		revWallSpace = Math.max(0, Math.min(1,(float)(Math.min(wallDistLatRev, wallDistVirtRev)/ Intra.maxDist)));
		
		this.currASeg = accel + 1;
		this.currVSeg = ((int)Math.ceil(Math.abs(velocity))+1)/2;
	}
	float[] spawnDelayedKey(final Point2D source, final boolean isReal, final double bPower, final double lastHitOffset, final double passingOffset) {
		final float maxSights = (float)source.distance(lastCenter)/5.5f;
		return new float[]{
			(float)roundNum,
			(float)currTime-1,
			SPACER_CONST*(float)(source.distance(lastCenter)/Intra.maxDist),
			SPACER_CONST*(float)(Math.abs(lastBearing)/Math.PI),
			SPACER_CONST*(float)Math.abs(lastVelocity/8d),
			SPACER_CONST*(float)lastWallSpace,
			SPACER_CONST*(float)lastRevWallSpace,
			SPACER_CONST*(float)Math.min(1d, (float)lastTimeSinceDirChange/maxSights),
			0f,//SPACER_CONST*(float)Math.min(1d, (float)lastTimeSinceHeadFlip/maxSights),
			SPACER_CONST*((float)lastAccel+1f)/2f,
			0f,
			SPACER_CONST*(float)bPower/3f,
			SPACER_CONST*(float)Math.min(1d,Math.abs(lastHeadChange*7.161972448d)),
			0,//SPACER_CONST*(float)(lastHitOffset*0.5d + 0.5d),
			0,//SPACER_CONST*(float)(passingOffset*0.5d + 0.5d),
			SPACER_CONST*(float)Math.abs(lastLatVel/8d),
			SPACER_CONST*(float)Math.abs(lastAdvVel/16d),
			//SPACER_CONST*(float)(2d*Math.abs(0.5d*Math.PI-Math.abs(Utils.normalRelativeAngle(heading)))/Math.PI),
			isReal? 1f : UNREAL_FACTOR
		};
	}
	double getVelocity(){return velocity;} double getHeading(){return heading;}
	double getGunHeading(){return gunHeading;} double getGunHeat(){return gunHeat;}
	double getGunTurnRemaining(){return gunTurnRemaining;}
	void setGunTurnRemaining(final double gunTurnRemaining){ this.gunTurnRemaining = gunTurnRemaining; }
	double distance(final Point2D target){return target.distance(center);}
	double turnRemaining(){return turnRemaining;} double distRemaining(){return distRemaining;}
	double getEnergy(){return energy;} double getX(){return center.getX();} double getY(){return center.getY();}
	long getTime(){return currTime;} int dir(){return dir;} int accel(){return accel;}
	int getRoundNum(){return roundNum;} int latDir(){return latDir;} int eSide(){return eSide;}
	int aSeg(){return currASeg;} int vSeg(){return currVSeg;}
	Point2D setFireBullet(final double bPower){return MyUtil.project(Intra.ORIGIN,Rules.getBulletSpeed(bPower),gunHeading);}
	Point2D exposePos(){return center;}
	void setLatDir(final int latDir){this.latDir = latDir;}
	void setESide(final int eSide){this.eSide = eSide;}
	void setLatVelocity(final double vel){this.latVelocity=vel;}
	void setAdvVelocity(final double vel){this.advVelocity=vel;}
	void setBearing(final double bearing){this.lastBearing = this.bearing; this.bearing = bearing;}
}

class InertialMass {
	private Point2D center;
	private double heading, velocity;
	InertialMass(final Point2D center, final double heading, final double velocity) {
		this.center = new Point2D.Double(0d,0d);
		this.center.setLocation(center);
		this.heading = heading;
		this.velocity = velocity;
	}
	
	void reset(final Point2D center, final double heading, final double velocity) {
		this.center.setLocation(center);
		this.heading = heading;
		this.velocity = velocity;
	}
	
	void step(int dir, final Point2D rotation, final float frac) {
		final double maxTurn = Rules.getTurnRateRadians(Math.abs(this.velocity));
		
		final int velSign = velocity == 0 ? dir : Intra.sign(velocity);
		double desiredHeading, absBearingFrom = Math.atan2(center.getX()-rotation.getX(),center.getY()-rotation.getY());
		final int eSide = Intra.sign(
			Utils.normalRelativeAngle(heading - absBearingFrom)
		);
		
		desiredHeading = Utils.normalAbsoluteAngle(absBearingFrom + 0.5d*(Math.PI/*0.03d*Math.PI*((velocity))*/ - velSign*3.7d*Rules.MAX_TURN_RATE_RADIANS)*eSide);
		desiredHeading = MyUtil.wallSmooth(center, rotation, desiredHeading, eSide, velocity==0?dir:velSign); //pos, rot, head, eside, dir
		double turnAmount = Utils.normalRelativeAngle(desiredHeading - this.heading);
		
		if(Math.abs(turnAmount) > 0.5d*Math.PI) {
			dir *= -1;
			turnAmount = Utils.normalRelativeAngle(turnAmount + Math.PI);
		}
		this.heading += MyUtil.limit(-maxTurn, frac*turnAmount, maxTurn);
		
		final boolean rev = dir*velocity < 0;
		final double initVel = velocity;
		this.velocity += !rev ? Rules.ACCELERATION*frac*dir : Rules.DECELERATION*frac*dir;
		if(rev && dir*velocity>0) {
			velocity /= 2d;//frac < 1d && Math.abs(initVel) < 2d * frac ? velocity + frac : velocity / 2;//= Intra.sign(velocity)*Math.min(1d,Math.abs(velocity));
		}
		this.velocity = MyUtil.limit(-Rules.MAX_VELOCITY,velocity,Rules.MAX_VELOCITY);
		center.setLocation(MyUtil.project(center, frac*velocity, heading));
	}
	
	Point2D exposeCenter(){return center;}
	Point2D copyCenter(){return new Point2D.Double(center.getX(),center.getY());}
}

/////////////////////////////////////////////////
/////////////////////////////////////////////////
/////////////////////////////////////////////////
/////////////////////////////////////////////////
//Enemy

class VolatileMass {
	
	static final float SPACER_CONST = 0.618f;
	
	private final Point2D center = new Point2D.Double(0d,0d), lastCenter = new Point2D.Double(0d,0d);
	
	private final Self self;
	
	private double expHealthDelta;

	VolatileMass(final Self self) {
		this.self = self;
	}
	
	private double heading, velocity, absBearingTo, bearingTo,
		lastVelocity, distance, relativeHeading, wallSpace, revWallSpace,
		energy, lastEnergy, bPower = 1d, lastHeading, headingChange,
		latVelocity, advVelocity, angWidth;
	private long sightsSinceDirChange, sightsSinceHeadingFlip;
	private int accel, dir, lastDir, latDir, lastLatDir, sideOfEnemy;
	private boolean shot;
	
	public double update(final double myHeading, final ScannedRobotEvent e) {
		lastEnergy = energy;
		energy = e.getEnergy();
		lastHeading = heading;
		heading = e.getHeadingRadians();
		headingChange = Utils.normalRelativeAngle(heading-lastHeading);
		//System.out.println(headingChange*7.161972448d);
		lastVelocity = velocity;
		velocity = e.getVelocity();
		lastDir = dir;
		distance = e.getDistance();
		dir = velocity == 0 ? dir : Intra.sign(velocity);
		accel = Double.compare(Math.abs(velocity), Math.abs(lastVelocity));
		absBearingTo = Utils.normalRelativeAngle(myHeading + (bearingTo = e.getBearingRadians()));
		lastLatDir = latDir;
		sideOfEnemy = Intra.sign(Utils.normalRelativeAngle(heading-absBearingTo));
		latDir = dir * sideOfEnemy;
		relativeHeading = Math.abs(Utils.normalRelativeAngle(heading-absBearingTo-0.5d*Math.PI*sideOfEnemy));
		bPower=(lastEnergy-energy==0||lastEnergy-energy>3d?bPower:lastEnergy-energy);
		
		this.angWidth = 2d*Math.atan(18d/distance);
		
		final double hDelt = (lastEnergy - expHealthDelta - energy);
		shot = ((hDelt)) > 0 && (hDelt) <= 3d
				&& Math.abs(Math.abs(lastVelocity)-Math.abs(velocity)) < 2.05d
			&& distance > 51;
				
		expHealthDelta = 0d;
		latVelocity = Math.abs(velocity * Math.sin(heading - absBearingTo));
		advVelocity = velocity * -Math.cos(heading - absBearingTo);
		sightsSinceHeadingFlip ++;
		if(lastLatDir != latDir) {
			sightsSinceHeadingFlip = 0;
		}
		sightsSinceDirChange ++;
		if(lastDir != dir) {
			sightsSinceDirChange = 0;
		}
		final Point2D ref = self.exposePos();
		lastCenter.setLocation(center);
		center.setLocation(
			ref.getX() + Math.sin(absBearingTo)*distance,
			ref.getY() + Math.cos(absBearingTo)*distance
		);
		double eGoing = heading;
		final double wallDistLat = Utils.normalAbsoluteAngle(eGoing) < Math.PI ? (Intra.battleWidth-center.getX()) / (Math.cos((Math.PI/2d - eGoing)))
			: center.getX() / (Math.cos((3d*Math.PI/2d - eGoing)));
		final double wallDistVirt = Math.abs(Utils.normalRelativeAngle(eGoing)) < Math.PI / 2d  ?
				(Intra.battleHeight-center.getY()) / (Math.cos(eGoing)) : center.getY() / (Math.cos(Math.PI - eGoing));
		wallSpace = Math.max(0,Math.min(1,(float)(Math.min(wallDistLat, wallDistVirt) / Intra.maxDist)));
		eGoing += Math.PI;
		eGoing = Utils.normalRelativeAngle(eGoing);
		final double wallDistLatRev = Utils.normalAbsoluteAngle(eGoing) < Math.PI ? (Intra.battleWidth-center.getX()) / (Math.cos((Math.PI/2d - eGoing)))
			: center.getX() / (Math.cos((3d*Math.PI/2d - eGoing)));
		final double wallDistVirtRev = Math.abs(Utils.normalRelativeAngle(eGoing)) < Math.PI / 2d  ?
				(Intra.battleHeight-center.getY()) / (Math.cos(eGoing)) : center.getY() / (Math.cos(Math.PI-Utils.normalAbsoluteAngle(eGoing)));
		revWallSpace = Math.max(0, Math.min(1,(float)(Math.min(wallDistLatRev, wallDistVirtRev)/ Intra.maxDist)));
		return absBearingTo;
	}
	
	void dump() {
		shot = false;
	}
	
	void paint(final Graphics2D g) {
		g.setColor(Color.CYAN.darker().darker());
		g.draw(new Rectangle2D.Double(center.getX()-18d,center.getY()-18d,36d,36d));
	}
	
	float[] genKey(final int roundNum, final long time, final boolean isReal, final long timeSinceShot, final double bPower, final double lastHitOffset, final double passingOffset) {
		final float maxSights = (float)Intra.maxDist / 22f;
		return new float[]{
			(float)roundNum,
			(float)time,
			SPACER_CONST*(float)(distance/Intra.maxDist),
			SPACER_CONST*(float)(Math.min(Math.abs(2d*relativeHeading/Math.PI),1d)),
			SPACER_CONST*(float)(latVelocity/8d),
			SPACER_CONST*(float)wallSpace,
			SPACER_CONST*(float)bPower/3f,
			SPACER_CONST*((float)accel+1f)/2f,
			SPACER_CONST*(float)revWallSpace,
			SPACER_CONST*(float)Math.min(1d, (double)sightsSinceDirChange/maxSights),
			0f,//SPACER_CONST*(float)Math.min(1d, (double)sightsSinceHeadingFlip/maxSights),
			SPACER_CONST*(float)(2d*Math.abs(0.5d*Math.PI-Math.abs(Utils.normalRelativeAngle(heading)))/Math.PI),
			SPACER_CONST*Math.min(1f, (float)timeSinceShot/16f),
			SPACER_CONST*(float)Math.min(1d,Math.abs((headingChange*7.161972448d))),
			0f,//SPACER_CONST*(float)(lastHitOffset*0.5d + 0.5d),
			0f,//SPACER_CONST*(float)(passingOffset*0.5d + 0.5d),
			SPACER_CONST*(float)(advVelocity/16d+0.5d),
			0f,//SPACER_CONST*(float)Math.abs(velocity)/8f,///16d + 0.5d),
			0f
		};
	}
	
	void expectHealthDelta(final double delta) {
		this.expHealthDelta += delta;
	}
	
	double heading(){return heading;} double velocity(){return velocity;}
	double absBearingTo(){return absBearingTo;} double relativeHeading(){return relativeHeading;}
	double distance(final Point2D other){return other.distance(center);}
	double bearingTo(){return bearingTo;} double bPower(){return bPower;}
	double latVelocity(){return latVelocity;} double advVelocity(){return advVelocity;}
	double energy(){return energy;} double getX(){return center.getX();} double getY(){return center.getY();}
	double angularWidth(){return angWidth;}
	long velDirChange(){return sightsSinceDirChange;}
	long latDirChange(){return sightsSinceHeadingFlip;}
	int dir(){return dir;} int accel(){return accel;} int latDir(){return latDir;}
	int sideOfEnemy(){return sideOfEnemy;}
	boolean shot(){return shot;}
	Point2D exposePos(){return center;} Point2D shotCenter(){return lastCenter;}

}


/////////////////////////////////////////////////
/////////////////////////////////////////////////
/////////////////////////////////////////////////
/////////////////////////////////////////////////
/////////////////////////////////////////////////
//GUN

class Transducer {

	static final double BP_BASE = Intra.IS_MC ? 3.0d : 1.7d;
	static final float UNREAL_FACTOR = 0.91618f;
	static final int BINS = 127, DISP_WIDTH = 250, DISP_HEIGHT = 80;
	
	static int FREQ_MEM = 250;
	
	static final int KNN_DEX = 0, FREQ_DEX = 1,
		BOUNDING_SEGMENTS = 6, SEGMENT_DEPTH = 2, ROLLING_AVG = 15;

	final List<Seismic> _monitors;
	final List<Future> _futures;
	final Queue<float[]> _memories;
	final HashMap<float[], Double> offsetMap;
	
	final Self self;
	final VolatileMass enemy;
	
	final CNum[][] ekInv, ek;
	
	final CNum[] frequencies;
	
	final double[][][][][][][] boundingFactors;
	
	final double[] freqAmplitudes, freqPhaseAngles, aimAngles;
	
	final double GUN_COOLING_RATE = 0.1d, SAMPLING_TIME_DELTA = 1;
	
	final double[] offsetHistory;

	float[] knownKey;

	double bPower = BP_BASE, lastHitOffset, passingOffset, knnAngle, freqAngle,
		maxOffset, minOffset, maxCrimp, minCrimp, samplingFreq, knnAcc, freqAcc,
		runningFreqOffset;
		
	long fireTime, timeTillNextShot, timeBetweenShots, timeOfShot, timeSinceShot,
		freqUses, kNNUses;
	
	int samplesTaken, shots, knnHits, freqHits, freqMeasurements;
	
	boolean hasFired, usedKNN;

	Transducer(final Self self, final VolatileMass enemy) {
		this.self = self;
		this.enemy = enemy;
		_monitors = new ArrayList<>();
		this.offsetMap = new HashMap<>();
		_futures = new ArrayList<>();
		_memories = new ArrayDeque<>();
		this.frequencies = new CNum[FREQ_MEM];
		Arrays.fill(frequencies, new CNum(0d,0d));
		this.freqAmplitudes = new double[FREQ_MEM];
		this.freqPhaseAngles = new double[FREQ_MEM];
		this.offsetHistory = new double[FREQ_MEM];
		this.ekInv = new CNum[FREQ_MEM][FREQ_MEM];
		this.ek = new CNum[FREQ_MEM][FREQ_MEM];
		for(int k = 0; k < FREQ_MEM; k ++) {
			for(int n = 0; n < FREQ_MEM; n ++) {
				ekInv[k][n] = new CNum(Math.cos(2d*Math.PI*k*n/FREQ_MEM),Math.sin(2d*Math.PI*k*n/FREQ_MEM));
				ek[k][n] = new CNum(Math.cos(-2d*Math.PI*k*n/FREQ_MEM),Math.sin(-2d*Math.PI*k*n/FREQ_MEM));
			}
		}
		this.aimAngles = new double[2];
		this.boundingFactors = new double[2][SEGMENT_DEPTH][SEGMENT_DEPTH][SEGMENT_DEPTH][SEGMENT_DEPTH][SEGMENT_DEPTH][SEGMENT_DEPTH];
		for(int i = 0; i < 2; i ++) {
			for(int r = 0; r < BOUNDING_SEGMENTS * SEGMENT_DEPTH; r ++) {
				for(int a = 0; a < 3; a ++) {
					boundingFactors[i][r%SEGMENT_DEPTH][Math.max(0,r-SEGMENT_DEPTH)%SEGMENT_DEPTH][Math.max(0,r-2*SEGMENT_DEPTH)%SEGMENT_DEPTH]
							[Math.max(0,r-3*SEGMENT_DEPTH)%SEGMENT_DEPTH][Math.max(0,r-4*SEGMENT_DEPTH)%SEGMENT_DEPTH][Math.max(0,r-5*SEGMENT_DEPTH)%SEGMENT_DEPTH] = 1d;
				}
			}
		}
	}
	
	PlanOfAttack update(final boolean isDodgeFree) {
	
		timeSinceShot ++;
		timeTillNextShot =
			(long) Math.ceil(
				self.getGunHeat() / GUN_COOLING_RATE
			);
		
		final Point2D shot;
		if(fireTime == self.getTime()
				&& self.getGunTurnRemaining() == 0
					&& timeTillNextShot == 0 && ((bPower < self.getEnergy()) || (Intra.IS_MC&&self.getEnergy()>0d))&&knownKey!=null) {
			shot = self.setFireBullet(bPower);
			hasFired = true;
			timeSinceShot = 0;
			timeTillNextShot =
			(long) Math.ceil(
				Rules.getGunHeat(bPower) / GUN_COOLING_RATE
			);
			timeBetweenShots = timeTillNextShot;
			timeOfShot = self.getTime();
			knownKey[knownKey.length-1] = 1f;
			_monitors.add(new Seismic(self.exposePos(), enemy.absBearingTo(), enemy.latDir(), bPower, self.getTime(), knownKey, true,
				maxCrimp, minCrimp, maxOffset, minOffset, knnAngle, freqAngle));
			if(usedKNN) {
				kNNUses ++;
			} else {
				freqUses ++;
			}
			freqMeasurements = 0;
		} else {
			shot = null;
			if(self.getTime() %SAMPLING_TIME_DELTA==0 && hasFired && bPower < self.getEnergy() && knownKey != null) {//(!hasFired && (self.getTime()-timeOfShot) % Math.max(timeBetweenShots/2,1) == 0 && bPower < self.getEnergy() && knownKey != null) {
				knownKey[knownKey.length-1] = UNREAL_FACTOR;
				_monitors.add(new Seismic(self.exposePos(), enemy.absBearingTo(), enemy.latDir(), bPower, self.getTime(), knownKey, false,
					maxCrimp,minCrimp,maxOffset,minOffset, knnAngle, freqAngle));
			}
		}
		

		final Iterator<Seismic> mitt
			= _monitors.iterator();
			
		while(mitt.hasNext()) {
			final Seismic wave = mitt.next();
			if(wave.isActive() && wave.breaks(enemy.exposePos(), self.getTime())) {
				wave.setInactive();
				storeEvent(wave);
			} else if(wave.breaks(wave.distance(enemy.exposePos()) + 18d, self.getTime())) {
				mitt.remove();
			}
		}
		
/*		if(shot!=null) {
			hasFired = true;
			timeSinceShot = 0;
			timeTillNextShot =
			(long) Math.ceil(
				Rules.getGunHeat(bPower) / GUN_COOLING_RATE
			);
			timeBetweenShots = timeTillNextShot;
			timeOfShot = self.getTime();
			knownKey[knownKey.length-1] = 1f;
			_monitors.add(new Seismic(self.exposePos(), enemy, bPower, self.getTime(), knownKey, true,
				maxCrimp, minCrimp, maxOffset, minOffset));
		} else if(hasFired && bPower < self.getEnergy() && knownKey != null) {//(!hasFired && (self.getTime()-timeOfShot) % Math.max(timeBetweenShots/2,1) == 0 && bPower < self.getEnergy() && knownKey != null) {
			knownKey[knownKey.length-1] = UNREAL_FACTOR;
			_monitors.add(new Seismic(self.exposePos(), enemy, bPower, self.getTime(), knownKey, false,
				maxCrimp,minCrimp,maxOffset,minOffset));
		}
*/
		setMaxPosAndCrimps();

		fireTime = self.getTime() + 1;
	
		//bPower = Math.min(enemy.bPower(),BP_BASE);
		//if(isDodgeFree || (self.getEnergy() > 16d && enemy.energy() < 12d) || (enemy.energy()*5<self.getEnergy()))
			bPower = BP_BASE;
			
		if(self.getEnergy() < 16) {
			bPower -= .8d;
			if(self.getEnergy() < 12) {
				bPower -= 0.4d;
				if(self.getEnergy() < 7) {
					bPower -= 0.2d;
					if(self.getEnergy() < 3) {
						bPower = 0.1;
					}
				}
			}
		}
		
		final double dist;
		if((dist=enemy.distance(self.exposePos())) < 368d) {
			bPower += (3d-bPower) * (1d-(dist-36d)/450d);
		}
		
		
		if(enemy.energy() <= 1.2d*Rules.getBulletDamage(bPower)&&enemy.energy() < 16d) {
			bPower = (enemy.energy() + 2d) / 6d + 0.1d;
			if(enemy.energy() <= 4) {
				bPower = Math.max(0.1d, enemy.energy() / 4d) + 0.1d;
			}
		}

		bPower = Math.max(0.11d,Math.min(self.getEnergy()-0.1f, bPower));
		
		if(Intra.IS_MC)
			bPower = Math.min(3d, self.getEnergy());
		
		knownKey = enemy.genKey(self.getRoundNum(), self.getTime(), false, timeSinceShot, bPower, lastHitOffset, passingOffset);
			
		knnAngle = enemy.absBearingTo();
		if(knownKey!=null) {
			knnAngle = determineKNNAngle();
		}
		freqAngle = determineFreqAngle();
		
		
		final double[] knnTargetCenter = MyUtil.project(self.getX(),self.getY(),

			1.099d*enemy.distance(self.exposePos()),knnAngle

		);
		final double[] freqTargetCenter = MyUtil.project(self.getX(),self.getY(),
			1.099d*enemy.distance(self.exposePos()),freqAngle
		);
		final double[] fut = MyUtil.project(self.getX(),self.getY(),self.getVelocity(),self.getHeading());
		knnAngle = Math.atan2(knnTargetCenter[0]-fut[0], knnTargetCenter[1]-fut[1]);
		freqAngle = Math.atan2(freqTargetCenter[0]-fut[0], freqTargetCenter[1]-fut[1]);


	

		//freqAngle = runningFreqOffset / freqMeasurements;
		freqMeasurements ++;
		
		final int[] keyTranslate = MyUtil.keyAsInt(knownKey);
		
		double firingAngle = freqAngle;
		double knnBoundingFactor = boundingFactors[KNN_DEX][keyTranslate[0]]
			[keyTranslate[1]][keyTranslate[2]][keyTranslate[3]][keyTranslate[4]][keyTranslate[5]];
		double freqBoundingFactor = boundingFactors[FREQ_DEX][keyTranslate[0]]
			[keyTranslate[1]][keyTranslate[2]][keyTranslate[3]][keyTranslate[4]][keyTranslate[5]];
			
		usedKNN = false; //bias = 1.75d;
		if(knnAcc*6.618d/knnBoundingFactor>=freqAcc/freqBoundingFactor) {
			firingAngle = knnAngle;
			usedKNN = true;
		}
		

		
	
		
		
		return new PlanOfAttack(shot, firingAngle);

	}
	
	Point2D checkShot() {
		Point2D fut = MyUtil.project(self.exposePos(), self.getVelocity(), self.getHeading());
	//	Point2D pivot = MyUtil.project(self.exposePos(), firingAngle, enemy.distance(self.exposePos()));
		final Point2D shot;
		if(/*fireTime == self.getTime()
				&& */self.getGunTurnRemaining() == 0 //&& // <= 1.618d*Math.atan(18d/enemy.distance(fut))
					&& timeTillNextShot == 0 && ((bPower < self.getEnergy()) || (Intra.IS_MC&&self.getEnergy()>0d))&&knownKey!=null) {
			shot = self.setFireBullet(bPower);
			hasFired = true;
			timeSinceShot = 0;
			timeTillNextShot =
			(long) Math.ceil(
				Rules.getGunHeat(bPower) / GUN_COOLING_RATE
			);
			timeBetweenShots = timeTillNextShot;
			timeOfShot = self.getTime();
			knownKey[knownKey.length-1] = 1f;
			_monitors.add(new Seismic(fut, Math.atan2(enemy.getX()-fut.getX(),enemy.getY()-fut.getY()), enemy.latDir(), bPower, self.getTime(), knownKey, true,
				maxCrimp, minCrimp, maxOffset, minOffset, knnAngle, freqAngle));
			if(usedKNN) {
				kNNUses ++;
			} else {
				freqUses ++;
			}
			freqMeasurements = 0;
		} else {
			shot = null;
			if(self.getTime() %SAMPLING_TIME_DELTA==0 && hasFired && bPower < self.getEnergy() && knownKey != null) {//(!hasFired && (self.getTime()-timeOfShot) % Math.max(timeBetweenShots/2,1) == 0 && bPower < self.getEnergy() && knownKey != null) {
				knownKey[knownKey.length-1] = UNREAL_FACTOR;
				_monitors.add(new Seismic(fut, Math.atan2(enemy.getX()-fut.getX(),enemy.getY()-fut.getY()), enemy.latDir(), bPower, self.getTime(), knownKey, false,
					maxCrimp,minCrimp,maxOffset,minOffset, knnAngle, freqAngle));
			}
		}
		
		return shot;
	}
	
	void setMaxPosAndCrimps() {
		final Point2D[] nexts
				= MyUtil.getMaxPosAndCrimps(self, enemy, bPower, _futures);

	/*	this.crimpOffsets[0] = minOffset;
		this.crimpOffsets[1] = minCrimp;
		this.crimpOffsets[2] = maxOffset;
		this.crimpOffsets[3] = maxCrimp;
				*/
	//	if(enemy.dir() < 0) {
			final double o1 = calcOffset(nexts[0], enemy.absBearingTo());
			final double o2 = calcOffset(nexts[1], enemy.absBearingTo());
			final double c1 = calcOffset(nexts[2], enemy.absBearingTo());
			final double c2 = calcOffset(nexts[3], enemy.absBearingTo());
			
		this.maxOffset = Math.max(o1,o2);
		this.minOffset = Math.min(o1,o2);
		this.maxCrimp = Math.max(c1,c2);
		this.minCrimp = Math.min(c1,c2);
	//	} else {
	//		maxOffset = calcOffset(nexts[1], enemy.absBearingTo());
	//		minOffset = calcOffset(nexts[0], enemy.absBearingTo());
	//		maxCrimp = calcOffset(nexts[3], enemy.absBearingTo());
		//	minCrimp = calcOffset(nexts[2], enemy.absBearingTo());
		//}
		
		//System.out.println("CRIJMP MIN MAX\n" + minCrimp + " , " + maxCrimp);
		//System.out.println("OFFSET MIN MAX\n" + minOffset + " , " + maxOffset);
	}
	
	double aimLinearAngle() {
		Point2D future = new Point2D.Double(0d,0d);
		future.setLocation(enemy.exposePos());
		for(int i = 0; i < 10; i ++) {
			double flightTime = self.distance(future)/Rules.getBulletSpeed(bPower);
			future = MyUtil.limitToArena(
				MyUtil.project(enemy.exposePos(), flightTime * enemy.velocity(), enemy.heading())
			);
		}
		return Math.atan2(future.getX()-self.getX(),future.getY()-self.getY());
	}
	
	double calcOffset(final Point2D pos, final double absBearing) {
		final double mEA = Math.asin(8d/Rules.getBulletSpeed(bPower));
		final double absAngleTo = Math.atan2(pos.getX()-self.getX(),pos.getY()-self.getY());
		return MyUtil.limit(-1d, Utils.normalRelativeAngle(absAngleTo-absBearing)/mEA*enemy.latDir(), 1d);
	}
	
	int getBin(final double offset) {
		return (int)MyUtil.limit(0,Math.round(offset*(BINS-1)/2) + (BINS-1)/2, BINS-1);
	}
	
	double calcBinOffset(final int bin) {
		return (bin-(BINS-1d)/2d)/((BINS-1d)/2d);
	}
	
	double determineKNNAngle() {
		if(offsetMap.isEmpty()) {
			return enemy.absBearingTo();
		}
		final float[][] neighbors
			= /*MyUtil.insertionSortRepeat*/(MyUtil.findKNN(false,
				Math.min(offsetMap.size(), Intra.WEAPON_NEIGHBORS), knownKey,
				offsetMap.keySet().toArray(new float[0][])
			)/*, offsetMap*/);
		double firingAngle = 0d;
		final double mEA = Math.asin(8d/Rules.getBulletSpeed(bPower))*enemy.latDir();
		final double targetWidth = 2d*Math.atan(18d/enemy.distance(self.exposePos()));
		double maxDensity = Double.NEGATIVE_INFINITY;
		for(final float[] tester : neighbors) {
			double density = 0;
			final double myAngle = offsetMap.get(tester)*mEA;
			for(final float[] partner : neighbors) {
				//if(tester!=partner){
					//final double x = Utils.normalRelativeAngle(myAngle-offsetMap.get(partner)*mEA);
					//if(Math.abs(x) <= targetWidth) {
					//	density ++;//= tester[tester.length-1]*partner[partner.length-1];
					//}
					final double x = Utils.normalRelativeAngle(myAngle-offsetMap.get(partner)*mEA)/targetWidth;
					density += Math.exp(-0.5d*x*x)*partner[partner.length-1]/MyUtil.distBetweenKeys(partner, knownKey);
				//}
			}
			if(density > maxDensity) {
				maxDensity = density;
				firingAngle = Utils.normalRelativeAngle(myAngle + enemy.absBearingTo());
			}
		}
		
		return firingAngle;
	//	double firingOffset = Utils.normalRelativeAngle(firingAngle-enemy.absBearingTo()) / mEA;
		//System.out.println("Max density: " + maxDensity);
		//firingOffset = firingOffset < minCrimp ? minOffset*(firingOffset-minCrimp) + minCrimp : firingOffset > maxCrimp ? maxOffset*(firingOffset-maxCrimp) + maxCrimp : firingOffset;

	//	return Utils.normalRelativeAngle(
	//		firingOffset * mEA + enemy.absBearingTo()
//			firingAngle
	//	);
	}
	
	double determineFreqAngle() {
		final double samplingFreq = 1d/SAMPLING_TIME_DELTA;
		final double freqStep = samplingFreq / (double) Math.max(1d,samplesTaken);
		//double bin = (BINS-1)/2;
		double firingOffset = 0d;
		
		//System.out.println(Arrays.toString(frequencies));
		if(samplesTaken >= 3) {
			double avg = 0d;
			for(int s = 1; s <= samplesTaken; s ++) {
				avg += frequencies[FREQ_MEM-s].real();
			}
			avg /= samplesTaken*samplesTaken;
			MyUtil.mute(frequencies, avg);
			//System.out.println(Arrays.toString(frequencies));
			final double[] offsetHistogram = new double[samplesTaken];
			for(int n = FREQ_MEM-1; n >= FREQ_MEM-samplesTaken; n --) {
				double offsetFreq = 0;
				for(int k = FREQ_MEM-1; k >= FREQ_MEM-samplesTaken; k --) {
					final CNum sect = frequencies[k]
						.mulCopy(ek[FREQ_MEM-1-k][FREQ_MEM-1-n]);
					final CNum complex = sect.mulCopy(ekInv[k][n]);//sect.magnitude()*Math.cos(sect.theta()); // isn't this just += freq[k].real()?
					offsetFreq += complex.magnitude();// * Math.cos(complex.theta());
				}
				
				offsetHistogram[FREQ_MEM-1-n] = offsetFreq / (samplesTaken);
			}
			//System.out.println("History Rebuilt");
			//System.out.println(Arrays.toString(binHistogram));
			firingOffset = offsetHistogram[offsetHistogram.length-1];
			//System.out.println(Arrays.toString(offsetHistogram));
//			firingOffset = 0;
			for(int n = 1; n < offsetHistogram.length

// /2

		; n ++) {
				firingOffset -= (offsetHistogram[n]-offsetHistogram[n-1])/1.17d;
				firingOffset = MyUtil.limit(minOffset,firingOffset,maxOffset);
			}
			//System.out.println(Arrays.toString(offsetHistogram));
//		}
			//bin = 0;
			//for(int b = samplesTaken-1; b >= 0; b -= 1) {
			//	bin += freqAmplitudes[FREQ_MEM-b-1]*(Math.cos(2d*Math.PI*b/samplesTaken*freqStep + freqPhaseAngles[FREQ_MEM-b-1]));
				//freqAmplitudes[FREQ_MEM-b]*Math.cos(freqPhaseAngles[FREQ_MEM-b])
					//+ freqAmplitudes[FREQ_MEM-(b-1)]*Math.cos(freqPhaseAngles[FREQ_MEM-(b-1)]);
			//}
		//	for(int b = samplesTaken-1; b > samplesTaken / 2; b --) {
		//		bin += freqAmplitudes[FREQ_MEM-b] * Math.cos(freqPhaseAngles[FREQ_MEM-b]);//Math.pow(freqStep, b);
		//	}
	//		bin /= samplesTaken;
		}
		
	//	double firingOffset = calcBinOffset((int)Math.round(bin));
//		firingOffset = firingOffset < minCrimp ? minOffset*(firingOffset-minCrimp) + minCrimp : firingOffset > maxCrimp ? maxOffset*(firingOffset-maxCrimp) + maxCrimp : firingOffset;
//		if(offset<minCrimp) offset *= Math.abs(minOffset);
//		if(offset>maxCrimp) offset *= maxOffset;
		
		return MyUtil.limit(-1d,
				firingOffset,
				1d)*Math.asin(8d/Rules.getBulletSpeed(bPower))*enemy.latDir() + enemy.absBearingTo();
	}
	
	void storeEvent(final Seismic wave) {
		//double guessFactor = wave.getFactor(enemy.exposePos());
		double guessFactor = Utils.normalRelativeAngle(wave.getAngleTo(enemy.exposePos())-wave.baseAmp())/wave.mEA()*wave.latDir();
		
		//guessFactor = guessFactor > wave.maxCrimp() ? (guessFactor-wave.maxCrimp())/wave.maxOffset() + wave.maxCrimp()
		//		: guessFactor < wave.minCrimp() ? (guessFactor-wave.minCrimp())/wave.minOffset() + wave.minCrimp() : guessFactor;
		if(wave.isReal()) {
			shots ++;
			final int[] keyTranslate = MyUtil.keyAsInt(wave.key());
			
			final double freqBoundingFactor = boundingFactors[FREQ_DEX][keyTranslate[0]]
				[keyTranslate[1]][keyTranslate[2]][keyTranslate[3]][keyTranslate[4]][keyTranslate[5]];
			
			boundingFactors[FREQ_DEX][keyTranslate[0]]
				[keyTranslate[1]][keyTranslate[2]][keyTranslate[3]][keyTranslate[4]][keyTranslate[5]] = (freqBoundingFactor*Math.min(shots,ROLLING_AVG) + 
					(Math.exp(Math.abs(guessFactor - wave.freqFactor())) - 1)	) / (Math.min(shots+1,ROLLING_AVG+1) + 1d);
			
		
			final double knnBoundingFactor = boundingFactors[KNN_DEX][keyTranslate[0]]
				[keyTranslate[1]][keyTranslate[2]][keyTranslate[3]][keyTranslate[4]][keyTranslate[5]];
			
			boundingFactors[KNN_DEX][keyTranslate[0]]
				[keyTranslate[1]][keyTranslate[2]][keyTranslate[3]][keyTranslate[4]][keyTranslate[5]] = (knnBoundingFactor*Math.min(shots,ROLLING_AVG) + 
					(Math.exp(Math.abs(guessFactor - wave.kNNFactor())) - 1)	) / (Math.min(shots+1,ROLLING_AVG+1) + 1d);
					
			final int[] hits = wave.hits(enemy.exposePos());
		
			knnHits += hits[KNN_DEX];
			knnAcc = (knnAcc*Math.min(shots,ROLLING_AVG) + (hits[KNN_DEX]*1d)) / (Math.min(shots+1,ROLLING_AVG+1) + 1d);
			freqHits += hits[FREQ_DEX];
			freqAcc = (freqAcc*Math.min(shots,ROLLING_AVG) + (hits[FREQ_DEX]*1d)) / (Math.min(shots+1,ROLLING_AVG+1)+1d);//hits[FREQ_DEX];
			
			passingOffset = guessFactor;
		}
		
			final int OLD_MEM = FREQ_MEM;
			final int newMem = Math.min(249,(int)Math.max(3,Math.ceil(enemy.distance(self.exposePos())/Rules.getBulletSpeed(bPower))));
			//if(newMem > FREQ_MEM) {
			//	for(int i = newMem; i > 0; i --) {
			//		frequencies[i] = frequencies[i-1];
			//	}
			//}
			if(newMem!=FREQ_MEM) {
				FREQ_MEM = newMem;
				samplesTaken ++;
				samplesTaken = Math.min(samplesTaken,FREQ_MEM);//Math.max(1,Math.min(samplesTaken,FREQ_MEM-1);
				
				recalcConstants();
			
			final double[] tempHist = Arrays.copyOf(offsetHistory,offsetHistory.length);
			System.arraycopy(tempHist, Math.max(0,OLD_MEM-samplesTaken), offsetHistory, Math.max(0,newMem-samplesTaken), samplesTaken);
			} else {
			samplesTaken ++;//= Math.min(samplesTaken, FREQ_MEM);
			samplesTaken = Math.min(samplesTaken, FREQ_MEM);
			}
				
			for(int b = 0; b < Math.min(FREQ_MEM-1,offsetHistory.length-1); b ++) {
				offsetHistory[b] = offsetHistory[b+1];
			}

		/*	if(OLD_MEM > newMem) {
				for(int a = 0; a < OLD_MEM-newMem; a ++) {
				for(int b = 0; b < OLD_MEM-1; b ++) {
					offsetHistory[b] = offsetHistory[b+1];			
				}
				}
			} else {
				for(int a = 0; a < newMem-OLD_MEM; a ++) {
				for(int b = newMem-1; b >0; b --) {
					offsetHistory[b] = offsetHistory[b-1];
				}
				}
			}*/

			offsetHistory[FREQ_MEM-1] = guessFactor;//getBin(guessFactor);
			
			for(int k = FREQ_MEM-1; k >= (FREQ_MEM)-samplesTaken; k--) {
				CNum sum = new CNum(0d,0d);
				for(int n = FREQ_MEM-1; n >= (FREQ_MEM)-samplesTaken; n --) {
					sum.add(ek[FREQ_MEM-1-k][FREQ_MEM-1-n].scaleCopy(offsetHistory[n]));
				}
				frequencies[k] = sum;
				freqAmplitudes[k] = sum.magnitude();
				freqPhaseAngles[k] = sum.theta();
			}
		
		/*final double freqBoundingFactor = boundingFactors[FREQ_DEX][keyTranslate[0]]
			[keyTranslate[1]][keyTranslate[2]][keyTranslate[3]][keyTranslate[4]][keyTranslate[5]];
		
		boundingFactors[FREQ_DEX][keyTranslate[0]]
			[keyTranslate[1]][keyTranslate[2]][keyTranslate[3]][keyTranslate[4]][keyTranslate[5]] = (freqBoundingFactor*Math.min(shots,3d) + 
				(Math.exp(Math.abs(guessFactor - wave.freqFactor())) - 1)	)/(Math.min(shots+1,4d) + 1d);*/
		
	//	System.out.println(Arrays.toString(freqAmplitudes));
		//guessFactor = guessFactor > wave.maxCrimp() ? wave.maxOffset()*(guessFactor-wave.maxCrimp())+wave.maxCrimp() :
		//	guessFactor < wave.minCrimp() ? wave.minOffset()*(guessFactor-wave.minCrimp())+wave.minCrimp() : guessFactor;
		
		//guessFactor = MyUtil.limit(wave.minOffset(),guessFactor,wave.maxOffset());
		//guessFactor = guessFactor > 0d ? guessFactor / wave.maxOffset() : guessFactor / wave.minOffset();
		offsetMap.put(wave.key(), guessFactor);
		_memories.offer(wave.key());

		//if(wave.isReal())
			//lastHitOffset = guessFactor;
		//else
	}
	
	void chalkOneUp(final Bullet b) {
		final Seismic cause = this.getCause(b);
		if(cause != null)
			this.lastHitOffset = cause.getFactor(b.getHeadingRadians());
		else
			System.out.println("We hit who? what?");
	}
	
	Seismic getCause(final Bullet b) {
		for(final Seismic wave : _monitors) {
			if(wave.matches(b, self.getTime())) {
				return wave;
			}
		}
		return null;
	}
	
	void clear() {
		_monitors.clear();
		if(offsetMap.size() > Intra.MAX_WEAPON_MAP_SIZE) {
			removeOldestEntries();
		}
		knownKey = null;
		hasFired = false;
		System.out.println("Frequency Gun Scoreish: " + freqAcc);
		System.out.println("KNN Gun Scoreish      : " + knnAcc);
		System.out.println("Freq Uses : " + freqUses);
		System.out.println("KNN Uses  : " + kNNUses);
	}
	
	void removeOldestEntries() {
		/*final List<float[]> oldKeys
			= offsetMap.keySet().stream()
		.sorted((k1,k2)->
				{
			final int roundDiff = Float.compare(k1[0],k2[0]);
			if(roundDiff == 0) return Float.compare(k1[1],k2[1]);
			return roundDiff;
				})
			.limit(offsetMap.size()-Intra.MAP_SHRINK_TARGET)
		.collect(Collectors.toList());
		System.out.println("Removing: " + oldKeys.size() + " gun datums");
		for(final float[] key : oldKeys) {
			offsetMap.remove(key);
		}*/
		System.out.println("Removing : " + (offsetMap.size()-Intra.MAP_SHRINK_TARGET) + " gun datumses");
		for(int i = 0; i < offsetMap.size()-Intra.MAP_SHRINK_TARGET; i ++) {
			offsetMap.remove(_memories.poll());
		}
	}
	
	double bPower() {
		return bPower;
	}
	
	double mapSize() {
		return offsetMap.size();
	}
	
	void paint(final Graphics2D g) {
		for(final Seismic wave : _monitors) {
			//g.setColor(Color.MAGENTA.darker());
			if(wave.isReal()) {
			//	g.draw(wave.shape(self.getTime()));
			g.setColor(Color.RED.brighter());
			final Point2D knnHead = wave.projectKNN(self.getTime());
			final Point2D knnTail = wave.projectKNN(self.getTime()-1);
			final Point2D freqHead = wave.projectFreq(self.getTime());
			final Point2D freqTail = wave.projectFreq(self.getTime()-1);
			final Point2D headTail = wave.project(self.getTime());
			final Point2D headHead = wave.project(self.getTime()+1);
			g.draw(new Line2D.Double(knnHead.getX(),knnHead.getY(),knnTail.getX(),knnTail.getY()));
			g.setColor(Color.GREEN.brighter().brighter());
			g.draw(new Line2D.Double(freqHead.getX(),freqHead.getY(),freqTail.getX(),freqTail.getY()));
			g.setColor(Color.BLUE.brighter());
			g.draw(new Line2D.Double(headTail.getX(),headTail.getY(),headHead.getX(),headHead.getY()));
			}
		}
		g.setColor(Color.GRAY);
		for(final Future fut : _futures) {
			g.draw(new Ellipse2D.Double(fut.getX()-2,fut.getY()-2,4,4));
		}
		if(samplesTaken > 0) {
			double maxAmplitude = 0d;
			for(int k = FREQ_MEM - 2; k >= FREQ_MEM - samplesTaken; k --) {
				maxAmplitude = Math.max(maxAmplitude, freqAmplitudes[k]);
			}
			final double barWidth = DISP_WIDTH / Math.max(1d,samplesTaken);
			for(int i = 0; i < samplesTaken; i ++) {
				final int rgb = (int)(Math.cos(freqPhaseAngles[FREQ_MEM-1-i])*122.5d+122.5d);
				g.setColor(new Color(rgb,255-rgb,(123+rgb)%255));
				g.draw(new Rectangle2D.Double((i)*barWidth,0,barWidth,freqAmplitudes[FREQ_MEM-1-i]/maxAmplitude*DISP_HEIGHT));
			}
		}
	}
	void recalcConstants() {
		for(int k = 0; k < FREQ_MEM; k ++) {
			for(int n = 0; n < FREQ_MEM; n ++) {
				ekInv[k][n] = new CNum(Math.cos(2d*Math.PI*k*n/FREQ_MEM),Math.sin(2d*Math.PI*k*n/FREQ_MEM));
				ek[k][n] = new CNum(Math.cos(-2d*Math.PI*k*n/FREQ_MEM),Math.sin(-2d*Math.PI*k*n/FREQ_MEM));
			}
		}
	}

}


/////////////////////////////////////////////////
/////////////////////////////////////////////////
/////////////////////////////////////////////////
/////////////////////////////////////////////////
/////////////////////////////////////////////////
//MOVEMENT

class Tracks {
	static final HashMap<float[], Double> datMap = new HashMap<>();
	static final List<IncomingProblem> _plights = new ArrayList<>();
	static final List<Point2D> _potentials = new ArrayList<>();
	static final List<Shadow> _shadows = new ArrayList<>();
	static final Point2D safest = new Point2D.Double(0d,0d);
	static final double ENCROACHMENT = 0.5d * Rules.getTurnRateRadians(8d),
				HALF_SHADOW = 2.19d, HALF_SHADOW_MAX = 11d, SHADOW_DANGER = 0.00d;//1618d;
	static final int DIST_SEGS = 5, BINS = 57;
	static final float[][][][] vcs = new float[3][5][DIST_SEGS][BINS];
	final Self self;
	final VolatileMass enemy;
	
	final int DISP_WIDTH = 215, DISP_HEIGHT = 80;

	private IncomingProblem surfWave, secondWave;
	private float[][] neighbors;
	private double lastHitOffset, passingOffset;
	private long  timeToImpact;
	private int activeSurfID, goldenShadesFound, roundEnded;
	private boolean startSearch = true, updateColors, isHiding;
	Tracks(final Self self, final VolatileMass enemy) {
		this.self = self;
		this.enemy = enemy;
		for(int a = 0; a < vcs.length; a ++) {
			for(int b = 0; b < vcs[a].length; b ++) {
				for(int c = 0; c < vcs[a][b].length; c ++) {
					Arrays.fill(vcs[a][b][c], 0.175f);
				}
			}
		}
	}
	double[] update(final List<Bullet> _shaders, final int roundNum) {
		if(roundEnded == roundNum-1) {
			_plights.clear();
			roundEnded = -9;
		}	

		if(enemy.shot()) {
			_plights.add(
				new IncomingProblem(
					enemy.shotCenter(), self, enemy.bPower(),
					self.getTime()-1,
					self.spawnDelayedKey(
						enemy.shotCenter(),
						true,
						enemy.bPower(),
						lastHitOffset,
						passingOffset),
					true,
					self.exposePos()
				)
			);
		}/* else if(false && self.getTime()%3==0){
			_plights.add(
				new IncomingProblem(
					enemy.shotCenter(), self, enemy.bPower(),
					self.getTime()-1,
					self.spawnDelayedKey(enemy.shotCenter(), Math.atan2(self.getX()-enemy.getX(),self.getY()-enemy.getY()), false, enemy.bPower(), lastHitOffset, passingOffset),
					false,
					self.exposePos()
				)
			);
		}*/

		_potentials.clear();
		
		final Iterator<IncomingProblem> witt
			= _plights.iterator();
		while(witt.hasNext()) {
			final IncomingProblem wave = witt.next();
			if(wave.breaks(self.exposePos(), self.getTime()-2)) {
				witt.remove();
				if(wave.isActive())
					storeWave(wave);
			}
		}
		
		surfWave = getSurfWave();
		
		cullShadows();
		calcShadows(_shaders);
		checkColorUpdate();

		if(surfWave == null) {// || enemy.bPower() == 0.1) {
			return updateNewG();
		}
		
		_potentials.addAll(secureOptions());
		final Point2D safest = chooseSafest();
		this.safest.setLocation(safest);		


		return pseudoDrive(safest);
	}
	double[] updateOG() {
		Point2D focalPoint = enemy.exposePos();
		if(surfWave != null) {
			focalPoint = surfWave.exposeSource();	
		}//Utils.normalAbsoluteAngle(absBearingFrom + (0.5d*Math.PI - 0.03d*Math.PI*velocity)*eSide)
		double turnAmount =
			Utils.normalRelativeAngle(
				self.getHeading() -
				MyUtil.wallSmooth(self.exposePos(), focalPoint,
					Utils.normalAbsoluteAngle(
						enemy.absBearingTo() -
						(0.5d*Math.PI + Rules.MAX_TURN_RATE_RADIANS
								*0.3d*Math.PI)*self.eSide()),
					 self.eSide(), self.dir()
				)
			);
		double goDir = 1d;
		if (Math.abs(turnAmount) > 0.5d*Math.PI) {
			 turnAmount = Utils.normalRelativeAngle(turnAmount+Math.PI);
			 goDir = -1d;
		}
		
		double distToGo = self.distRemaining();
		if(Math.abs(self.distRemaining()) <= 2d || Math.random() < 0.05d) {
			distToGo = -(Math.random()+0.9d)*2d*217d*self.dir();
		}
		
		return new double[]{distToGo, turnAmount, .125d};
	}
	double[] updateNewG() {
		final Point2D head = MyUtil.project(self.exposePos(), 170*self.dir(), self.getHeading());
		final Point2D tail = MyUtil.project(self.exposePos(), -170*self.dir(), self.getHeading());
		
		double dir = self.dir(), distHead, distTail;
		if((/*dir == 1 && */(((distHead=enemy.distance(head)) < (distTail=enemy.distance(tail)) && !Intra.playField.contains(head))
				|| -(distHead-distTail) > 120d))/* ||
			(dir == -1 && ((((distTail=enemy.distance(tail)) < (distHead=enemy.distance(head)) || !Intra.playField.contains(tail))
				|| -(distTail-distHead) > 120d)))*/) {
			dir *= -1d;
		}
		double turnAmount =
			Utils.normalRelativeAngle(
				self.getHeading() -
				MyUtil.wallSmoothABS(self.exposePos(), enemy.exposePos(),
					Utils.normalAbsoluteAngle(
						enemy.absBearingTo()
						-
						(0.5d*Math.PI + Rules.MAX_TURN_RATE_RADIANS*dir
								*0.3d*Math.PI)*self.eSide()),
					 self.eSide(), (int)dir
				)
			);
		double goDir = dir;
		if (Math.abs(turnAmount) > 0.5d*Math.PI) {
			 turnAmount = Utils.normalRelativeAngle(turnAmount+Math.PI);
			 goDir *= -1d;
		}
		return new double[]{100d*goDir*Math.cos(turnAmount), turnAmount, .125d};
	}
	IncomingProblem getSurfWave() {
		long minTimeToBreak = Long.MAX_VALUE, secondMinTime = Long.MAX_VALUE;
		IncomingProblem toSurf = null;
		secondWave = null;
		for(final IncomingProblem pro : _plights) {
			final long ttB = pro.timeTillBreak(self.exposePos(), self.getTime());
			if(pro.isReal() && ttB < minTimeToBreak && ttB > 1) {
				minTimeToBreak = ttB;
				toSurf = pro;
			} else if(pro.isReal() && ttB < secondMinTime && ttB > 2) {
				secondMinTime = ttB;
				secondWave = pro;
			}
		}
		this.timeToImpact = minTimeToBreak;
		int code = 0;
		if(toSurf != null && toSurf.isActive() &&
				(code=toSurf.hashCode())!=this.activeSurfID
					&& !datMap.isEmpty()) {
			neighbors =
				MyUtil.findKNN(true,
					Intra.SURF_NEIGHBORS, toSurf.key(),
					datMap.keySet().toArray(new float[0][])
				);
		}
		this.activeSurfID = code;
		return toSurf;
	}
	final List<Point2D> secureOptions() {
		final List<Point2D> options = new ArrayList<>();
	//	if(self.getVelocity()<=2d)
			options.add(new Point2D.Double(self.getX(),self.getY()));	
		final InertialMass coaster = new InertialMass(self.exposePos(), self.getHeading(), self.getVelocity());
		for(int i = -1; i < 2; i += 2) {
			float futures = 0f;
			do {
				coaster.step(i, /*surfWave.exposeSource()*/enemy.exposePos(), 0.5f);//surfWave.exposeSource(), .5f);
				futures += 0.5f;
				options.add(coaster.copyCenter());
			} while(!surfWave.contacts(coaster.exposeCenter(), self.getTime() + (long)Math.floor(futures))&&futures<50);
			coaster.reset(self.exposePos(), self.getHeading(), self.getVelocity());
		}
		return options;
	}
	final Point2D chooseSafest() {
		final double mEA = (Math.asin(8d/Rules.getBulletSpeed(enemy.bPower())));
		Point2D target = _potentials.get((int)(_potentials.size()/1.3618));
		if(neighbors == null) {
			return target;
		}
		double minDanger = Double.POSITIVE_INFINITY;
		for(final Point2D opt : _potentials) {
			double antiDiver = 1d;
			//if(secondWave!=null) {
//				final Point2D ref = surfWave.initTarget();
//				antiDiver += Math.cos(Math.atan2(secondWave.sourceX()-opt.getX(),secondWave.sourceY()-opt.getY())-Math.atan2(secondWave.sourceX()-ref.getX(),secondWave.sourceY()-ref.getY()));
//			}
			double danger, mult = 1d;
			
			final double halfShadow = (HALF_SHADOW_MAX-HALF_SHADOW) * (3d - ((surfWave.velocity()-20d)/-3d))/3d + HALF_SHADOW;
			for(final Shadow s : _shadows) {
				if(s.parent == this.activeSurfID &&
					s.contains(
						new Rectangle2D.Double(
							opt.getX()-halfShadow,opt.getY()-halfShadow,2d*halfShadow,2d*halfShadow
						)
					)
				) {
					if(!s.golden)
						goldenShadesFound ++;
					s.golden = true;
					mult = SHADOW_DANGER;
					break;
				}
			}
		//	final double angleTo = Math.atan2(opt.getX()-self.getX(),opt.getY()-self.getY());
			final double targetWidth = 2.1618d*Math.atan(18d/surfWave.distance(opt));
			final double optAngle = surfWave.getAngleTo(opt);
			
			danger = vcs[surfWave.accelSeg()][surfWave.velSeg()][surfWave.distSeg()][(int)MyUtil.limit(0,
				(BINS-1)/2 + (BINS-1)/2 * Utils.normalRelativeAngle(optAngle-surfWave.baseAmp())/surfWave.mEA()*surfWave.dir(),
					BINS-1)];// / mult;

			if(mult != SHADOW_DANGER) {
				for(final float[] neighbor : neighbors) {
					if(!datMap.containsKey(neighbor)) continue;
					final double x = Utils.normalRelativeAngle(optAngle-datMap.get(neighbor)*surfWave.mEA()-surfWave.baseAmp())/targetWidth;
					danger += Math.exp(-0.5d*x*x) / MyUtil.distBetweenKeys(neighbor, surfWave.key())// * surfWave.key()[surfWave.key().length-1]
								* antiDiver;
				}
				danger *= mult;
			}
			if(danger < minDanger) {
				minDanger = danger;
				target = opt;
			}
		}
		return target;
	}
	double[] pseudoDrive(final Point2D safest) {
		final double desiredHeading =
			Math.atan2(safest.getX()-self.getX(), safest.getY()-self.getY());

		double turnAmount =
			Utils.normalRelativeAngle(
				self.getHeading() - desiredHeading
			);
		int goDir = 1;
		if (Math.abs(turnAmount) > 0.5d*Math.PI) {
			 goDir = -1;
			 turnAmount = Utils.normalRelativeAngle(turnAmount+Math.PI);
		}
			
		double distToGo = goDir*self.distance(safest)*Math.cos(turnAmount);
		
		return new double[]{distToGo, turnAmount, Math.max(1d,(timeToImpact-1d))};//Math.max(0.125d,timeToImpact-5.5d)*8d};
	}
	double[] pseudoSurf(final Point2D safest) {
		final double desiredOffset = surfWave.getOffset(safest);
		final double currentOffset = surfWave.getOffset(self.exposePos());
		double desiredDir = Intra.sign(desiredOffset-currentOffset) * self.eSide();
		
		final double absBearingFrom = Math.atan2(self.getX()-surfWave.getX(),self.getY()-surfWave.getY());
		
		double desiredHeading = Utils.normalAbsoluteAngle(absBearingFrom + (0.5d*Math.PI - 0.03d*Math.PI*Math.abs(self.getVelocity()))*self.eSide());
		desiredHeading = MyUtil.wallSmooth(self.exposePos(), new Point2D.Double(surfWave.getX(),surfWave.getY())
				, desiredHeading, self.eSide(), (int)desiredDir); //pos, rot, head, eside, dir
		double turnAmount = Utils.normalRelativeAngle(self.getHeading()-desiredHeading);
		
		System.out.println("DD: " + desiredDir);
			
		double dir = desiredDir;
		if(Math.abs(turnAmount) > 0.5d*Math.PI) {
			dir *= -1;
			turnAmount = Utils.normalRelativeAngle(turnAmount + Math.PI);
		}
		
		return new double[]{200d*dir,turnAmount, 0.125};
	}
	private void calcShadows(final List<Bullet> _apexes) {
		final long currTime = self.getTime();

		for(final IncomingProblem ceptor : _plights) {
			if(!ceptor.isReal()) {
				continue;
			}
			final double distTravelled = ceptor.distTravelled(currTime);
			
			final Ellipse2D[] g = ceptor.vectorRing(distTravelled);
			
			final double distance = ceptor.distance(self.exposePos());	
			outer:
			for(final Bullet steeple : _apexes) {
				final double[] xPoints = new double[4];
				final double[] yPoints = new double[4];
				final double[] xy1 = MyUtil.project(steeple.getX(), steeple.getY(), -0.d*steeple.getVelocity(), steeple.getHeadingRadians());
				xPoints[0] = xy1[0]; yPoints[0] = xy1[1];
				final double[] xy2 = MyUtil.project(steeple.getX(), steeple.getY(), 1.d*steeple.getVelocity(), steeple.getHeadingRadians());
				xPoints[1] = xy2[0]; yPoints[1] = xy2[1];
				
				final Rectangle2D bulletTrail = new Line2D.Double(xPoints[0],yPoints[0],xPoints[1],yPoints[1]).getBounds2D();
			
				if((!g[0].intersects(bulletTrail)) && g[1].intersects(bulletTrail)) {
					final double[] xy3 = MyUtil.project(ceptor.sourceX(), ceptor.sourceY(), 1.85d*distance, Math.atan2(xPoints[1] - ceptor.sourceX(), yPoints[1] - ceptor.sourceY()));
					xPoints[2] = xy3[0]; yPoints[2] = xy3[1];
					final double[] xy4 = MyUtil.project(ceptor.sourceX(), ceptor.sourceY(), 1.85d*distance, Math.atan2(xPoints[0] - ceptor.sourceX(), yPoints[0] - ceptor.sourceY()));
					xPoints[3] = xy4[0]; yPoints[3] = xy4[1];
					_shadows.add(new Shadow(ceptor.hashCode(),xPoints,yPoints));
				}
			}
		}
	}
	private void cullShadows() {
		final Iterator<Shadow> bullerator = _shadows.iterator();
		while(bullerator.hasNext()) {
			final Shadow shade = bullerator.next();
			if(!(_plights.stream().filter(w -> w.hashCode() == shade.parent).findAny().isPresent())) {
				bullerator.remove();
			}
		}
	}
	void storeBullet(final Bullet b, final boolean hitUs) {
		final IncomingProblem cause = getCause(b);
		if(cause == null) {
			System.out.println("Dropped a wave");
			return;
		}
		datMap.put(cause.key(), this.lastHitOffset=cause.getOffset(b.getHeadingRadians()));
		//System.out.println("Hit at: " + cause.getOffset(b.getHeadingRadians()));
		cause.setInactive();
		this.activeSurfID = 0;
		getSurfWave();
	}
	private IncomingProblem getCause(final Bullet b) {
		for(final IncomingProblem wave : _plights) {
			if(wave.matchesAt(b, self.getTime())) {
				return wave;
			}
		}
		return null;
	}
	void storeWave(final IncomingProblem wave) {
		this.passingOffset = wave.getOffset(self.exposePos());
		final int passBin = (int)MyUtil.limit(0,(BINS-1)/2 * passingOffset + (BINS-1)/2, BINS-1);
		final double targetBinWidth = wave.botWidthAt(self.exposePos()) / BINS;
		for(int i = 0; i < BINS; i ++) {
			final double x = (i-passBin)/Math.max(1d,targetBinWidth);
			vcs[wave.accelSeg()][wave.velSeg()][wave.distSeg()][i] = 
				(vcs[wave.accelSeg()][wave.velSeg()][wave.distSeg()][i]*0.99f + 0.05859f*(float)Math.exp(-0.5d*x*x)*Intra.SURF_NEIGHBORS);
		}
		//if(!wave.isReal())
		//final float[] thisKey = wave.key();
		//thisKey[thisKey.length-1] = self.UNREAL_FACTOR;
		//datMap.put(thisKey, passingOffset);
		
	}
	void clear(final int roundNum) {
		this.roundEnded = roundNum;
		if(datMap.size() > Intra.MAX_SURF_MAP_SIZE) {
			removeOldestEntries();
		}
		System.out.println(goldenShadesFound + " golden shades found");
		_potentials.clear();
	}
	void removeOldestEntries() {
		final List<float[]> oldKeys
			= datMap.keySet().stream()
		.sorted((k1,k2)->
				{
			final int roundDiff = Float.compare(k1[0],k2[0]);
			if(roundDiff == 0) return Float.compare(k1[1],k2[1]);
			return roundDiff;
				})
			.limit(datMap.size()-Intra.SURF_SHRINK_TARGET)
		.collect(Collectors.toList());
		System.out.println("Removing: " + oldKeys.size() + " surf datums");
		for(final float[] key : oldKeys) {
			datMap.remove(key);
		}
	}
	void paint(final Graphics2D g) {
		/*g.setColor(Color.PINK.darker());
		for(final IncomingProblem wave : _plights) {
			if(wave.isActive())
				g.draw(wave.shape(self.getTime()));
		}*/
		g.setColor(Color.ORANGE.darker());
		//for(final Point2D spot : _potentials) {
		//	g.draw(new Ellipse2D.Double(spot.getX()-1,spot.getY()-1,2,2));
		//}
		g.draw(new Rectangle2D.Double(safest.getX()-18d,safest.getY()-18d,36d,36d));
		for(final Shadow s : _shadows) {
			if(s.parent != this.activeSurfID)
				g.setColor(Color.RED.darker().darker().darker().darker().darker());
			else if(s.golden) {
				g.setColor(Color.YELLOW.darker());
				g.draw(s);
			} else {
				g.setColor(Color.RED.darker().darker().darker());
				g.draw(s);
			}
		}
		g.setColor(Color.YELLOW);
		float maxDanger = 0f; boolean isConst = true;
		final int dSeg = (int)Math.floor(enemy.distance(self.exposePos()) / Intra.maxDist * DIST_SEGS);
		for(int i = 0; i < BINS; i ++) {
			maxDanger = Math.max(vcs[self.aSeg()][self.vSeg()][dSeg][i], maxDanger);
			isConst &= maxDanger == vcs[self.aSeg()][self.vSeg()][dSeg][i];
		}
		//System.out.println(maxDanger + " md");
		double dispHeight = DISP_HEIGHT;
		if(isConst) {
			dispHeight *= 0.5d;
		}
		final double binWidth = DISP_WIDTH / (double) BINS;
		for(int i = 0; i < BINS; i ++) {
			g.draw(new Rectangle2D.Double(Intra.battleWidth-DISP_WIDTH+i*binWidth,0,binWidth,dispHeight*(vcs[self.aSeg()][self.vSeg()][dSeg][i]/maxDanger)));
		}
	}
	private void checkColorUpdate() {
		boolean isSafe = false;
		for(final Shadow s : _shadows) {
			if(s.contains(self.exposePos()) && s.golden) {
				isSafe = true;
				break;
			}
		}
		//this.updateColors = (isSafe&&!isHiding) || (!isSafe && isHiding);
		this.updateColors = false;
		isHiding = isSafe;
	}
	boolean updateColors() {
		return this.updateColors;
	}
	boolean isDodgeFree() {
		return _plights.isEmpty();
	}
}


/////////////////////////////////////////////////
/////////////////////////////////////////////////
/////////////////////////////////////////////////
/////////////////////////////////////////////////
//WAVES

class Seismic {
	
	private final Rectangle2D bodyPast;
	
	private final Point2D source;
	
	private final float[] key;
	
	private final double baseAmp, velocity, mEA, minCrimp, maxCrimp, minOffset, maxOffset,
			knnAngle, freqAngle;
	
	private final long time;
	
	private final int dir;
	
	private final boolean isReal;
	
	private boolean isActive;
	
	Seismic(final Point2D source, final double absBearingTo, final int latDir, final double bPower,
			final long time, final float[] key, final boolean isReal,
				final double maxCrimp, final double minCrimp, final double maxOffset, final double minOffset,
			final double knnAngle, final double freqAngle) {
		this.source = new Point2D.Double();
		this.source.setLocation(source);
		this.baseAmp = absBearingTo;
		this.velocity = Rules.getBulletSpeed(bPower);
		this.time = time;
		this.dir = latDir;
		this.mEA = Math.asin(8d/velocity);
		this.key = Arrays.copyOf(key, key.length);
		this.isReal = isReal;
		this.maxCrimp = maxCrimp;
		this.minCrimp = minCrimp;
		this.maxOffset = maxOffset;
		this.minOffset = minOffset;
		this.knnAngle = knnAngle;
		this.freqAngle = freqAngle;
		bodyPast = new Rectangle2D.Double(0d,0d,0d,0d);
		this.isActive = true;
	}
	
	boolean breaks(final Point2D potential, final long futureTime) {
		return potential.distance(source) <= (futureTime-time)*velocity;
	}
	
	boolean breaks(final double dist, final long futureTime) {
		return dist <= (futureTime-time)*velocity;
	}
	
	boolean contacts(final Point2D pot, final long futureTime) {
		final double radius = (futureTime-time)*velocity;
		this.bodyPast.setFrame(source.getX()-radius, source.getY()-radius, 2*radius, 2*radius);
		return bodyPast.intersects(new Rectangle2D.Double(pot.getX()-18d,pot.getY()-18d,36d,36d));
	}
	
	int[] hits(final Point2D target) {
		final double targetHalved = Math.atan(18d/source.distance(target));
		final double resultAngle = Math.atan2(target.getX()-source.getX(),target.getY()-source.getY());
		//double guessFactor = getFactor(knnAngle);
		//guessFactor = guessFactor > maxCrimp ? (guessFactor-maxCrimp)/maxOffset + maxCrimp
		//		: guessFactor < minCrimp ? (guessFactor-minCrimp)/minOffset + minCrimp : guessFactor;
		//double freqFactor = getFactor(freqAngle);
		//freqFactor = freqFactor > maxCrimp ? (freqFactor-maxCrimp)/maxOffset + maxCrimp
		//		: freqFactor < minCrimp ? (freqFactor-minCrimp)/minOffset + minCrimp : freqFactor;
		//final double KNN_ADJ = guessFactor * mEA + baseAmp;
		//final double FREQ_ADJ = freqFactor * mEA + baseAmp;
		final double angleDeltaKNN = Utils.normalRelativeAngle(resultAngle-knnAngle);
		final double angleDeltaFreq = Utils.normalRelativeAngle(resultAngle-freqAngle);
		return new int[]{Math.abs(angleDeltaKNN)<=targetHalved?1:0,Math.abs(angleDeltaFreq)<=targetHalved?1:0};
	}
	
/*	double getOffset(final Point2D result) {
		final double offset = 
			Utils.normalRelativeAngle(
				Math.atan2(result.getX()-source.getX(), result.getY()-source.getY())
				- this.baseAmp
			) / mEA;
		return MyUtil.limit(minOffset,offset,maxOffset);
	}
	
	double getOffset(final double heading) {
		final double offset =
				Utils.normalRelativeAngle(heading-this.baseAmp)/mEA;
		return MyUtil.limit(minOffset,offset,maxOffset);
	
	}
*/
	double getFactor(final Point2D result) {
		final double offset = 
			Utils.normalRelativeAngle(
				Math.atan2(result.getX()-source.getX(), result.getY()-source.getY())
				- this.baseAmp
			) / mEA * dir;
		return MyUtil.limit(-1,offset,1);
	}
	
	double getFactor(final double heading) {
		final double offset =
				Utils.normalRelativeAngle(heading-this.baseAmp)/mEA*dir;
		return MyUtil.limit(-1,offset,1);
	
	}
	
	double getDelta(final Point2D result) {
		return Utils.normalRelativeAngle(
				Math.atan2(result.getX()-source.getX(), result.getY()-source.getY())
				- this.baseAmp
			);
	}
	
	double getAngleTo(final Point2D result) {
		return Math.atan2(result.getX()-source.getX(), result.getY()-source.getY());
	}
	
	double distance(final Point2D target) {
		return source.distance(target);
	}
	
	boolean matches(final Bullet b, final long time) {
		final Point2D bPos = new Point2D.Double(b.getX(), b.getY());
		return Math.abs(this.velocity-b.getVelocity()) < 0.25
			&& Math.abs((time-this.time)*velocity-bPos.distance(source))
					< velocity * 1.5d;
	}
	
	Ellipse2D shape(final long instanceTime) {
		double radius = (instanceTime - time) * velocity;
		return new Ellipse2D.Double(
			source.getX()-radius, source.getY()-radius,
			2d*radius, 2d*radius
		);
	}
	
	Point2D projectKNN(final long future) {
		return MyUtil.project(source, (future-time)*velocity, knnAngle);
	}
	
	Point2D projectFreq(final long future) {
		return MyUtil.project(source, (future-time)*velocity, freqAngle);
	}
	
	Point2D project(final long future) {
		return MyUtil.project(source, (future-time)*velocity, baseAmp);
	}
	
	void setInactive(){this.isActive = false;} boolean isActive(){return isActive;}
	float[] key(){return key;} boolean isReal(){return isReal;}
	double maxOffset(){return maxOffset;}double minOffset(){return minOffset;}
	double maxCrimp(){return maxCrimp;}double minCrimp(){return minCrimp;}
	double mEA(){return mEA;} double baseAmp(){return baseAmp;}
	int latDir(){return dir;}
	double kNNFactor(){
		double guessFactor = getFactor(knnAngle);
		//guessFactor = guessFactor > maxCrimp ? (guessFactor-maxCrimp)/maxOffset + maxCrimp
		//		: guessFactor < minCrimp ? (guessFactor-minCrimp)/minOffset + minCrimp : guessFactor;
		return guessFactor;
	}
	double freqFactor(){
		double guessFactor = getFactor(freqAngle);
		guessFactor = guessFactor > maxCrimp ? (guessFactor-maxCrimp)/maxOffset + maxCrimp
				: guessFactor < minCrimp ? (guessFactor-minCrimp)/minOffset + minCrimp : guessFactor;
		return guessFactor;
	}
}

class IncomingProblem {
	
	private final Ellipse2D.Double bodyPast;
	
	private final Point2D source, vector;
	
	private final float[] key;
	
	private final double baseAmp, velocity, mEA;
	
	private final long time;
	
	private final int dir, ACCEL_SEG, VEL_SEG, DIST_SEG;
	
	private final boolean isReal;
	
	private boolean isActive;
	
	IncomingProblem(final Point2D source, final Self self, final double bPower,
			final long time, final float[] key, final boolean isReal, final Point2D initTarget) {
		this.source = new Point2D.Double();
		this.source.setLocation(source);
		this.vector = new Point2D.Double();
		this.vector.setLocation(initTarget);
		this.baseAmp = Math.atan2(self.getX()-source.getX(),self.getY()-source.getY());
		this.velocity = Rules.getBulletSpeed(bPower);
		this.time = time;
		this.dir = self.latDir();
		this.mEA = Math.asin(8d/velocity)*dir;
		this.key = Arrays.copyOf(key, key.length);
		this.isReal = isReal;
		this.bodyPast = new Ellipse2D.Double(0d,0d,0d,0d);
		this.isActive = true;
		this.ACCEL_SEG = self.accel() + 1;
		this.VEL_SEG = ((int)Math.round(Math.abs(self.getVelocity()))+1)/2;
		this.DIST_SEG = (int)(self.distance(source)/1000d*Tracks.DIST_SEGS);
	}
	
	boolean breaks(final Point2D potential, final long futureTime) {
		return potential.distance(source) + 16d <= (futureTime-time)*velocity;
	}
	
	boolean contacts(final Point2D pot, final long futureTime) {
		final double radius = (futureTime-time)*velocity;
		this.bodyPast.setFrame(source.getX()-radius, source.getY()-radius, 2*radius, 2*radius);
		return bodyPast.intersects(new Rectangle2D.Double(pot.getX()-18d,pot.getY()-18d,36d,36d));
	}
	
	double getOffset(final Point2D result) {
		return
			Utils.normalRelativeAngle(
				Math.atan2(result.getX()-source.getX(), result.getY()-source.getY())
				- this.baseAmp
			) / mEA;
	}
	
	double getOffset(final double heading) {
		return
			Utils.normalRelativeAngle(
				heading
				- this.baseAmp
			) / mEA;
	}
	
	double getAngleTo(final Point2D result) {
		return Math.atan2(result.getX()-source.getX(), result.getY()-source.getY());
	}
	
	long timeTillBreak(final Point2D scared, final long currFuture) {
		return (long)Math.ceil((scared.distance(source)-18-(currFuture-time)*velocity)/velocity);
	}
	
	boolean matchesAt(final Bullet b, final long time) {
		final Point2D bPos = new Point2D.Double(b.getX(), b.getY());
		return this.isReal && Math.abs(this.velocity-b.getVelocity()) < 0.1
			&& Math.abs((time-1-this.time)*velocity-bPos.distance(source))
					< b.getVelocity() * 1.5d;
	}
	
	double distTravelled(final long futureTime) {
		return velocity * (futureTime - time);
	}
	
	double distance(final Point2D pos) {
		return pos.distance(source);
	}
	
	double botWidthAt(final Point2D me) {
		return 2d*Math.atan(18d/me.distance(source));
	}
	
	Ellipse2D shape(final long instanceTime) {
		double radius = (instanceTime - time) * velocity;
		return new Ellipse2D.Double(
			source.getX()-radius, source.getY()-radius,
			2d*radius, 2d*radius
		);
	}
	
	Ellipse2D[] vectorRing(final double distTravelled) {
		return new Ellipse2D[]{
			new Ellipse2D.Double(
				(source.getX() - distTravelled+0.0d*velocity), (source.getY() - distTravelled + 0.0d*velocity),
				2*(distTravelled - 0.0d*velocity), 2*(distTravelled - 0.0d*velocity)
			),
			new Ellipse2D.Double(
				(source.getX() - distTravelled-1.049d*velocity), source.getY() - distTravelled - 1.049d*velocity,
				2*(distTravelled + 1.049d*velocity), 2*(distTravelled+1.049d*velocity)
			)
		};
	}
	
	@Override
	public int hashCode() {
		int hash = 0;
		for(final float k : key) {
			hash ^= Float.hashCode(k);
		}
		return hash;
	}
	
	float[] key(){return key;} boolean isReal(){return isReal;}
	double sourceX(){return source.getX();} double sourceY(){return source.getY();}
	Point2D exposeSource() {return source;} Point2D initTarget(){return vector;}
	double mEA(){return mEA;} int dir(){return dir;}
	void setInactive(){this.isActive = false;} boolean isActive(){return isActive;}
	double getX(){return source.getX();}double getY(){return source.getY();}
	double bPower(){return (velocity-20d)/-3d;}double velocity(){return velocity;}
	double baseAmp(){return baseAmp;}
	int velSeg(){return VEL_SEG;} int accelSeg(){return ACCEL_SEG;} int distSeg(){return DIST_SEG;}
	
}

/////////////////////////////////////////////////
/////////////////////////////////////////////////
/////////////////////////////////////////////////
/////////////////////////////////////////////////
//UTIL

class MyUtil {	
	static final Point2D project(final Point2D source, final double dist, final double heading) {
		return new Point2D.Double(source.getX() + Math.sin(heading) * dist, source.getY() + Math.cos(heading) * dist);
	}
	static final double[] project(final double x, final double y, final double dist, final double heading) {
		return new double[]{x + Math.sin(heading)*dist, y + dist*Math.cos(heading)};
	}
	static final double limit(final double low, final double clip, final double high) {
		return Math.max(low, Math.min(clip, high));
	}
	static final Point2D limitToArena(final Point2D spot) {
		spot.setLocation(
			limit(18d,spot.getX(),Intra.battleWidth-18d),
			limit(18d,spot.getY(),Intra.battleHeight-18d)
		);
		return spot;
	}
	static final float distBetweenKeys(final float[] key1, final float[] key2) {
		return Math.abs(key1[2]-key2[2]) + Math.abs(key1[3]-key2[3]) + Math.abs(key1[4]-key2[4])
			+ Math.abs(key1[5]-key2[5]) + Math.abs(key1[6]-key2[6]) + Math.abs(key1[7]-key2[7])
				+ Math.abs(key1[8]-key2[8]) + Math.abs(key1[9]-key2[9]) + Math.abs(key1[10]-key2[10])
			+ Math.abs(key1[11]-key2[11]) + Math.abs(key1[12]-key2[12])
				 + Math.abs(key1[13]-key2[13])
				 + Math.abs(key1[14]-key2[14]) + Math.abs(key1[15]-key2[15])
				 + Math.abs(key1[16]-key2[16]);// + Math.abs(key1[17]-key2[17]);
	}
	static final float euchKeyDist(final boolean incTime, final float[] key1, final float[] key2) {
		float val = 0f;//incTime ? (float)(((key1[1]-key2[1])*(key1[1]-key2[1])) / 6400f) : 0f;
		return val + (key1[2]-key2[2]) * (key1[2]-key2[2])
			+ (key1[3]-key2[3]) * (key1[3]-key2[3])
			+ (key1[4]-key2[4]) * (key1[4]-key2[4])
			+ (key1[5]-key2[5]) * (key1[5]-key2[5])
			+ (key1[6]-key2[6]) * (key1[6]-key2[6])
			+ (key1[7]-key2[7]) * (key1[7]-key2[7])
			+ (key1[8]-key2[8]) * (key1[8]-key2[8])
			+ (key1[9]-key2[9]) * (key1[9]-key2[9])
			+ (key1[10]-key2[10]) * (key1[10]-key2[10])
			+ (key1[11]-key2[11]) * (key1[11]-key2[11])
			+ (key1[12]-key2[12]) * (key1[12]-key2[12])
			+ (key1[13]-key2[13]) * (key1[13]-key2[13])
			+ (key1[14]-key2[14]) * (key1[14]-key2[14])
			+ (key1[15]-key2[15]) * (key1[15]-key2[15])
			+ (key1[16]-key2[16]) * (key1[16]-key2[16])
			+ (key1[17]-key2[17]) * (key1[17]-key2[17]);
	}
	static final float[][] findKNN(final boolean incTime, final int k, final float[] key, final float[][] data) {
		final int outSize = Math.min(k, data.length);
		final float[][] response = new float[outSize][];
		final float[] distances = new float[outSize];
		float highestCaptured = euchKeyDist(incTime, key, data[0]);
		response[0] = data[0];
		distances[0] = highestCaptured;
		int indexOfHighest = 0;
		for(int i = 1; i < outSize; i ++) {
			response[i] = data[i];
			float dist = euchKeyDist(incTime, key, data[0]);
			distances[i] = dist;
			if(dist > highestCaptured) {
				highestCaptured = dist;
				indexOfHighest = i;
			}
		}
		
		for(int i = outSize; i < data.length; i ++) {
			float dist = euchKeyDist(incTime, key, data[i]);
			if(dist < highestCaptured) {
				response[indexOfHighest] = data[i];
				distances[indexOfHighest] = dist;
				highestCaptured = Float.NEGATIVE_INFINITY;
				for(int a = 0; a < k; a ++) {
					if(distances[a] > highestCaptured) {
						highestCaptured = distances[a];
						indexOfHighest = a;
					}
				}
			}
		}
		return response;
	}
	public static float[][] insertionSortRepeat(final float[][] a,
            final HashMap<float[], Double> op) {
        float[] temp;
        int index;
        for (int i = 1; i < a.length; i ++) {
            index = i - 1;
            temp = a[i];
            while(index >= 0
                    && op.get(a[index]) <
                        op.get(temp)) {
                a[index + 1] = a[index];
                index --;
            }
            a[index+1] = temp;
        }
		return a;
    }
	public static final void mute(final double[] values, final double threshold) {
		for(int i = 0; i < values.length; i ++) {
			if(values[i] < threshold) {
				values[i] = 0;
			}
		}
	}
	public static final void mute(final CNum[] values, final double threshold) {
		for(int i = 0; i < values.length; i ++) {
			if(values[i]!=null && values[i].real()<threshold) {
				values[i] = new CNum(0d,0d);
			}
		}
	}
	public static final double wallSmooth(final Point2D pos, final Point2D rotationPOint, double head, final int eSide, final int dir) {
		final double wallStick = 140d;// Intra.playField.contains(pos) ? 61d : 175d;
		final int desiredClock = eSide * dir;
		int i = 0;
		while(!Intra.playField.contains(project(pos, wallStick*dir, head)) && i < 63) {
			head += 0.1d * desiredClock;
			i ++;
		}
		return head;
	}
	public static final double wallSmoothABS(final Point2D pos, final Point2D rotationPOint, double head, final int eSide, final int dir) {
		final double wallStick = 140d;// Intra.playField.contains(pos) ? 61d : 175d;
		final int desiredClock = eSide * dir;
		int i = 0;
		while(!Intra.realField.contains(project(pos, wallStick*dir, head)) && i < 63) {
			head += 0.1d * desiredClock;
			i ++;
		}
		return head;
	}
	public static int[] keyAsInt(final float[] key) {
		final int[] myKey = new int[Transducer.BOUNDING_SEGMENTS];
		for(int i = 2; i < 2 + Transducer.BOUNDING_SEGMENTS; i ++) {
			myKey[i-2] = (int)limit(0,(int)Math.floor(key[i]/VolatileMass.SPACER_CONST*(Transducer.SEGMENT_DEPTH-0.01)),Transducer.SEGMENT_DEPTH-1);
		}
		return myKey;
	}
	public static final double wallSmoothSquare(final Point2D pos, final Point2D rotationPOint, double head, final int eSide, final int dir) {
		final int desiredClock = eSide * dir;
		int i = 0;
		while(!Intra.realField.contains(project(pos, 20*dir, head)) && i < 63) {
			head += 0.1d * desiredClock;
			i ++;
		}
		return head;
	}
	public static final double wallSmoothTurn(final Point2D pos, final Point2D rotationPoint, final double head, final int eSide, final int dir) {
		final int desiredClock = eSide*dir;
		final double enemyEscape = 0;//Rules.getTurnRateRadians(0d)/2d;
		final double WALL_STICK = 130;
		Point2D next = project(pos, WALL_STICK * dir, head);
		double agression = -2d;
		if(!Intra.playField.contains(next)) {
			boolean left,right,top,bottom;
			left = next.getX() <= Intra.playField.getX();
			right = next.getX() >= Intra.playField.getWidth()+Intra.playField.getX();
			top = next.getY() >= Intra.playField.getHeight()+Intra.playField.getY();
			bottom = next.getY() <= Intra.playField.getY();
			if(desiredClock==1) {
				if(left && top) {
					left = false;
				} if(bottom && left) {
					bottom = false;
				} if(right && bottom) {
					right = false;
				} if(top && right) {
					top = false;
				}
				if(left) {
					return 2d*Math.PI + enemyEscape;
				} else if(bottom) {
					return 1.5d*Math.PI + enemyEscape;
				} else if(right) {
					return Math.PI + enemyEscape;
				} else if(top) {
					return 0.5d*Math.PI + enemyEscape;
				}
			} else {
				if(left && top) {
					top = false;
				} if(bottom && left) {
					left = false;
				} if(right && bottom) {
					bottom = false;
				} if(top && right) {
					right = false;
				}
				if(left) {
					return Math.PI - enemyEscape;
				} else if(bottom) {
					return 0.5d*Math.PI - enemyEscape;
				} else if(right) {
					return 2d*Math.PI - enemyEscape;
				} else if(top) {
					return 1.5d*Math.PI - enemyEscape;
				}
			}
		}
		return 
			Math.atan2(pos.getX()-rotationPoint.getX(),pos.getY()-rotationPoint.getY())
			+ (0.5d*Math.PI + enemyEscape * agression) * eSide;
	}
	static Point2D[] getMaxPosAndCrimps(final Self self, final VolatileMass enemy, final double bPower, final List<Future> _futures) {
		final Point2D.Double nextBack = new Point2D.Double(enemy.getX(),enemy.getY()),
			nextFront = new Point2D.Double(enemy.getX(),enemy.getY());
		final double waveVelocity = Rules.getBulletSpeed(bPower);
		final double escAngleBonus  = 0d;
		
		final Point2D myNextPos = project(self.exposePos(), self.getVelocity(), self.getHeading());
		
		final Point2D frontCrimp = new Point2D.Double(enemy.getX(),enemy.getY()),
			backCrimp = new Point2D.Double(enemy.getX(),enemy.getY());
		_futures.clear();
		if(Math.abs(enemy.velocity()) <= 2d) {
			_futures.add(new Future(enemy.getX(),enemy.getY(), 0));
		}
		final double frac = 1d;
		for(double dir = -1d; dir <= 1d; dir += 2d) {
			Point2D future =
				new Point2D.Double(enemy.getX(), enemy.getY());
			double futureEVel = enemy.velocity();
			double bareing = Math.atan2(enemy.getX() - self.getX(), enemy.getY() - self.getY());
			double runningDir = enemy.dir(), futDub = -1d;
			double runningLatDir = enemy.latDir();
			double futureHeading = bareing + (Math.PI / 2d) * runningLatDir;
			futureHeading += runningDir < 0 ? Math.PI : 0d;
			boolean hitWall = false;
			for(int futures = 0;
					futures < 1000d && !new Ellipse2D.Double(myNextPos.getX()-waveVelocity*futures,myNextPos.getY()-waveVelocity*futures,2*waveVelocity*futures,2*waveVelocity*futures)
						.intersects(new Rectangle2D.Double(future.getX()-5d,future.getY()-5d,10d,10d)); futDub += 1d/*hitWall ? 0.8d/*Math.max(0.5d, Math.min(0.98,0.5d+Math.abs(Math.abs(futureEVel))/16d)) : 1d*/, futures = (int)Math.floor(futDub)) {
				//futureEVel += dir * eLatDir > 0 ? Intra.sign(futureEVel)*dir*eLatDir : 2d*Intra.sign(futureEVel)*dir*eLatDir;
				futureEVel += dir*futureEVel > 0 ? dir : 2*dir;
				futureEVel = limit(-8d, futureEVel, 8d);
				runningDir = futureEVel == 0d ? runningDir : Intra.sign(futureEVel);
				runningLatDir = runningDir*Intra.sign(Utils.normalRelativeAngle(futureHeading - bareing));
				futureHeading = Utils.normalRelativeAngle(bareing + Math.PI/2d*runningLatDir);
				futureHeading += runningDir < 0 ? Math.PI : 0d;
				final double smoothedHeading = wallSmoothSquare(future, self.exposePos(), futureHeading, Intra.sign(Utils.normalRelativeAngle(futureHeading - bareing)), (int)dir);
				if(!hitWall && Math.abs(Utils.normalRelativeAngle(futureHeading - smoothedHeading)) <= Math.PI/36d) {
					if(dir < 0) { backCrimp.setLocation(future.getX(),future.getY());}//backCrimp.getX() = future.getX(); backCrimp.getY = future.y; }
					else { frontCrimp.setLocation(future.getX(),future.getY()); }
				} else if(!hitWall){
				//	System.out.println(hitWall + " " + dir + " : " + futureHeading + " " + smoothedHeading);
					hitWall = true;
				}
			//	System.out.println(futureEVel + " dir: " + dir + " eLatDir: " + eLatDir);
				future = project(future, futureEVel, smoothedHeading);
				bareing = Math.atan2(future.getX() - self.getX(), future.getY() - self.getY());
				_futures.add(new Future(future.getX(),future.getY(), dir));
			}
			if(dir == -1d) {
				//nextBack.x = future.x;//
				//nextBack.y = future.y;
				nextBack.setLocation(future);
				//if(hitWall)
				//	System.out.println("Crimp at back: " + backCrimp);
			} else {
				//nextFront.x = future.x;
				//nextFront.y = future.y;
				nextFront.setLocation(future);
				//if(hitWall)
				//	System.out.println("Crimp at front: " + frontCrimp);
			}
		}
		
		return new Point2D[] {nextBack, nextFront, backCrimp, frontCrimp};
	}
}

class PlanOfAttack {
	private final Point2D bullet;
	private final double aimAngle;
	PlanOfAttack(final Point2D bullet, final double aimAngle) {
		this.bullet = bullet;
		this.aimAngle = aimAngle;
	}
	Point2D bullet(){return bullet;} double aimAngle(){return aimAngle;}
}

class Shadow extends Polygon2D {
	final int parent;
	boolean golden;
	Shadow(final int parent, final double[] xPoints, final double[] yPoints) {
		super(xPoints, yPoints, xPoints.length);
		this.parent = parent;
	}
}

class Future extends Point2D.Double {
	private final double dir;
	Future(final double x, final double y, final double dir) {
		super(x,y);
		this.dir = dir;
	}
	double dir() {
		return dir;
	}
}

class CNum {
	private double real, i;
	CNum(final double real, final double i) {
		this.real = real;
		this.i = i;
	}
	CNum scaleCopy(final double scalar) {
		return new CNum(real*scalar,i*scalar);
	}
	CNum scale(final double scalar) {
		this.real *= scalar;
		this.i *= scalar;
		return this;
	}
	CNum add(final CNum input) {
		this.real += input.real;
		this.i += input.i;
		return this;
	}
	CNum sub(final CNum input) {
		this.real -= input.real;
		this.i -= input.i;
		return this;
	}
	CNum mul(final CNum input) {
		this.real = (this.real*input.real-this.i*input.i);
		this.i = this.real*input.i+this.i*input.real;
		return this;
	}
	CNum mulCopy(final CNum input) {
		return new CNum(this.real*input.real,this.i*input.i);
	}
	CNum div(final CNum input) {
		final double magnitude = input.real*input.real+input.i*input.i;
		this.real = (this.real*input.real+this.i*input.i) / magnitude;
		this.i = (this.i*input.real-this.real*input.i)/magnitude;
		return this;
	}
	double magnitude() {
		return Math.sqrt(real*real + i*i);
	}
	double theta() {
		return Math.atan2(i, real);
	}
	double real() {
		return real;
	}
	double imag() {
		return i;
	}
	@Override
	public String toString() {
		return "("+real+"+"+i+"i)";
	}
}