package ntc;
import robocode.*;
import java.awt.geom.Point2D;
import java.awt.Color;
import java.util.Random;

/**
 * ControlledChaos - a robot by ntc
 */
public class ControlledChaos extends AdvancedRobot
{	
	boolean movingFoward;
	public static int[] finishes;
	static int bulletHit;
	static int bulletMiss;
	static int bulletHitMe;
	static int bulletHitOtherBullet;	
	static int hitRobot;
	static int hitWall;
	static int bulletHitPercent;
	boolean gameEnded;
	static Enemy curenemy;
	static Random x;
	static Random y;
	double xForce=0;
	double yForce=0;
	
	public void run() {
		/*
		setEventPriority("ScannedRobotEvent",35);
		setEventPriority("HitByBulletEvent",5);
		setEventPriority("HitWallEvent",5);
		setEventPriority("HitRobotEvent",30);
		setEventPriority("RobotDeathEvent",15);
		setEventPriority("BulletMissedEvent",4);
		setEventPriority("BulletHitEvent",4);
		*/
		gameEnded=false;
		if(finishes == null){
			finishes = new int[getOthers()+1];
		}
		if(x==null){
			x=new Random();
		}
		if(y==null){
			y=new Random();
		}
		if(curenemy==null){
			curenemy=new Enemy();
		}
		setTurnRadarRight(Double.POSITIVE_INFINITY);
		if(getRoundNum()==0){		
			bulletHit=0;
			bulletMiss=0;
			bulletHitOtherBullet=0;
			bulletHitMe=0;		
			hitRobot=0;
			hitWall=0;
		}
		curenemy.name="";
		curenemy.x=0;
		curenemy.y=0;
		curenemy.energy=100;
		curenemy.distance=0;
		curenemy.heading=0;
		curenemy.fearFactor=1;
		curenemy.timeSinceLastScan=0;		
		movingFoward=true;
		setTurnGunRight(100);
		setTurnRight(40);
		waitFor(new TurnCompleteCondition(this));
		
		setAdjustRadarForRobotTurn(true);
		setAdjustGunForRobotTurn(true);
		setAdjustRadarForGunTurn(true);
		
		setColors(
                new Color(255, (int)(20 + Math.random() * 80), (int)(60 + Math.random() * 180)),
                new Color((int)(Math.random() * 80), 100 + (int)(Math.random() * 150), 255),
                new Color((int)(20 + Math.random() * 80), 255, (int)(20 + Math.random() * 180))
            );
		while(true) {
			wallCenterAvoid();		
			if(getTime()%3==0 && getTime()>5){				
				driveTo(translateInsideField(Math.abs(x.nextDouble())*getBattleFieldWidth()+1-xForce, Math.abs(y.nextDouble())*getBattleFieldHeight()+1-yForce, getWidth()));
			}
			if(getTime()%150==0){				
				if(getOthers()>2){
					movingFoward=(movingFoward) ? false:true;
				}
			}
			if(getTime()%50==0){
				out.println(curenemy.name);
			}
			setMaxVelocity(Math.random()*8+((getEnergy()<2.5 || getOthers()==1) ? 8:4));
			if(curenemy.timeSinceLastScan>25){
				curenemy.name="";
				curenemy.x=0;
				curenemy.y=0;
				curenemy.energy=100;
				curenemy.distance=0;
				curenemy.heading=0;
				curenemy.fearFactor=1;
				curenemy.timeSinceLastScan=0;
				setTurnRadarRight(Double.POSITIVE_INFINITY);
			}
			if(gameEnded){
				break;
			}
			curenemy.timeSinceLastScan++;
			execute();		
		}
	}

	/**
	 * onScannedRobot: What to do when you see another robot
	 */
	public void onScannedRobot(ScannedRobotEvent e) {
		double headDelta=0;
		if(curenemy.name.equals("")){
			curenemy.name=e.getName();			
			curenemy.x=getX() + e.getDistance() * Math.sin(getHeadingRadians()+e.getBearingRadians());
			curenemy.y=getY() + e.getDistance() * Math.cos(getHeadingRadians()+e.getBearingRadians());
			curenemy.energy=e.getEnergy();
			curenemy.distance=e.getDistance();
			curenemy.heading=e.getHeading();
			curenemy.fearFactor=1;
			curenemy.timeSinceLastScan=0;
		}
		headDelta=e.getHeading()-curenemy.heading;
		if(((e.getDistance()<curenemy.distance*0.9 && e.getEnergy()<=curenemy.energy*1.1) || (e.getEnergy()<curenemy.energy*0.8 && e.getDistance()<=curenemy.distance*1.2)) && getGunHeat()>getGunCoolingRate() && curenemy.energy>0.1 && (!e.getName().equals(curenemy.name))){
			curenemy.name=e.getName();			
			curenemy.x=getX() + e.getDistance() * Math.sin(getHeadingRadians()+e.getBearingRadians());
			curenemy.y=getY() + e.getDistance() * Math.cos(getHeadingRadians()+e.getBearingRadians());
			curenemy.energy=e.getEnergy();
			curenemy.distance=e.getDistance();
			curenemy.heading=e.getHeading();
			curenemy.fearFactor=1;
			curenemy.timeSinceLastScan=0;
			out.println(curenemy.name);
		}	
		if(e.getName().equals(curenemy.name)){
			curenemy.x=getX() + e.getDistance() * Math.sin(getHeadingRadians()+e.getBearingRadians());
			curenemy.y=getY() + e.getDistance() * Math.cos(getHeadingRadians()+e.getBearingRadians());
			curenemy.energy=e.getEnergy();
			curenemy.distance=e.getDistance();
			curenemy.heading=e.getHeading();
			curenemy.fearFactor=1;
			curenemy.timeSinceLastScan=0;
		}
		if(getGunTurnRemaining()<2.5 && e.getEnergy()>0 && e.getName().equals(curenemy.name)){
			double bulletPower=Math.min(Math.min(Math.min(e.getEnergy()/4,650/e.getDistance()),getEnergy()/40)*Math.max(getOthers()/2,1),getEnergy()-1);
			if(e.getEnergy()>12 && getEnergy()>25 && (getOthers()/2)>=1){
				bulletPower=Math.min(Math.min(e.getEnergy()/4,650/e.getDistance()),getEnergy()/40)*getOthers();
			}else{
				bulletPower=Math.min(Math.min(e.getEnergy()/4,650/e.getDistance()),getEnergy()/40);
			}
			double absoluteBearing=e.getBearing()+getHeading();
			if(headDelta>0.0075){	
				setTurnGunRight(normalRelativeAngle(absoluteBearing-getGunHeading()));
			}else{
				setTurnGunRight(normalRelativeAngle((absoluteBearing-getGunHeading())-Math.toDegrees(e.getVelocity()*Math.sin((e.getBearingRadians()+getHeadingRadians())-e.getHeadingRadians())/(20-3*Math.min(3,Math.max(0.1,bulletPower/curenemy.fearFactor))))));
			}
	
			if(getGunHeat()==0 && getEnergy()>0.2){
				setFire(bulletPower/curenemy.fearFactor);			
			}
		}else if(e.getEnergy()==0){
			if(e.getDistance()<250 || getOthers()==1){
				double enemyBearing = getHeadingRadians() + e.getBearingRadians();
				double enemyX = getX() + (e.getDistance()) * Math.sin(enemyBearing);
				double enemyY = getY() + (e.getDistance()) * Math.cos(enemyBearing);
				setMaxVelocity(8);
				setAhead(0);
				setTurnRight(0);				
				driveToWithoutExecute(enemyX,enemyY);
			}else{
				double absoluteBearing=getHeading()+e.getBearing();
				turnGunRight(normalRelativeAngle(absoluteBearing-getGunHeading()));
				fire(0.1);
			}
		}
		if((e.getName().equals(curenemy.name) && getGunHeat()/getGunCoolingRate()<9 && getOthers()<8) || getOthers()==1){
			setTurnRadarLeft(getRadarTurnRemaining());
		}
	}

	/**
	 * onHitByBullet: What to do when you're hit by a bullet
	 */
	public void onHitByBullet(HitByBulletEvent e) {			
		bulletHitMe++;
		setTurnRadarRight(Double.POSITIVE_INFINITY);
		setTurnGunRight(20);
		if(getOthers()>1){
			setMaxVelocity(Math.random()*8+6);
			setTurnRight(bearingToParallel((Math.random()*30+75)-(getHeading()-e.getHeading()))); 
			movingFoward=(movingFoward) ? false:true;
		}
		if(e.getBullet().getName().equals(curenemy.name)){
			curenemy.fearFactor+=(curenemy.fearFactor>2) ? 0:e.getBullet().getPower()/6;
		}
	}
	
	public void wallCenterAvoid() {
		//The next four lines add field center & general area avoidance if there is more than 1 other robot
		if(getOthers()>1){
			double force = 500/Math.pow(Point2D.Double.distance(getX(),getY(),getBattleFieldWidth()/2,getBattleFieldHeight()/2),1.5);
		    double ang = Math.PI/2 - Math.atan2(getY() - getBattleFieldHeight()/2, getX() - getBattleFieldWidth()/2); 
		    xForce += Math.sin(ang) * force;
		    yForce += Math.cos(ang) * force;
			if(curenemy.energy>5 || getEnergy()>10){
				force = 100/Math.pow(Point2D.Double.distance(getX(),getY(),curenemy.x,curenemy.y),1.5);
				ang = Math.PI/2 - Math.atan2(getY() - curenemy.y, getX() - curenemy.x);
				xForce += Math.sin(ang) * force;
			    yForce += Math.cos(ang) * force;
			}
		}
	    /**The following four lines add wall avoidance.  They will only affect us if the bot is close 
	    to the walls due to the force from the walls decreasing at a power 3.**/
	    xForce += 5000/Math.pow(Point2D.Double.distance(getX(), getY(), getBattleFieldWidth(), getY()), 3);
	    xForce -= 5000/Math.pow(Point2D.Double.distance(getX(), getY(), 0, getY()), 3);
	    yForce += 5000/Math.pow(Point2D.Double.distance(getX(), getY(), getX(), getBattleFieldHeight()), 3);
	    yForce -= 5000/Math.pow(Point2D.Double.distance(getX(), getY(), getX(), 0), 3); 
	}

	void driveTo(Point2D.Double p){
		double myX = getX();double myY = getY();double turnAngle;double normalizedTurnAngle;		
		if(movingFoward){
			setTurnRightRadians(normalizedTurnAngle =  Math.atan(Math.tan(turnAngle = ((Math.atan2(p.getX() - myX, p.getY() - myY) - getHeadingRadians()) + (7.0 *  Math.PI)) % (2.0 * Math.PI) -  Math.PI)));
			setAhead((normalizedTurnAngle == turnAngle ? 1.0 : -1.0) * (java.awt.geom.Point2D.Double.distance(myX, myY, p.getX(), p.getY())));
		}else{
			setTurnLeftRadians(normalizedTurnAngle =  Math.atan(Math.tan(turnAngle = ((Math.atan2(p.getX() - myX, p.getY() - myY) - getHeadingRadians()) + (7.0 *  Math.PI)) % (2.0 * Math.PI) -  Math.PI)));
			setBack((normalizedTurnAngle == turnAngle ? 1.0 : -1.0) * (java.awt.geom.Point2D.Double.distance(myX, myY, p.getX(), p.getY())));
		}
	}
	
	void driveToWithoutExecute(double nextX, double nextY){
		double myX = getX();double myY = getY();double turnAngle;double normalizedTurnAngle;		
		if(movingFoward){
			turnRightRadians(normalizedTurnAngle =  Math.atan(Math.tan(turnAngle = ((Math.atan2(nextX - myX, nextY - myY) - getHeadingRadians()) + (7.0 *  Math.PI)) % (2.0 * Math.PI) -  Math.PI)));
			ahead((normalizedTurnAngle == turnAngle ? 1.0 : -1.0) * (java.awt.geom.Point2D.Double.distance(myX, myY, nextX, nextY)));
		}else{
			turnLeftRadians(normalizedTurnAngle =  Math.atan(Math.tan(turnAngle = ((Math.atan2(nextX - myX, nextY - myY) - getHeadingRadians()) + (7.0 *  Math.PI)) % (2.0 * Math.PI) -  Math.PI)));
			back((normalizedTurnAngle == turnAngle ? 1.0 : -1.0) * (java.awt.geom.Point2D.Double.distance(myX, myY, nextX, nextY)));
		}
	}
	
	public Point2D.Double translateInsideField(double x, double y, double margin) {
        double X = Math.max(margin, Math.min((getBattleFieldWidth()-getWidth()) - margin, x));
        double Y = Math.max(margin, Math.min((getBattleFieldHeight()-getHeight()) - margin, y));
		return new Point2D.Double(X,Y);
    }

	public double normalRelativeAngle(double angle) {
		return ((angle + 540) % 360) - 180;
	}	
		
	/** 
	* returns bearing to turn so as to be parallel to line of heading angle (-90 <= returnValue <= 90) 
 	*/ 
	public double bearingToParallel(double angle) { 
    	return ((angle + 270) % 180) - 90;
	} 

	public void onRobotDeath(RobotDeathEvent e){
		if(e.getName().equals(curenemy.name)){
			curenemy.name="";
			curenemy.x=0;
			curenemy.y=0;
			curenemy.energy=100;
			curenemy.distance=0;
			curenemy.heading=0;
			curenemy.fearFactor=1;
			curenemy.timeSinceLastScan=0;
		}
	}	
		
	public void onWin(WinEvent e){		
		onDeath(null);
		gameEnded=true;
		setAhead(0);		
		driveToWithoutExecute(curenemy.x,curenemy.y);
		setTurnRadarRight(Double.POSITIVE_INFINITY);
		setTurnGunLeft(Double.POSITIVE_INFINITY);
		setTurnRight(Double.POSITIVE_INFINITY);
		waitFor(new TurnCompleteCondition(this));
	}
	public void onDeath(DeathEvent e){
		finishes[getOthers()]++;
		for(int i=0;i<finishes.length;i++){
			out.println((i+1) + " place(s): " + finishes[i] + "  ");
		}
		if(getNumRounds()-getRoundNum()==1){			
			out.println();
			printStats();
		}
	}
	
	public void onHitRobot(HitRobotEvent e){
		hitRobot++;
		double absoluteBearing=getHeading()+e.getBearing();
		setTurnGunRight(normalRelativeAngle(absoluteBearing-getGunHeading()));
		if(getGunHeat()==0){
			fire(3);						
		}
		movingFoward=(movingFoward) ? false:true;
		setMaxVelocity(8);
		if(!e.getName().equals(curenemy.name)){
			curenemy.name=e.getName();
			curenemy.energy=e.getEnergy();
			curenemy.timeSinceLastScan=0;
			curenemy.fearFactor=0;
		}
		if(e.getName().equals(curenemy.name)){
			curenemy.fearFactor+=(curenemy.fearFactor>2) ? 0:0.25;
		}
		x=new Random();
		y=new Random();
		setTurnRadarRight(Double.POSITIVE_INFINITY);
	}
		
	public void onBulletHit(BulletHitEvent e){
		bulletHit++;
		curenemy.fearFactor-=(((int)Math.round(curenemy.fearFactor))==1) ? 0:e.getBullet().getPower()/6;
	}	
	
	public void onBulletMissed(BulletMissedEvent e){
		bulletMiss++;
		curenemy.fearFactor+=(curenemy.fearFactor>2) ? 0:e.getBullet().getPower()/12;
	}
	
	public void onBulletHitBullet(BulletHitBulletEvent e){
		bulletHitOtherBullet++;
	}
		
	public void onHitWall(HitWallEvent e){
		hitWall++;
		movingFoward=(movingFoward) ? false:true;
	}
	
	public void printStats(){
		out.println("Place: " + (getOthers()+1));
		bulletHitPercent=((int) 100.0 * bulletHit / Math.max(1,bulletHit+bulletMiss+bulletHitOtherBullet));		
		out.println("Bullets hit: " + bulletHit + " (" + bulletHitPercent + "%) hit");
		out.println("Bullets missed: " + bulletMiss + " (" + ((int) 100.0 * bulletMiss / Math.max(1,bulletHit+bulletMiss+bulletHitOtherBullet)) + "%) missed");
		out.println("Bullet hit bullet: " + bulletHitOtherBullet + " (" + ((int) 100.0 * bulletHitOtherBullet / Math.max(1,bulletHit+bulletMiss+bulletHitOtherBullet)) + "%) hit other bullets");
		out.println("Hit by bullet: " + bulletHitMe + " bullet(s) hit me");
		out.println("Hit other robots: I hit other robots " + hitRobot + " time(s)");
		out.println("Hit walls: I hit walls " + hitWall + " time(s)");
	}
	
	public void onSkippedTurn(SkippedTurnEvent e){
		out.println("SkippedTurn: " + e.getTime());
	}

	public class Enemy{
		public String name;
		public double x;
		public double y;
		public double energy;
		public double distance;
		public double heading;
		public double fearFactor;
		public long timeSinceLastScan;	
	}
}
									