package myl.nano;
import robocode.*;
//import java.awt.Color;

/**
 + Kakuru "rainbow serpent" - a nanobot at codesize 244 by Martin Y Lepsoy (DrLoco)
 + email: mlepsoy@yahoo.no
 |
 |
 + Version 1.00
 + 26.03.2003
 + features a nanosized pattern matcher
 |
 + Version 1.10
 + 31.03.2003
 + improved pattern matcher
 + now searches for the best pattern over the time a power 3 bullet uses to reach the target
 + to little code to include a more advanced movement.
 |
 + Version 1.11
 + 03.04.2003
 + added comments
 |
 + Version 1.20
 + 24.04.2003
 + improved movement greatly!!
 + moves in a random direction when we detect an energychange
 + decreased codesize to 244!! never thought that was possible
 + changed the comments to explain rather then write the code with words(which was rather useless;)
 |
 |
 + The reason I made this bot an open source bot is becasue I hope it will inspire and give ideas to other robocoders
 + Feel free to use parts of my codes for your own use as long as you
 + make your bot open source,
 + don't just copy this bot as it is,
 + don't just copy this bot and modify it. 
 + Also I would appreciate credit;)
 |
 |
 + I would like to thank Albert Prez with his NanoLauLectrik for giving me the ideas I needed to finish my nano pattern analyzer
 */
public class Kakuru extends AdvancedRobot
{
	/**
	 * Variables used for our gun
	 *
	 * storageSize is the size of our stored values for our pattern matcher
	 * searchSize is how much of the storageSize we will search in when trying to find a pattern
	 * pattern[] is the list we store every velocity relative to the bearing to -/and the heading of the target
	 */
	
	final static int	storageSize = 1000;
	final static int	searchSize = storageSize - 111;
	static double[]		pattern = new double[ storageSize ];
	static int			matchIndex;
	
	/**
	 * Variables used for our movement
	 *
	 * lastEnergy is used to keep track of the target's energy so we can detect any changes
	 */
	
	static double		lastEnergy;
	
	public void run() {
		
		/**
		 * I have almost enough codesize to include color now.
		 * That will be my main todo for my next release..
		 * It doesn't look very bright though. I have done
		 * everything I could think of to reduce the codesize.
		 *
		 * setColors( null , null , Color.yellow );
		 */
	
		setTurnRadarRightRadians( Double.POSITIVE_INFINITY );
	}
	
	public void onScannedRobot( ScannedRobotEvent e ) {
		int index , timeToImpact , length;
		double bearing , match , bestMatch;
		
		/**
		 * Kakuru's movement:
		 * 
		 * when an energychange in the opponent is detected,
		 * drive in a random direction.
		 *
		 * we will always stay at 90 degrees from target.
		 */
		
		if ( lastEnergy != ( lastEnergy = e.getEnergy() ) ) {
			setAhead( getRadarTurnRemainingRadians() );
		}
		
		setTurnRightRadians( ( bearing = e.getBearingRadians() ) + Math.PI / 2 );
		
		/**
		 * Kakuru's pattern matcher:
		 *
		 * the concept of my patter matcher is simple.
		 * we store the velocity relative to the bearing to -/and the heading of the target every tick in pattern[].
		 * pattern[ 0 ] is always the current tick.
		 *
		 * then we search through all stored values to try to find a match.
		 * the length of the pattern we try to match, is equal to the time a bullet needs to reach the target.
		 *
		 * then we use the pattern that seems most like the behaviour our target has had reasently,
		 * and aim at the target with an offset equal to the offset given by the pattern matcher.
		 * that offset is found by looking how the enemy moved in our stored values in a time equal to
		 * the time a bullet needs to reach the target.
		 */
		
		bestMatch = index = searchSize;
		pattern[ 0 ] += e.getVelocity() * Math.sin( e.getHeadingRadians() - ( bearing += getHeadingRadians() ) );
		
		do {
			match = 0;
			length = 1;
			do {
				match += Math.abs( getOffset( length , 1 ) - getOffset( index + length , 1 ) );
			} while( length++ < ( timeToImpact = (int)( e.getDistance() / 11 ) ) );
			
			if ( match < bestMatch && index > timeToImpact ) {
				matchIndex = index;
				bestMatch = match;
			}
			pattern[ index + 1 ] = pattern[ index ];
		} while( index-- > 0 );
		
		setTurnGunRightRadians( Math.sin( bearing + getOffset( matchIndex , timeToImpact ) / e.getDistance() - getGunHeadingRadians() ) );
		
		setTurnRadarLeftRadians( getRadarTurnRemainingRadians() );
		
		fire( 3 );
	}
	
	/**
	 * get the offset difference between two points in our stored values.
	 */
	
	public double getOffset( int index , int range ) {
		return ( pattern[ index - range ] - pattern[ index ] );
	}
}