/*package davidalves.net.movement;

import robocode.*;
import davidalves.net.*;
import davidalves.net.data.*;
import davidalves.net.math.*;
import davidalves.net.movement.strategies.*;
import davidalves.net.movement.strategies.duel.*;
import davidalves.net.util.*;
import java.util.*;
import java.io.*;

public class MovementManager{
	Duelist me;
	EnvironmentInterface environment;
	MovementInterface currentStrategy;
	int currentStrategyIndex = -1;
	
	public MovementManager(Duelist myBot, EnvironmentInterface myEnvironment){
		me = myBot;
		environment = myEnvironment;
		if(me.strategyDatabase != null){
			currentStrategyIndex = me.strategyDatabase.getMovementStrategy(me);
			currentStrategy = me.strategyDatabase.getMovementInterface(currentStrategyIndex);
		} else {
			currentStrategy = new WaypointStrategy(me, 5, 10, 5, 10);
		}
		currentStrategy = new WaypointStrategy(me, 5, 10, 5, 10);
	}
	
	public void manageMovement(){
		currentStrategy.driveTank(me, environment);
	}
}*/

package davidalves.net.movement;

import robocode.*;
import davidalves.net.*;
import davidalves.net.data.*;
import davidalves.net.math.*;
import davidalves.net.movement.strategies.duel.*;
import davidalves.net.movement.strategies.*;
import davidalves.net.util.*;
import java.util.*;
import java.io.*;

public class MovementManager{
	Duelist me;
	EnvironmentInterface environment;
	MovementInterface[] movementStrategy;
	
	int bestDuelMovement = -1;
	
	public MovementManager(Duelist myBot, EnvironmentInterface myEnvironment){
		me = myBot;
		environment = myEnvironment;
		
		movementStrategy = new MovementInterface[3];
		
		
		movementStrategy[0]	= new WaypointStrategy(me, 5,10,5,10);
		movementStrategy[1]	= new GoToCenter();
		//movementStrategy[2] = new VictoryDance();
		
		//movementStrategy[0]	= new HybridDuelStrategy();
		//movementStrategy[0] = new CornerMovementStrategy();
		//movementStrategy[0]	= new AvoidanceStrategy();
		
		
	}
	
	public void manageMovement(){
		//If we've won, do a dance
		if (me.getOthers() == 1 && environment.targetLocked()){ //select best duel movement
			if(bestDuelMovement == -1){
				try{
						//StrategyDatabase db = (StrategyDatabase)(me.strategyDatabase.get(environment.getTarget().getRobotClass()));
						bestDuelMovement = me.strategyDatabase.getMovementStrategy(me);
						//me.out.println("\nMovement strategy for this round: " + me.strategyDatabase.getMovementInterface(bestDuelMovement));
						//me.out.println("Win rate while using strategy: " + me.strategyDatabase.getMovementStrategyDamageRate(bestDuelMovement));
						//me.out.println("\n" + me.strategyDatabase.winRatesTable());
					
				} catch (Exception e) {
					//me.out.println("Error, driving to center...\n" + e);
					movementStrategy[0].driveTank(me, environment); //if there's an error, drive to the center and print the error
				}
			} else {
				//StrategyDatabase db = (StrategyDatabase)(me.strategyDatabase.get(environment.getTarget().getRobotClass()));
				me.strategyDatabase.getMovementInterface(bestDuelMovement).driveTank(me,environment);
				//db.addBulletMiss(bestDuelMovement);
			}
		}
	}
	
	/*public void hitByBullet(double damage){
		if (bestDuelMovement != -1 && me.getOthers() == 1){
			StrategyDatabase db = (StrategyDatabase)(me.strategyDatabase.get(environment.getTarget().getRobotClass()));
			//db.addBulletHit(damage, bestDuelMovement);
			//me.out.println("Hit by bullet, adding " + damage + " damage. ");
		}
	}*/
	
	public void wonRound(){
		//StrategyDatabase db = (StrategyDatabase)(me.strategyDatabase.get(environment.getTarget().getRobotClass()));
		if(bestDuelMovement != -1){
			me.strategyDatabase.addWin(bestDuelMovement);
		}
		bestDuelMovement = -1;
	}
	
	public void lostRound(){
		//StrategyDatabase db = (StrategyDatabase)(me.strategyDatabase.get(environment.getTarget().getRobotClass()));
		if(bestDuelMovement != -1){
			me.strategyDatabase.addLoss(bestDuelMovement);
		}
		bestDuelMovement = -1;
	}
}