package davidalves.net.targeting;

import robocode.*;
import davidalves.net.*;
import davidalves.net.math.*;
import davidalves.net.data.*;
import davidalves.net.util.*;
import java.util.*;
import java.io.*;

/**
 * @author David Alves
 *
 */
public class VirtualBullet implements Serializable{
	Point origin;
	int firingStrategy;
	int rangeClass;
	double power, speed, heading, timeFired;
	String targetName;
	
	public String toString(){
		String returnValue = "\n";
		returnValue += "Bullet Information:\n";
		returnValue += "  Target Name: " + targetName + "\n";
		returnValue += "  Robot Type: " + "\n";
		returnValue += "  Origin: " + origin + "\n";
		returnValue += "  Power: " + power + "\n";
		returnValue += "  Speed: " + speed;
		return returnValue;
	}
	
	public VirtualBullet(String bulletTarget, int range, int strategy, double angleFired, Point bulletOrigin, double timeBulletFired, double bulletPower){//{{{
		speed = 20 - 3 * bulletPower;
		origin = bulletOrigin;
		heading = angleFired;
		targetName = bulletTarget;
		power = bulletPower;
		rangeClass = range;
		firingStrategy = strategy;
		timeFired = timeBulletFired;
		
	}
	
	public Point getPosition(double time){
		double distanceTravelled = (time - timeFired) * speed;
		Point offset = new Point(distanceTravelled * DaveMath.xComponent(heading), distanceTravelled * DaveMath.yComponent(heading));
		return origin.plus(offset);
	}
	
	public int getRangeClass(){
		return rangeClass;
	}
	
	public int getFiringStrategy(){
		return firingStrategy;
	}
	
	public String getTarget(){
		return targetName;
	}
}