package sgp;
import robocode.*;
import java.util.*;

/**
 * Parameter - a class by Simon Parker
 */

public class Parameter
{
	private double max;
	private double min;
	private double defaultValue;
	private double value;
	private String name;

	public Parameter(double minimum, double maximum, double defValue)
	{
		max = maximum;
		min = minimum;
		defaultValue = defValue;
		value = defValue;
		name = "Unnamed Parameter";
	}

	public Parameter(double minimum, double maximum, double defValue, String paramName)
	{
		max = maximum;
		min = minimum;
		defaultValue = defValue;
		value = defValue;
		name = paramName;
	}

	public double getValue()
	{
		return value;
	}

	public void setDefault()
	{
		value = defaultValue;
	}

	public void setValueFromScaledDouble(double scaledVal)
	{
		//0 corresponds to the minimum, 1 is max

		value = scaledVal * (max - min) + min;
		value = Math.min(max, value);
		value = Math.max(min, value);
	}

	public double getMax()
	{
		return max;
	}

	public double getMin()
	{
		return min;
	}

	public String getName()
	{
		return name;
	}

	public void setValue(double val)
	{
		value = val;
		value = Math.min(max, value);
		value = Math.max(min, value);
	}

	public Parameter copy()
	{
		return new Parameter(min,max,value,name);
	}
}
