package bvh.fry;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import robocode.ScannedRobotEvent;
import robocode.util.Utils;

public class Mjolnir  implements Constanten {
   public static boolean movementChallenge;
   public static boolean targettingChallenge;
   public boolean meleeGevecht;
   public Freya bot;
   public double xMax;
   public double yMax;
   public static Rectangle2D slagveld;
   public Ellipse2D.Double maximumCirkel;
   public boolean kanonUitlijningAfgerond = true;
   public Doel doel;

  public Mjolnir(Freya bot, double xMax, double yMax) {
      this.bot = bot;
      this.xMax = xMax;
      this.yMax = yMax;

      this.maximumCirkel = new Ellipse2D.Double(0, 0, xMax, yMax);
      this.slagveld = new Rectangle2D.Double(0, 0, xMax, yMax);
      this.meleeGevecht = (bot.getOthers() > 1);

  }

   public void onScannedRobot(Doel d) {
      // selecteer een nieuw doel als geen doel actief is
      // of als een ander doel (significant) dichterbij is: he biedt voordelen
      // om op nabije opponenten te schieten, maar omdat het kanon steeds opnieuw
      // moet worden gericht (over soms grote hoeken) moet in dit geval niet
      // te snel een nieuw doel worden geselecteerd.
      // Verder wordt een eenvoudig te vernietigen doel altijd geselecteerd.
      // Uitzondering: een nieuw doel wordt niet geselecteerd binnen een vuur-cyclus.
      //
      // to do: misschien moet de benodigde draaihoek in de overweging worden meegenomen.
      //
      if (doel == null || !doel.actief
            || ((bot.getGunHeat() / bot.getGunCoolingRate()) > 5D
            && (bot.positie.distance(d) < 0.85 * bot.positie.distance(doel) || (d.energie < 20D && bot.positie.distance(d) < 300D)))) {
         doel = d;
      }

      // vuur nieuw test-golf:
      vuurGolf(d);
   }

   public double[] geefTrageGFStats(Doel d) {
      bot.log("geefTrageGFStats():");

      double kogelSnelheid = BotUtils.berekenKogelSnelheid(bepaalKanonVuurkracht(d));
      long vliegtijd = (long) (bot.positie.distance(d) / kogelSnelheid);
      Point2D.Double doelPositie = d.schatPositie(bot.getTime() + vliegtijd);

      // slagIndex had voorheen 4 waarden!
      //slagIndex = (int) Math.min(1D + Math.round(getOthers() / 4D), SLAGKARAKTERISERING - 1);
      int slagIndex = bot.getOthers() == 1 ? 0 : 1;

      int positieIndex = slagveld.contains(doelPositie) ? 0 : (maximumCirkel.contains(doelPositie) ? 1 : 2);
      int afstandIndex = bepaalAfstandIndex(doelPositie);
      int lateraleSnelheidsIndex = (int) Math.abs(d.lateraleSnelheid);
      int transversaleSnelheidsIndex = (int) (8D - d.transversaleSnelheid);
      int versnellingsIndex = (int) Math.round(d.versnelling);

      if (versnellingsIndex != 0) {
         versnellingsIndex = (versnellingsIndex < 0) ? 1 : 2;
      }

      double[] gf = null;

      try {
         gf = d.trageGFStats[slagIndex][positieIndex][afstandIndex][lateraleSnelheidsIndex][meleeGevecht ? 0
                                                                                                         : transversaleSnelheidsIndex][meleeGevecht
            ? 0 : versnellingsIndex];
      } catch (ArrayIndexOutOfBoundsException e) {
         System.out.println("geefGFStats(): ArrayIndexOutOfBoundsException ================");
         System.out.println("positieIndex               = " + positieIndex + " ( MAX= " + (POSITIESEGMENTEN - 1) + ")");
         System.out.println("afstandIndex               = " + afstandIndex + " ( MAX= " + (AFSTANDSEGMENTEN) + ")");
         System.out.println("snelheidsIndex             = " + lateraleSnelheidsIndex + " ( MAX= "
            + (LATERALESNELHEIDSSEGMENTEN - 1) + ")");
         System.out.println("transversaleSnelheidsIndex = " + transversaleSnelheidsIndex + " ( MAX= "
            + (TRANSVERSALESNELHEIDSSEGMENTEN - 1) + ")");
         System.out.println("geefGFStats(): einde ArrayIndexOutOfBoundsException ----------");
      }

      return (gf);
   }
   public double[] geefSnelleGFStats(Doel d) {
      bot.log("geefSnelleGFStats():");

      double kogelSnelheid = BotUtils.berekenKogelSnelheid(bepaalKanonVuurkracht(d));
      long vliegtijd = (long) (bot.positie.distance(d) / kogelSnelheid);
      Point2D.Double doelPositie = d.schatPositie(bot.getTime() + vliegtijd);

      int afstandIndex = bepaalAfstandIndex(doelPositie);
      int lateraleSnelheidsIndex = (int) Math.abs(d.lateraleSnelheid);

      double[] gf = null;

      try {
         gf = d.snelleGFStats[afstandIndex][lateraleSnelheidsIndex];
      } catch (ArrayIndexOutOfBoundsException e) {
         System.out.println("geefGFStats(): ArrayIndexOutOfBoundsException ================");
         System.out.println("afstandIndex               = " + afstandIndex + " ( MAX= " + (AFSTANDSEGMENTEN) + ")");
         System.out.println("snelheidsIndex             = " + lateraleSnelheidsIndex + " ( MAX= "
            + (LATERALESNELHEIDSSEGMENTEN - 1) + ")");
         System.out.println("geefGFStats(): einde ArrayIndexOutOfBoundsException ----------");
      }

      return (gf);
   }

   private int bepaalAfstandIndex(Point2D.Double d) {
      int index = 0;
      double afstand = bot.positie.distance(d);

      if (afstand > 150D) {
         afstand -= 150D;
         index = Math.min(1 + (int) Math.floor(afstand / 200D), AFSTANDSEGMENTEN);
      }

      return (index);
   }

   /**
    * DOCUMENT ME!
    *
    * @param d DOCUMENT ME!
    */
   public void vuurGolf(Doel d) {
      bot.log("vuurGolf():");

      double kogelSnelheid = BotUtils.berekenKogelSnelheid(bepaalKanonVuurkracht(d));
      Point2D.Double doelpositie = new Point2D.Double(d.getX(), d.getY());

      Golf g = new Golf(bot.positie, doelpositie, kogelSnelheid, d.cirkelRichting, bot.getTime(), 0, geefSnelleGFStats(d), geefTrageGFStats(d));
      d.golven.add(g);
   }

   public int geefSchattingGF(Doel d, double kogelkracht, int besteGF) {
      bot.log("geefSchattingGF():");

      int schattingGF = GF_MIDDEN;
      // schiet direct op doel indien dit stationair is doordat het bijna is uitgeschakeld
      if (!(d.energie == 0 && d.snelheid == 0)) {
         double[] stats;
         if (bot.getRoundNum() >= 0 ) {
            stats = geefTrageGFStats(d);
         }
         else {
            stats = geefSnelleGFStats(d);
         }
         // anders bepaal meest waarschijnlijke schietrichting
         double kogelSnelheid = BotUtils.berekenKogelSnelheid(kogelkracht);
         double[] test = new double[(2 * GF_MIDDEN) + 1];
         int smoothWidth = Math.max((int) Math.round(
                  ((2D * GF_MIDDEN + 1D) * Math.atan((0.5 * BOTGROOTTE) / doel.distance(bot.positie))) / Math.asin(
                     MAXIMUM_SNELHEID / kogelSnelheid)), 1);

         // window de data met een driehoekig filter:
         for (int gf = 0; gf <= (2 * GF_MIDDEN); gf++) {
            for (int j = -smoothWidth; j < smoothWidth; j++) {
               double factor = (j == 0) ? 1D : (1 / Math.abs(j));
               int bin = BotUtils.maxMin(gf + j, 0, 2 * GF_MIDDEN);
               test[gf] += factor * stats[bin];
            }
         }

         // en bepaal beste GF (ongelijk aan tot nu toe bekende beste GF die buiten slagveld valt):
         for (int gf = 0; gf <= (2 * GF_MIDDEN); gf++) {
            if (test[gf] > test[schattingGF] && gf != besteGF) {
               schattingGF = gf;
            }
         }
      }

      return (schattingGF);
   }
   
   private boolean GFBinnenSlagveld(Doel d, double doelRichting, double kracht, Point2D.Double volgendePositie, int bestGF) {
      boolean binnenSlagveld;
      double schiethoek = geefSchietHoek(doelRichting, kracht, bestGF);
      Point2D.Double verwachteInslagPositie = BotUtils.projecteerPositie(doel, schiethoek, volgendePositie.distance(doel));
      if(slagveld.contains(verwachteInslagPositie)) {binnenSlagveld = true;}
      else {binnenSlagveld = false;}
      
      return(binnenSlagveld);
   }
   
   private double geefSchietHoek(double doelRichting, double kracht, int bestGF) {
       double maxOntsnappingsHoek = Math.asin(MAXIMUM_SNELHEID/BotUtils.berekenKogelSnelheid(kracht));
       double binBreedte = maxOntsnappingsHoek / (double)GF_MIDDEN;
       double deltaHoek = (doel.cirkelRichting*binBreedte) * (bestGF - GF_MIDDEN );
       
       return(Utils.normalRelativeAngle(doelRichting - bot.getGunHeadingRadians() + deltaHoek));
   }

   /**
    * Vuurt het kanon af als en de resterende energie voldoende is om niet te worden
    * uitgeschakeld en het kanon is uitgelijnd met de (verwachte) richting naar het doel.
    */
   public void uitvoeren() {
      bot.log("stuurKanon():");

      if (!movementChallenge) {
         Point2D.Double volgendePositie;
         
         if (bot.getOthers() > 1) {
            volgendePositie = new Point2D.Double(bot.getX(), bot.getY());
         }
         else {
            volgendePositie = bot.geefVolgendePositie();
         }
         double doelRichting = BotUtils.bepaalRichting(volgendePositie, doel);
      
         if (bot.getGunHeat() > 3D * bot.getGunCoolingRate()) {
            kanonUitlijningAfgerond = false;

            // richt kanon recht op doel:
            bot.setTurnGunRightRadians(Utils.normalRelativeAngle(doelRichting - bot.getGunHeadingRadians()));
         } else {
            // kanon op verwachte positie richten of, als dit is afgerond, vuren:
            double kanonVuurkracht = bepaalKanonVuurkracht(doel);

            if (kanonUitlijningAfgerond
                  && bot.getEnergy() > kanonVuurkracht
                  && Math.abs(bot.getGunTurnRemainingRadians()) < Math.atan2(18D, doel.distance(volgendePositie))) {
               kanonUitlijningAfgerond = false;

               if (bot.setFireBullet(kanonVuurkracht) != null) {
                  doel.schotenFreya++;
                  doel.gemKogelkrachtFreya += kanonVuurkracht;
               }
            } else {
               kanonUitlijningAfgerond = true;
               int i = 0;
               int bestGF = geefSchattingGF(doel, kanonVuurkracht, 99);
               // itereer GF totdat deze binnen slagveld valt.
               if ( !GFBinnenSlagveld(doel, doelRichting, kanonVuurkracht, volgendePositie, bestGF)
                 && i++ < 6
                  ) {
                   bestGF = geefSchattingGF(doel, kanonVuurkracht, bestGF);
               }
               // bij teveel iteraties gewoon recjt op doel schieten...
               if ( i == 5) {
                  bestGF = GF_MIDDEN;
               }
               
               bot.setTurnGunRightRadians(geefSchietHoek(doelRichting, kanonVuurkracht, bestGF));

               bot.log("stuurKanon(): schattingGF = " + bestGF + " (doel = " + doel.naam + ")");
            }
         }
      }
   }

   public double bepaalKanonVuurkracht(Doel d) {
      double kanonVuurkracht;

      if (targettingChallenge) {
         kanonVuurkracht = MAXIMUMVUURKRACHT;
      } else {
         if (d.energie <= 16D) {
            kanonVuurkracht = BotUtils.berekenMinimumVuurkracht(d.energie);
         } else {
            int afstandIndex = bepaalAfstandIndex(d);
            if (afstandIndex < 2) {
               kanonVuurkracht = MAXIMUMVUURKRACHT;
            } else if (afstandIndex < 5) {
               kanonVuurkracht = STANDAARDVUURKRACHT;
            }
            else {
               kanonVuurkracht = MINIMUMVUURKRACHT;
            }
         }
      }

      return (kanonVuurkracht);
   }

}