package nat.base;

import java.text.NumberFormat;

import robocode.Robot;

public final class Logger {
	private final Robot _robot;
	private final NumberFormat nf;
	
	Logger(Robot robot) {
		_robot = robot;
		nf = NumberFormat.getNumberInstance();
		nf.setMaximumFractionDigits(0);
		nf.setMaximumIntegerDigits(4);
		nf.setMinimumFractionDigits(0);
		nf.setMinimumIntegerDigits(4);
	}
	
	public void log(String msg) {
		_robot.out.print(nf.format(_robot.getTime()));
		_robot.out.print(" ");
		_robot.out.println(msg);
	}
}
