/*
 * Class.java
 *
 * Created on April 7, 2002, 1:12 AM
 */

package tobe.movement;
import tobe.util.*;
import tobe.platform.*;
import tobe.statistics.*;
import robocode.*;

/**
 *
 * @author  tobe
 * @version 
 *
 * The idea behind this is to have seven points on the circle around the enemy that I move between randomly.
 * TODO: fix dodging taking account of what can be done with my current velocitybefore bullet hits
 * TODO: fix so that I am not so static
 */
public class Secant_w implements Movement {
        
        private double movement;
        private double turnDoneTime;
		private double plannedMovement;
		private double waitTime;
		private double fired;
        
        private HitWallEvent hitWall;
        private HitRobotEvent hitRobot;
        
        private String trackedName;
        private BearingVector trackedPosition = new BearingVector();
        private BearingVector trackedMovement = new BearingVector();
        private BearingVector v = new BearingVector();
		private BearingVector w = new BearingVector();
		
		private java.util.Random rand = new java.util.Random();
        
        public void go(CommandCentre cc) {
            AdvancedRobot bot = cc.getBot();
            TargetStatistics t = cc.getPreferredTarget();
            if(t != null) {
              t.getPosition(trackedPosition);
              t.getMovement(trackedMovement);
              trackedName = t.getName();
              fired = t.firedBullet(bot.getTime());
            } else {
              trackedName = null;
              fired = 0;
            }
            if(bot.getTime() < waitTime) {
				//do nothing
            } else if(bot.getTime() > waitTime && bot.getTime() <= waitTime +1.0 ) {
				bot.setAhead(plannedMovement);
	} else if(t != null && rand.nextDouble() <= fired/4 && 0.1 <= fired && 3.0 >= fired) {//maybe he fired
                goTurnAndMove(bot, true);//dodging a shot
			} else if(bot.getTime() > turnDoneTime) {
                goTurnAndMove(bot, false);
			}
	    	else if(bot.getDistanceRemaining() < 15) {
            	double myHeading = bot.getHeadingRadians();
            	if( movement < 0 ) myHeading -= Math.PI;
            	if(myHeading < 0) myHeading += Math.PI*2;

                v.setPoints(bot.getX(), bot.getY(), trackedPosition.getToX(), trackedPosition.getToY());

				double turn=BearingVector.normalizeAngle(v.getBearing() + Math.PI/2.0 - myHeading);
            	if( turn < -Math.PI/2.0 || turn > Math.PI/2.0 ) {
                	turn = BearingVector.normalizeAngle(turn + Math.PI);
                }
				bot.setTurnRightRadians(turn);
            }
			/* wiggle a bit */
			if(Math.abs(bot.getDistanceRemaining()) < 4) {
				bot.setAhead(rand.nextDouble()*8-4);
			}
			if(Math.abs(bot.getTurnRemaining()) < 3) {
				bot.setTurnRight(rand.nextDouble()*6-3);
			}
        }
        
        private void goTurnAndMove(AdvancedRobot bot, boolean dodging) {
            double width = bot.getWidth();
            double timex = bot.getTime();
            double myHeading = bot.getHeadingRadians();
            if( movement < 0 ) myHeading -= Math.PI;
            if(myHeading < 0) myHeading += Math.PI*2;

			if( trackedName == null )
				v.setPoints(bot.getX(), bot.getY(), bot.getBattleFieldWidth()/2, bot.getBattleFieldHeight()/2);
			else
                v.setPoints(bot.getX(), bot.getY(), trackedPosition.getToX(), trackedPosition.getToY());

			double sec1 = width+5;
			double sec2 = 2.0*sec1;
			double sec3 = sec2 + sec1;
			double radius = v.getDistance();
			double a3 = Math.asin(sec3/2.0/radius)*2.0;
			double angle = 2.0*a3;
			double arc = angle * radius;
			double idealAngle = Math.PI/3.0;
			double idealRadius = sec3/2.0/Math.sin(idealAngle/4.0);
			if( angle > idealAngle) {
				if(dodging) {
					if( angle > 5*Math.PI/6.0 && rand.nextDouble() < 0.5) {
						angle = Math.PI;
						a3 = angle/2;
						radius = sec3/2/Math.sin(a3/2);
					} else {
						radius += 40;
						a3 = Math.asin(sec3/2.0/radius)*2.0;
					}
				} else {
					radius += 20;
					a3 = Math.asin(sec3/2.0/radius)*2.0;
				}
			}
			
			if( angle < idealAngle) {
				if(dodging) {
					radius -= 60;
					a3 = Math.asin(sec3/2.0/radius)*2.0;
				} else {
					radius -= 30;
					a3 = Math.asin(sec3/2.0/radius)*2.0;
				}
			}
			
			double a2 = Math.asin(sec2/2.0/radius)*2.0;
			double a1 = Math.asin(sec1/2.0/radius)*2.0;
			
			v.setDistance(radius);
			
			double time = 16;
			double wait = 0;
			
            int choice = (int) Math.floor(rand.nextDouble()*7.0);
            switch(choice) {
                case 0: v.setBearing(v.getBearing() + a1); time = 8; /*time *= (0.25+0.5*Math.random());*/ break;
                case 1: v.setBearing(v.getBearing() + a2); wait = 2; time = 12; /*time *= (0.4+0.5*Math.random());*/ break;
                case 2: v.setBearing(v.getBearing() + a3); wait = 4;/*time *= (0.8+0.2*Math.random());*/ break;
                case 3: v.setBearing(v.getBearing() - a1); time = 8;/*time *= (0.25+0.5*Math.random());*/ break;
                case 4: v.setBearing(v.getBearing() - a2); wait = 2; time = 12;/*time *= (0.4+0.5*Math.random());*/ break;
                case 5: v.setBearing(v.getBearing() - a3); wait = 4;/*time *= (0.8+0.2*Math.random());*/ break;
                case 6: time = 6;/*time *= (0.1+0.4*Math.random());*/ break;
            }
			if(!dodging && v.getDistance() < 160) time = 8;
			if(dodging) {
				if(choice != 6)time = 16; else time=10;
				if(v.getDistance() < 120 && rand.nextDouble() < 0.125) {//ram him!
					v.setVector(trackedPosition);
					time = 12;
					wait = 4;
				}
			}
            
			double x = v.getToX();
			if( x < width ) x = bot.getBattleFieldWidth() - width;
			if( x > bot.getBattleFieldWidth() - width) x = width;
			double y = v.getToY();
			if( y < width ) y = bot.getBattleFieldHeight() - width;
			if( y > bot.getBattleFieldHeight() - width) y = width;
            v.setPoints(x,y,bot.getX(), bot.getY());
            double turn = BearingVector.normalizeAngle(v.getBearing() - myHeading);
            double move = v.getDistance();
            
			if( turn < -Math.PI/2.0 || turn > Math.PI/2.0 ) {
                turn = BearingVector.normalizeAngle(turn + Math.PI);
                movement = -movement;
            }
            bot.setMaxVelocity(8);
            if( movement < 0) move=-move;
            bot.setTurnRightRadians(turn);
			bot.setAhead(move);
			plannedMovement = move;
            if(dodging && wait > 0) bot.setAhead(bot.getVelocity()*(Math.abs(bot.getVelocity())+1)/2.0);
            turnDoneTime = timex + time;//*(0.5 + 0.7*Math.random());
			if(dodging) waitTime=timex+wait;
			else waitTime=0;
	}
        
        public void init(CommandCentre cc) {
            AdvancedRobot bot = cc.getBot();
            movement = 120;
            turnDoneTime = -5;
			waitTime = -5;
            if( Math.random() < 0.5 ) movement = -movement;
            hitWall = null;
            hitRobot = null;
            trackedName = null;
            bot.setMaxTurnRate(100);
            bot.setMaxVelocity(100);
        }
}
