package bvh.tyr;

/**
 * Utils
 *
 * Algemene hulpfuncties (gepikt van robocode website)
 */
class Utils implements Constanten {

//if a bearing is not within the -pi to pi range, alters it to provide the shortest angle
   public static double normaliseBearing(double ang) {
      while (ang >   Math.PI) ang -= 2*Math.PI;
      while (ang <= -Math.PI) ang += 2*Math.PI;
      return ang;
   }

//if a heading is not within the 0 to 2pi range, alters it to provide the shortest angle
   public static double normaliseHeading(double ang) {
	   ang = ang%(2*Math.PI);
      if (ang > 2*Math.PI) ang -= 2*Math.PI;
      if (ang < 0)         ang += 2*Math.PI;
      return ang;
   }

/**
* bepaal richting van bot tot doel-positie
*/
   public static double bepaalRichting(double Xd, double Yd, double Xb, double Yb ) {
      return Math.atan2( (Xd - Xb), (Yd - Yb) );
   }

/**
* bepaal afstand van bot tot doel-positie
*/
   public static double bepaalAfstand(double Xd, double Yd, double Xb, double Yb ) {
      return Math.sqrt( (Xd-Xb)*(Xd-Xb) + (Yd-Yb)*(Yd-Yb) );
   }

} // einde Utils
