package axeBots.data;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

import axeBots.AxeBot;
import axeBots.util.AxeFiles;
import axeBots.util.RoboMath;
import robocode.*;

/**
 * @author Marcos Machado Coelho de Souza
 *
 * Class made to calculate the bot's score.
 * Note that it will only work in 1x1, melee calculus would be a lot more
 * complicated (and possibly not even 70% accurate, given that when u die, your thread dies).
 *
 * Calculus based on the Wiki Pages, topic Score.
 * extracted from: http://robowiki.dyndns.org/perl/robowiki?Score
 * 
 * The best I can come up with is: 
 * 
 * survival = 50 * survival 1st (but I think this is wrong given the next category, and the fact that they could've combined it with this one by multiplying with 60 instead of 50) 
 * last survivor bonus = 10 * survival 1st 
 * bullet damage = total damage done to your enemies by hitting them 
 * bonus (bullet damage) = 20% of all damage done to the enemy you just killed by hitting him 
 * ram damage * 2 = total damage done to your enemies by ramming them * 2 
 * bonus (ram damage) = 30% of all damage done to the enemy you just killed by ramming him 
 * 
 * total score = sum of all of the above 
 * Does someone have a reference to an "official" formula? (Or did someone decompile the code?) 
 * 
 * ---FnH 
 * 
 * The survival and last survivor bonus are correct for 1v1 but for melee/team the folling is a more complete description: 
 * 
 * 50 points for each survivor when an opponent dies (by coming first in a 10 bot melee round you will have aquired 450 points - because 9 bots died before you) 
 * 
 * Last Survivor bonus = 10 * number of opponents at the start of the round. For a 10 bot melee the bonus = 90, 1v1 the bonus is 10. 
 * 
 * In a 10 bot melee battle survival points are distributed thus: 10th = 0 9th = 50 8th = 100 . . . 3rd = 350 2nd = 400 1st = 450 (+ 90 last survivor) 
 * 
 * ---Paul Evans 
 * 
 */

public class BotScore {

    public static final int STR_NAME= 0;
    public static final int STR_ROUNDS= 1;
    public static final int STR_ENEMIES_SCORE= 2;
    public static final int STR_SURVIVAL= 3;
    public static final int STR_LAST_SURVIVAL= 4;
    public static final int STR_BULLS_DMG= 5;
    public static final int STR_BULLS_AVG_DMG= 6;

    private int rounds;

    private static ArrayList allScores= new ArrayList();

    private double survival= 0;
    private double lastSurvivor= 0;
    private double bullsDmg= 0;
    private double bullsDmgBonus= 0;
    private double rammsDmg= 0;
    private double rammsDmgBonus= 0;

    private double nowBullsDmg= 0;
    private double nowRammsDmg= 0;

    private double closedOthersScore= 0;
    //private double score=0;
    private String botsName;

    public BotScore() {
        super();
        if (!allScores.contains(this)) {
            allScores.add(this);
        }
        // TODO Auto-generated constructor stub
    }

    public BotScore(String botsName) {
        this();
        this.botsName= botsName;
    }

    public void newRound() {
        AxeBot.getIt().out.println(botsName + " scorer new Round!");
        rounds++;
        //        rammsDmg += nowRammsDmg;
        //        bullsDmg += nowBullsDmg;
        nowBullsDmg= 0;
        nowRammsDmg= 0;
    }

    public void died() {
        terminus();
    }

    public void win() {

        AxeBot.getIt().out.println(botsName + " win!");
        survival += 50;
        lastSurvivor += 10;
        rammsDmgBonus += nowRammsDmg * 0.2;
        bullsDmgBonus += nowBullsDmg * 0.2;
        terminus();

    }

    private void terminus() {
        rammsDmg += nowRammsDmg;
        bullsDmg += nowBullsDmg;
        this.setClosedOthersScore(this.getOthersScore());
    }

    private void bullsEye(
        double energyAfter,
        double energyLeft,
        double bullsPower) {

        AxeBot.getIt().out.println(">>>>>>>>>>>>   "+
            botsName
                + " bullsEye! energyAfter:"
                + energyAfter
                + " energyLeft:"
                + energyLeft
                + " bullsPower:"
                + bullsPower+ " at:"+AxeBot.getIt().getTime() );

        double bullsDamage= RoboMath.getBulletDamage(bullsPower);
        nowBullsDmg
            += (bullsDamage=
                (Double.isNaN(energyAfter)
                    || (energyLeft > 0)
                    || (energyAfter > bullsDamage))
                    ? bullsDamage
                    : energyAfter);

        // score += bullsDamage;// + ((energyLeft < 0) ? (bullsDmg * 0.2) : 0);

    }

    public void bullsEye(BulletHitEvent bhe, double energyAfter) {
        this.bullsEye(energyAfter, bhe.getEnergy(), bhe.getBullet().getPower());
    }

    public void bullsEye(
        AdvancedRobot myBot,
        HitByBulletEvent hbbe,
        double energyAfter) {
        this.bullsEye(
            energyAfter,
            myBot.getEnergy(),
            hbbe.getBullet().getPower());
    }

    public void ramm(boolean itsFault) {}

    //    private double getBulletDamage(double energy) {
    //        return (4 * energy) + ((energy > 1) ? (2 * (energy - 1)) : 0);
    //    }
    /**
     * @return
     */
    public int getScore() {

        return (int)Math.round(
            survival
                + lastSurvivor
                + bullsDmg
                + nowBullsDmg
                + bullsDmgBonus
                + rammsDmg
                + nowRammsDmg
                + rammsDmgBonus);
    }

    public String toString() {
        DecimalFormat forma= new DecimalFormat("0.00");

        return this.botsName
            + ": "
            + getScore()
            + "("
            + forma.format(this.getELO() * 100)
            + ") rounds:"
            + this.rounds
            + "survival:"
            + (int)Math.round(survival)
            + " lastSurvivor:"
            + (int)Math.round(lastSurvivor)
            + " bullsDmg:"
            + (int)Math.round(bullsDmg + nowBullsDmg)
            + " bullsDmgBonus:"
            + (int)Math.round(bullsDmgBonus)
            + " rammsDmg:"
            + (int)Math.round(rammsDmg + nowRammsDmg)
            + " rammsDmgBonus:"
            + (int)Math.round(rammsDmgBonus);
    }

    public double getELO() {
        return this.getScore() / this.getOthersScore();
    }

    public double getOthersScore() {
        double all= 0;
        for (int i= 0; i < allScores.size(); i++) {
            all += ((BotScore)allScores.get(i)).getScore();
        }
        return all;
    }

    public static void save() {

//        ArrayList data= load();
//
//        try {
//
//            GZIPOutputStream zipout= null;
//
//            //seguranca p/ security exception
//            DataOutputStream w= null;
//            while (true) {
//
//                try {
//
//                    zipout= AxeFiles.getGZipOutputStream("ratings.gzip");
//                    //zipout.setLevel(9);
//                    break;
//                } catch (Throwable th) {
//                    AxeBot.getIt().out.println(
//                        " XXXXXXXXXXXXXXXXXX saving failed:" + th.getMessage());
//                }
//            }
//            AxeBot.getIt().out.println(" XXXXXXXXXXXXXXXXXX saving OK:");
//
//            //zipout.putNextEntry(new ZipEntry(dataFileName));
//            w= new DataOutputStream(zipout);
//
//            //  atualiza os scores          
//            for (int b= 0; b < allScores.size(); b++) {
//                boolean found= false;
//                BotScore score= (BotScore)allScores.get(b);
//                
//                
//                for (int i= 0; i < data.size(); i++) {
//                    BotScore botData= (BotScore)data.get(i);
//                    
//                    String nome= botData.getBotsName();
//
//                    if (nome.equals(score.getBotsName())) {
//						botData.add( score);
//                        break;
//                    }
//
//                }
////nao saiu no break, nao achou.  
//                data.add(score );
//            }
//            
//            //salva
//			for (int i= 0; i < data.size(); i++) {
//								BotScore botData= (BotScore)data.get(i);
//                    
//								String nome= botData.getBotsName();
//
//								if (nome.equals(score.getBotsName())) {
//									botData.add( score);
//									break;
//								}
//
//							}
//            
//
//            // PrintStreams don't throw IOExceptions during prints,
//            // they simply set a flag.... so check it here.
//            w.flush();
//            zipout.finish();
//            //zipout.closeEntry();
//            w.close();
//        } catch (IOException e) {
//            AxeBot.getIt().out.println("IOException trying to write: " + e);
//        }
//
//        for (int i= 0; i < allScores.size(); i++) {
//            allScores.get(i).save();
//        }
    }

    private static ArrayList load() {

        DataInputStream r= null;
        ArrayList retData= null;
        //String dataFileName= STAT_FILE_PREFIX + name + STAT_FILE_EXTENSION;

        try {

            File f= AxeBot.getIt().getDataFile("ratings.gzip");
            GZIPInputStream zipin= new GZIPInputStream(new FileInputStream(f));
            //zipin.getNextEntry();

            r= new DataInputStream(zipin); //new FileInputStream(f));
            byte[] rawData= null;
            r.read(rawData);
            String rawStrData= new String(rawData);
            String[] data= rawStrData.split("\r\n");
            retData= new ArrayList(data.length);
            for (int i= 0; i < data.length; i++) {
                ArrayList botData= null;
                retData.add(botData= new ArrayList());
                String[] botStrData= data[i].split("|");

                botData.add(botStrData[0]); //nome
                botData.add(new Double(Double.parseDouble(botStrData[1])));
                //elo
                botData.add(new Double(Double.parseDouble(botStrData[2])));
                //rounds
                botData.add(new Double(Double.parseDouble(botStrData[3])));
                //survival
                botData.add(new Double(Double.parseDouble(botStrData[4])));
                //lastSurvival
                botData.add(new Double(Double.parseDouble(botStrData[5])));
                //bullsDmg
                botData.add(new Double(Double.parseDouble(botStrData[6])));
                //bullsBnsDmg
                botData.add(new Double(Double.parseDouble(botStrData[7])));
                //outros pts
                //				return this.botsName
                //							+ ": "
                //							+ getScore()
                //							+ "("
                //							+ forma.format(this.getELO() * 100)
                //							+ ") rounds:"
                //							+ this.rounds
                //							+ "survival:"
                //							+ (int)Math.round(survival)
                //							+ " lastSurvivor:"
                //							+ (int)Math.round(lastSurvivor)
                //							+ " bullsDmg:"
                //							+ (int)Math.round(bullsDmg + nowBullsDmg)
                //							+ " bullsDmgBonus:"
                //							+ (int)Math.round(bullsDmgBonus)
                //							+ " rammsDmg:"
                //							+ (int)Math.round(rammsDmg + nowRammsDmg)
                //							+ " rammsDmgBonus:"
                //							+ (int)Math.round(rammsDmgBonus);

            }

        } catch (Throwable e) {

            AxeBot.getIt().out.println(" loading failed:" + e.getMessage());
        } finally {
            try {
                r.close();
            } catch (Throwable e2) {};
        }
        return null;

    }

    private void saveBot(DataOutputStream w) throws IOException {

        DecimalFormat forma= new DecimalFormat("#.##");

        w.writeBytes(this.botsName); //nome
        w.writeBytes(forma.format(Double.toString(this.getScore())) + "|");
        //elo
        w.writeBytes(forma.format(Double.toString(this.getRounds())) + "|");
        //rounds
        w.writeBytes(forma.format(Double.toString(this.survival)) + "|");
        //survival
        w.writeBytes(forma.format(Double.toString(this.lastSurvivor)) + "|");
        //lastsurvival
        w.writeBytes(forma.format(Double.toString(this.bullsDmg)) + "|");
        //bulls dmg
        w.writeBytes(forma.format(Double.toString(this.bullsDmgBonus)) + "|");
        //bulls dmg bns
        w.writeBytes(forma.format(Double.toString(this.getScore())) + "|\r\n");
        //outros

    }

    private void add(BotScore score) {

            if (this.botsName.equals(score.getBotsName())) {
                score.setBullsDmg(score.getBullsDmg() + this.getBullsDmg());
                score.setBullsDmgBonus(
                    score.getBullsDmgBonus() + this.getBullsDmgBonus());
                score.setClosedOthersScore(
                    score.getClosedOthersScore() + this.getClosedOthersScore());
                score.setSurvival(score.getSurvival() + this.getSurvival());
                score.setLastSurvivor(
                    score.getLastSurvivor() + this.getLastSurvivor());
                score.setRounds(score.getRounds() + this.getRounds());
            }

    }

    /**
     * @return
     */
    public int getRounds() {
        return rounds;
    }
    /**
     * @return
     */
    public String getBotsName() {
        return botsName;
    }

    /**
     * @return
     */
    public double getBullsDmg() {
        return bullsDmg;
    }

    /**
     * @return
     */
    public double getBullsDmgBonus() {
        return bullsDmgBonus;
    }

    /**
     * @return
     */
    public double getLastSurvivor() {
        return lastSurvivor;
    }

    /**
     * @return
     */
    public double getSurvival() {
        return survival;
    }

    /**
     * @param d
     */
    public void setBullsDmg(double d) {
        bullsDmg= d;
    }

    /**
     * @param d
     */
    public void setBullsDmgBonus(double d) {
        bullsDmgBonus= d;
    }

    /**
     * @param d
     */
    public void setLastSurvivor(double d) {
        lastSurvivor= d;
    }

    /**
     * @param i
     */
    public void setRounds(int i) {
        rounds= i;
    }

    /**
     * @param d
     */
    public void setSurvival(double d) {
        survival= d;
    }

    /**
     * @return
     */
    public double getClosedOthersScore() {
        return closedOthersScore;
    }

    /**
     * @param d
     */
    public void setClosedOthersScore(double d) {
        closedOthersScore= d;
    }
}