/*
 * Created on 10/11/2003
 *
 * To change the template for this generated file go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
package axeBots.data;

//import java.util.zip.DataFormatException;

import java.util.ArrayList;

import axeBots.AxeException;
import axeBots.okami.AxeVector;
import axeBots.util.RoboMath;

import java.awt.Point;
import java.awt.geom.*;

/**
 * @author Marcos
 *
 * To change the template for this generated type comment go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
public class PatternSample implements Comparable {

    private int age;
    // The static reference. Used by the instances to rate themselves in the compareTo()
    private static PatternSample REFERENCE= new PatternSample();
    private static long MAX_SAMPLE_AGE= 0;
    //private static int erasedPos= 0;

    // samples wideness
    public static int GROUPS[]=
        //{ 1, 2, 3, 4, 5, 10, 15, 20, 40, 60, 80 };
    { 1, 2, 5, 10, 20, 40, 80 };
    //, 120, 150 };

    // the samples
    private AxeVector samples[]= new AxeVector[7];
    //GROUPS.length];
    private double distanceMe= 0;
    private double headToMe= 0;
    private double distanceCorner= 0;
    private double distanceWall= 0;
    private double itsRate= 0;
    private int round= 0;
    // private int click= 0;
    private int pos= 0;

    private double originalAngle= 0;

    public PatternSample() {
        super();
        for (int i= 0; i < samples.length; i++) {
            samples[i]= new AxeVector();
        }
    }

    public PatternSample(
        AxeVector samps[],
        int pos,
        double distMe,
        double headToMe)
        throws AxeException {
        super();
        //this.round= round;
        //this.click= click;
        this.setHeadToMe(headToMe);
        this.pos= pos;
        if (samps.length == GROUPS.length) {
            distanceMe= distMe;
            distanceCorner= RoboMath.distToCorner(samps[0].getEndPoint());
            distanceWall= RoboMath.distToWall(samps[0].getEndPoint());
            samples= samps;
            this.normalize();
            // ROTATE THE FIRST VECTOR TO NORTH (0 DEGREES)
            // ROTATE THE REST BY THE AMOUNT ROTATED BY THE FIRST.
        } else {
            throw new AxeException(
                "PatternSample: wrong samples array size:" + GROUPS.length);
        }
    }

    public PatternSample(
        ArrayList interpol,
        int clicks,
        double distMe,
        double headToMe)
        throws AxeException {
        super();
        this.setHeadToMe(headToMe);
        int pos= interpol.size() - 1;
        distanceMe= distMe;
        int depth= clicks - 1;
        if ((interpol == null) || interpol.isEmpty() || (depth < 1)) {
            throw new AxeException("PatternSample: source empty or null.");
        }

        //this.round= round;
        //this.click= click;
        this.pos= pos;
        Point2D.Double p0= ((AxeVector)interpol.get(pos)).getEndPoint();

        distanceCorner= RoboMath.distToCorner(p0);
        distanceWall= RoboMath.distToWall(p0);

        for (int i= 0; i < samples.length; i++) {
            int tail= pos - PatternSample.GROUPS[i];

            if ((tail < 0) || (GROUPS[i] > depth)) {
                break;
            } else {
                Point2D.Double pf=
                    ((AxeVector)interpol.get(tail)).getEndPoint();
                samples[i]= new AxeVector(p0, pf);
            }
        }

        this.normalize();

    }

    public double rate() {

        double rate= 0;
        AxeVector refs[]= PatternSample.REFERENCE.getSamples();

        for (int i= 0; i < GROUPS.length; i++) {
            rate += (refs[i] == null)
                ? 0
                : (refs[i].getDiffModule(samples[i])) / GROUPS[i];

        }

        //rate += rate * (age * 0.001);

        //		referenceAprAngle = 

        //		Math.abs(RoboMath.normalRelativeAngle(REFERENCE.getOriginalAngle()  - this.getOriginalAngle())/2) 
        //		+ 
        double headsDiff=
            Math.abs(
                RoboMath.normalRelativeAngle(
                    Math.abs(REFERENCE.headToMe) - Math.abs(this.headToMe))
                    / 18D);
//        rate += (rate * headsDiff)
//            + (rate
//                * (Math
//                    .pow(Math.abs(REFERENCE.distanceMe - this.distanceMe), 0.4)
//                    / 1.5))
//            + (rate
//                * (Math
//                    .pow(Math.abs(REFERENCE.distanceWall - this.distanceWall), 0.4)
//                    / 1.5))
//            + (rate
//                * (Math
//                    .pow(Math.abs(REFERENCE.distanceCorner - this.distanceCorner), 0.4)
//                    / 1.5));
                    

                rate
                    += (rate
                        * Math.abs((REFERENCE.distanceMe - this.distanceMe) / 100.00))
                    + (rate
                        * Math.abs(
                            (REFERENCE.distanceWall - this.distanceWall) / 100.00))
                    + (rate
                        * Math.abs(
                            (REFERENCE.distanceCorner - this.distanceCorner) / 100.00));
                            

        itsRate= rate;
        return rate;
    }

    //    public boolean outOfRange() {
    //        return this.getAge() >= MAX_SAMPLE_AGE;
    //    }

    /** Sets the static reference vector. By being static all the instances will
     * be able to use it to rate themselves.
     * @param sample The 6 reference vectors
     */
    public static void setOrderParams(
        PatternSample sample,
        int maxRound,
        int maxClick) {
        MAX_SAMPLE_AGE= (maxRound * 1000000) + maxClick;
        REFERENCE= sample;
        //		ROTATE THE FIRST VECTOR TO NORTH (0 DEGREES)
        // ROTATE THE REST BY THE AMOUNT ROTATED BY THE FIRST.
    }

    public static int getMaxWideness() {
        return GROUPS[GROUPS.length - 1];
    }

    public int compareTo(Object obj) {
        int ret= 0;
        // DO THE 6 VECTORS COMPARISSON WITH THE 
        // 6 STATIC REFERENCE VECTORS. 
        // RETURN THE RATING (LOWER, BETTER!)
        PatternSample him= (PatternSample)obj;
        //long myAge= this.getAge();
        //long hisAge= him.getAge();

        double myRate= this.getItsRate();
        double hisRate= him.getItsRate();
        return (myRate < hisRate)
            ? -1
            : (myRate > hisRate)
            ? 1
            : (this.getPos() > him.getPos())
            ? -1
            : 1;

    }

    /**
     * @return
     */
    public AxeVector[] getSamples() {
        return samples;
    }

    /**
     * @param vectors
     */
    public void setSamples(AxeVector[] vectors) {
        samples= vectors;
    }

    //    /**
    //     * @return
    //     */
    //    public int getClick() {
    //        return click;
    //    }
    //
    //    /**
    //     * @return
    //     */
    //    public int getRound() {
    //        return round;
    //    }
    //
    //    /**
    //     * @param i
    //     */
    //    public void setClick(int i) {
    //        click= i;
    //    }
    //
    //    /**
    //     * @param i
    //     */
    //    public void setRound(int i) {
    //        round= i;
    //    }
    //
    //    public long getAge() {
    //        return (round * 1000000) + click;
    //    }

    private void normalize() {
        originalAngle= samples[0].getRelativeTheta();
        for (int i= 0; i < GROUPS.length; i++) {
            if (samples[i] != null) {
                samples[i].addTheta(-originalAngle);
            }
        }
    }
    /**
     * @return
     */
    public double getOriginalAngle() {
        return originalAngle;
    }

    /**
     * @return
     */
    public int getPos() {
        return pos;
    }

    /**
     * @return
     */
    public double getDistanceMe() {
        return distanceMe;
    }

    /**
     * @param d
     */
    public void setDistanceMe(double d) {
        distanceMe= d;
    }

    /**
     * @return
     */
    public double getItsRate() {
        return itsRate;
    }

    /* (non-Javadoc)
     * @see java.lang.Object#toString()
     */
    public String toString() {
        // TODO Auto-generated method stub
        return "PatternSample pos:"
            + this.getPos()
            + " rate:"
            + this.getItsRate();
    }

    /**
     * @return
     */
    public int getRound() {
        return round;
    }

    /**
     * @param i
     */
    public void setRound(int i) {
        round= i;
    }

    /**
     * @return
     */
    public char getHeadToMe() {
        // TODO Auto-generated method stub
        return (char)headToMe;
    }

    /**
     * @param d
     */
    public void setHeadToMe(double d) {
        headToMe= Math.abs(RoboMath.normalRelativeAngle(d));
    }

    /**
     * @param i
     */
    public void setAge(int i) {
        this.age= i;

    }

}
