/*
 * WaveManager.java
 *
 * Created on 15 maart 2004, 9:56
 */

package vic;
import java.util.ArrayList;
/**
 *
 * @author  Vic Stewart
 */
public class WaveManager extends EnemyCache
{
    ArrayList waves;
    
    WaveManager()
    {
        waves = new ArrayList();
    }
    
    void startWave(Situation situation, double Power, double meX, double meY)
    {
        Wave wave = new Wave(situation, Power, meX, meY, enemyX, enemyY, currentHeading);
        if(wave.hasReached(enemyX, enemyY))
        {
            processWave(wave);
        }
        else
        {
            waves.add(wave);
        }
    }

    double getRadius(int Index)
    {
       return ((Wave)waves.get(Index)).getRadius(); 
    }
    
    void update()
    {
        for(int i=0; i<waves.size(); i++)
        {
            ((Wave)waves.get(i)).update();
            if(((Wave)waves.get(i)).hasReached(enemyX, enemyY))
            {
                processWave(((Wave)waves.remove(i)));
                i--;
            }
        }
    }
    
    void clear()
    {
        while(waves.size()>0)
        {
            waves.remove(0);
        }
    }
    
    int countWaves()
    {
        return waves.size();
    }
    
    void processWave(Wave wave)      //override in Enemy class
    {
    }
}
