package ag.neuralgir;

/**
 * NeuralNetData Class. Used for the FileManager to read/write the 
 * net data.
 * @author agrosse
 *
 */
public class NeuralNetData implements java.io.Serializable {

	static final long serialVersionUID = 1002;
	
	private int[] mLayerSize;
	private double[][][] mWeights;
	private double mLearningRate;
	private double mLearningRateChange;
	private int mBatchSize;
	private double mMomentum;
	private int mNumTrainings;
	
	/**
	 * Constructor
	 * @param net neural net 
	 */
	public NeuralNetData(NeuralNet net) {
		mLayerSize = net.getLayerSize();

		mLearningRate = net.getLearningRate();
		mLearningRateChange = net.getLearningRateChange();
		mBatchSize = net.getBatchSize();
		mMomentum = net.getMomentum();
		mNumTrainings = net.getNumTrainings();
		/*
		double[][][] weights = net.getWeights()
		
		int c, h, i, k;
		c = 0;
		for(h = 0; h < mLayerSize.length-1; h++){			
			for(i = 0; i < mLayerSize[h]+1; i++)
				for(k = 0; k < mLayerSize[h + 1]; k++){
					mWeight[c] = weight[h][i][k];
					c++;
				}
		}	
		*/
		
		mWeights = net.getWeights();
	}
	
	/**
	 * Constructor
	 */
	public NeuralNetData(int[] layerSize, double learningrate, double changeLearning, int batchsize, double momentum) {
		mLayerSize = layerSize;

		mLearningRate = learningrate;
		mLearningRateChange = changeLearning;
		mBatchSize = batchsize;
		mMomentum = momentum;
		mNumTrainings = 0;
		mWeights = null;
	}

	/**
	 * Returns the weights
	 */
	public double[][][] getWeights(){
		return mWeights;
	}
	
	/**
	 * Returns the batch size
	 */
	public int getBatchSize() {
		return mBatchSize;
	}

	/**
	 * Returns the layer sizes
	 */
	public int[] getLayerSize() {
		return mLayerSize;
	}

	/**
	 * Returns the learning rate
	 */
	public double getLearningRate() {
		return mLearningRate;
	}

	/**
	 * Returns the learning rate modification
	 */
	public double getLearningRateChange() {
		return mLearningRateChange;
	}

	/**
	 * Returns the momentum
	 */
	public double getMomentum() {
		return mMomentum;
	}

	/**
	 * Returns the number of training cycles already completed
	 */
	public int getNumTrainings(){
		return mNumTrainings;
	}
}
