/*
 * Decompiled with CFR 0.152.
 */
package jaybot.guns;

import java.text.DecimalFormat;
import jaybot.guns.FiringSolution;
import jaybot.guns.Gun;
import jaybot.intel.RunningStatsBase;

public abstract class BaseGun
extends RunningStatsBase
implements Gun {
    protected static DecimalFormat dblfmt = new DecimalFormat();

    public String getGunName() {
        return this.getClass().getName();
    }

    public int hashCode() {
        return this.getGunName().hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof Gun) {
            Gun p = (Gun)o;
            return this.getGunName().equals(p.getGunName());
        }
        return false;
    }

    public String getStatsString() {
        String accuracyString = "?";
        if (this.getRunningShotsHit() + this.getRunningShotsMissed() > 0) {
            accuracyString = dblfmt.format(this.getRunningShotAccuracy()) + "%";
        }
        String gunStat = this.getGunName() + " (" + accuracyString + ") :: " + "fired=" + this.getRunningShotsFired() + ", hit=" + this.getRunningShotsHit() + ", miss=" + this.getRunningShotsMissed();
        return gunStat;
    }

    public void registerHit(FiringSolution solution) {
        this.incRunningShotsHit();
    }

    public void registerMiss(FiringSolution solution) {
        this.incRunningShotsMissed();
    }

    public void registerFiring(FiringSolution solution) {
        this.incRunningShotsFired();
    }

    static {
        dblfmt.setMaximumFractionDigits(2);
        dblfmt.setMinimumFractionDigits(2);
        dblfmt.setMinimumIntegerDigits(1);
    }
}

