/*
 * Decompiled with CFR 0.152.
 */
package jje;

import jje.BagPuss;
import jje.Coordinate;

public class Target {
    private Coordinate position;
    private double distance;
    private double velocity;
    private double heading;
    private double prevHeading;
    private double bearing;
    private double lastTimeScanned;
    private double angularVelocity;
    private String name = null;
    private boolean isAlive;
    public double power;
    private double energy;

    void reset() {
        this.isAlive = true;
        this.lastTimeScanned = -1.0;
        this.name = null;
    }

    void update(String targetName, Coordinate targetPos, double targetDist, double targetVelocity, double targetHeading, double targetBearing, double currentTime, double targetEnergy) {
        double dT = currentTime - this.lastTimeScanned;
        double dH = BagPuss.normalRelativeAngle(targetHeading - this.heading);
        this.angularVelocity = dT != 0.0 && dT < 4.0 ? dH / dT : 0.0;
        this.name = targetName;
        this.position = targetPos;
        this.distance = targetDist;
        this.velocity = targetVelocity;
        this.isAlive = true;
        this.prevHeading = this.heading;
        this.heading = targetHeading;
        this.bearing = targetBearing;
        this.lastTimeScanned = currentTime;
        this.energy = targetEnergy;
    }

    public Coordinate getEstimatedPosition(double currentTime) {
        if (Math.abs(Math.toRadians(this.angularVelocity)) <= Math.toRadians(0.1)) {
            Coordinate c = new Coordinate(this.position.x + this.velocity * (currentTime - this.lastTimeScanned) * Math.sin(Math.toRadians(this.heading)), this.position.y + this.velocity * (currentTime - this.lastTimeScanned) * Math.cos(Math.toRadians(this.heading)));
            c.linearIntercept = true;
            return c;
        }
        double angularVelRad = Math.toRadians(this.angularVelocity);
        double initialHeading = Math.toRadians(this.heading);
        double finalHeading = initialHeading + angularVelRad * (currentTime - this.lastTimeScanned);
        double radius = this.velocity / angularVelRad;
        double dX = radius * (Math.cos(initialHeading) - Math.cos(finalHeading));
        double dY = radius * (Math.sin(finalHeading) - Math.sin(initialHeading));
        Coordinate c = new Coordinate(this.position.x + dX, this.position.y + dY);
        c.linearIntercept = false;
        return c;
    }

    private Coordinate guessEstimatedPosition(double time) {
        return new Coordinate(this.position.x + this.velocity * time * Math.sin(Math.toRadians(this.heading)), this.position.y + this.velocity * time * Math.cos(Math.toRadians(this.heading)));
    }

    public final String getName() {
        return this.name;
    }

    public final Coordinate getPosition() {
        return this.position;
    }

    public final double getDistance() {
        return this.distance;
    }

    public final double getBearing() {
        return this.bearing;
    }

    public final double getAngularVelocity() {
        return this.angularVelocity;
    }

    public final double getEnergy() {
        return this.energy;
    }
}

