/*
 * Decompiled with CFR 0.152.
 */
package metal.shared;

import java.util.ArrayList;
import java.util.Collections;
import java.util.TreeMap;
import metal.shared.MAngle;
import metal.shared.MBotData;
import metal.shared.MBullet;
import metal.shared.MBulletEnemy;
import metal.shared.MMath;
import metal.shared.MPoint;
import metal.shared.MPolar;
import robocode.ScannedRobotEvent;

public class MEnemy
extends MPoint {
    public double bearing = 0.0;
    public double bearingAvg = 0.0;
    public double bearingDiff = 0.0;
    public double bearingRel = 0.0;
    public TreeMap bullets;
    public ArrayList dirHistory;
    public double distance = 0.0;
    public double distanceAvg = 0.0;
    public double energy = 0.0;
    public double energyDiff = 0.0;
    public double heading = 0.0;
    public double headingAvg = 0.0;
    public double headingDiff = 0.0;
    public boolean isFired = false;
    public boolean isLocked = false;
    MEnemy last = null;
    public ArrayList lenHistory;
    MPoint selfLoc;
    public double selfSpeed = 0.0;
    public double selfSpeedLast = 0.0;
    public double speed = 0.0;
    public double speedAdv = 0.0;
    public double speedAvg = 0.0;
    public double speedDiff = 0.0;
    public ArrayList speedHistory = new ArrayList();
    public double speedLast = 0.0;
    public double speedLat = 0.0;
    public double time = 0.0;
    public long timeFired = 0L;
    public long timeMax = 0L;
    public long timeMaxPeriod = 30L;
    public long timeZero = 0L;
    public long timeZeroPeriod = 30L;

    public MEnemy() {
        this.dirHistory = new ArrayList();
        this.lenHistory = new ArrayList();
        this.selfLoc = new MPoint(0.0, 0.0);
        this.bullets = new TreeMap();
        Collections.synchronizedMap(this.bullets);
        System.out.println("SYSTEM:  New Enemy ...");
    }

    public double getDirection() {
        return MMath.sign(this.speedLat);
    }

    public String getPatternDir() {
        String s = "";
        if (this.dirHistory.size() > 4) {
            int i = this.dirHistory.size() - 1;
            while (i > this.dirHistory.size() - 4) {
                s = s + (String)this.dirHistory.get(i);
                --i;
            }
        }
        return s;
    }

    public String getPatternLen() {
        String s = "";
        if (this.lenHistory.size() > 40) {
            int i = this.lenHistory.size() - 1;
            while (i > this.lenHistory.size() - 39) {
                s = s + (String)this.lenHistory.get(i);
                --i;
            }
        }
        return s;
    }

    public String getPatternSpeed() {
        String s = "";
        if (this.speedHistory.size() > 8) {
            int i = this.speedHistory.size() - 1;
            while (i > this.speedHistory.size() - 5) {
                s = s + (String)this.speedHistory.get(i);
                --i;
            }
        }
        return s;
    }

    public void init() {
        MBotData.print("SYSTEM:  Enemy      ... OK");
        this.bullets = new TreeMap();
    }

    public int isAccelarating() {
        return (int)Math.round(Math.abs(this.selfSpeed) - Math.abs(this.selfSpeedLast));
    }

    public void update(ScannedRobotEvent e) {
        if ((double)e.getTime() - this.time >= 1.0) {
            this.last = this;
            this.setLocation(MPolar.getPoint(MBotData.getLocation(), MAngle.absolute(MBotData.self.getHeading() + e.getBearing()), e.getDistance()));
            this.headingDiff = e.getHeading() - this.heading;
            this.speedDiff = this.speed - e.getVelocity();
            this.energyDiff = this.energy - e.getEnergy();
            if (this.energyDiff > 0.0 && this.energyDiff <= 3.0) {
                MBulletEnemy b = new MBulletEnemy(MBotData.enemy.last.last.selfLoc, MBotData.enemy.last, MBotData.enemy.last.time, MBullet.getSpeed(this.energyDiff), this.energyDiff);
                this.bullets.put(b.toString(), b);
                this.isFired = true;
                this.timeFired = e.getTime();
                this.selfSpeedLast = this.selfSpeed;
                this.selfSpeed = MBotData.self.getVelocity();
            }
            this.selfLoc = MBotData.getLocation();
            if (MMath.sign(this.speedLast) != MMath.sign(e.getVelocity())) {
                this.timeZeroPeriod = (long)MMath.rollingAvg(this.timeZeroPeriod, (double)e.getTime() - (double)this.timeZero, 4.0, 1.0);
                this.timeMaxPeriod = (long)MMath.rollingAvg(this.timeMaxPeriod, (double)e.getTime() - (double)this.timeMax, 4.0, 1.0);
                this.timeZero = e.getTime();
                this.timeMax = e.getTime();
                this.dirHistory.add(new String(" " + (int)this.getDirection()));
            }
            this.speedLast = this.speed;
            if (this.speedHistory.size() > 9) {
                this.speedHistory.remove(0);
            }
            if (this.dirHistory.size() > 5) {
                this.dirHistory.remove(0);
            }
            if (this.lenHistory.size() > 42) {
                this.lenHistory.remove(0);
            }
            this.speedHistory.add(new String(" " + (int)Math.rint(this.speedLat / 3.0)));
            if (this.last != null) {
                this.lenHistory.add(new String(" " + (int)Math.round(this.distance(this.last.last)) + 0.5));
            }
            this.bearingDiff = MAngle.relative(MAngle.absolute(this.last.selfLoc, this) - this.last.bearing);
            this.headingAvg = 0.0;
            this.bearingAvg = 0.0;
            this.distanceAvg = 0.0;
            this.isLocked = false;
        }
        this.bearingRel = e.getBearing();
        this.bearing = MBotData.self.getHeading() + this.bearingRel;
        this.heading = e.getHeading();
        this.distance = Math.abs(e.getDistance());
        this.x = MBotData.self.getX() + MMath.sin(this.bearing) * this.distance;
        this.y = MBotData.self.getY() + MMath.cos(this.bearing) * this.distance;
        this.time = e.getTime();
        this.speed = e.getVelocity();
        this.speedLat = MMath.sin(this.heading - this.bearing) * (this.speed == 0.0 ? this.speedAvg : this.speed) / this.distance;
        this.speedAdv = -MMath.cos(this.heading - this.bearing) * this.speed;
        this.energy = e.getEnergy();
        this.headingAvg = MMath.rollingAvg(this.headingAvg, this.heading, 4.0);
        this.bearingAvg = MMath.rollingAvg(this.bearingAvg, this.bearingDiff, 4.0, 1.0);
        this.distanceAvg = MMath.rollingAvg(this.distanceAvg, this.distance, 4.0, 1.0);
        this.speedAvg = MMath.rollingAvg(this.speedAvg, this.speed, 4.0);
        this.isLocked = true;
    }
}

