/*
 * Decompiled with CFR 0.152.
 */
package metal.shared;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import metal.shared.MBotData;
import metal.shared.MMath;

public class MPoint
extends Point2D.Double
implements Comparable {
    public MPoint(MPoint p) {
        super(p.x, p.y);
    }

    public MPoint(double x, double y) {
        super(x, y);
    }

    public MPoint() {
        super(0.0, 0.0);
    }

    public int compareTo(Object o) {
        return this.toString().compareTo(((MPoint)o).toString());
    }

    public double getDistanceAvg(double time, double speed) {
        speed = Math.min(8.0, Math.max(-8.0, speed + MBotData.enemy.speedDiff * 4.0));
        return speed * time;
    }

    public double getDistanceAvg(double time) {
        double speed = 0.0;
        speed = MBotData.enemy.speed == 0.0 && MBotData.enemy.energy != 0.0 ? MBotData.enemy.speedAvg : MBotData.enemy.speed;
        speed = Math.min(8.0, Math.max(-8.0, speed + MBotData.enemy.speedDiff * 4.0));
        return speed * time;
    }

    public MPoint getPoint(double angle, double speed, double time, double factor) {
        double dist = speed * time;
        double newX = this.x + MMath.sin(angle) * dist;
        double newY = this.y + MMath.cos(angle) * dist;
        return new MPoint(newX, newY);
    }

    public MPoint getPoint(double angle, double speed, double time) {
        double dist = speed * time;
        double newX = this.x + MMath.sin(angle) * dist;
        double newY = this.y + MMath.cos(angle) * dist;
        return new MPoint(newX, newY);
    }

    public static MPoint getPoint(MPoint origin, double angle, double distance) {
        double newX = origin.getX() + distance * MMath.sin(angle);
        double newY = origin.getY() + distance * MMath.cos(angle);
        return new MPoint(newX, newY);
    }

    public MPoint getPointAvg(double time, double factor) {
        double dist = this.getDistanceAvg(time);
        double newX = this.x + MMath.sin(MBotData.enemy.heading + MBotData.enemy.headingDiff * 4.0) * dist * factor;
        double newY = this.y + MMath.cos(MBotData.enemy.heading + MBotData.enemy.headingDiff * 4.0) * dist * factor;
        return MPoint.validate(new MPoint(newX, newY));
    }

    public double getSpeedAvg() {
        double speed = 0.0;
        speed = MBotData.enemy.speed == 0.0 && MBotData.enemy.energy != 0.0 ? MBotData.enemy.speedAvg : MBotData.enemy.speed;
        speed = Math.min(8.0, Math.max(-8.0, speed + MBotData.enemy.speedDiff * 4.0));
        return speed;
    }

    public static double getWallDistance(MPoint p) {
        return Math.min(Math.min(p.x, MBotData.self.getBattleFieldWidth() - p.x), Math.min(p.y, MBotData.self.getBattleFieldHeight() - p.y));
    }

    public static boolean isValid(MPoint p) {
        Rectangle2D.Double r = new Rectangle2D.Double(36.0, 36.0, MBotData.self.getBattleFieldWidth(), MBotData.self.getBattleFieldHeight());
        return r.contains(p);
    }

    public String toString() {
        return new String("Point(" + (int)this.x + ", " + (int)this.y + ")");
    }

    public static MPoint validate(MPoint p) {
        double x = MMath.clamp(MBotData.self.getBattleFieldWidth() - 20.0, 20.0, p.x);
        double y = MMath.clamp(MBotData.self.getBattleFieldHeight() - 20.0, 20.0, p.y);
        return new MPoint(x, y);
    }
}

