/*
 * Decompiled with CFR 0.152.
 */
package nosteel.Modules.Targeting;

import java.awt.Color;
import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import nosteel.Basics.Draw;
import nosteel.Basics.Vector;
import nosteel.Modules.Aiming;
import nosteel.Modules.Data.EnemyData;
import nosteel.Modules.Data.FiredBullet;
import nosteel.Modules.Data.ScanData;
import nosteel.Modules.DataList;
import nosteel.Modules.Targeting.Aim;
import nosteel.Modules.Targeting.localMinimum;
import nosteel.Modules.Targeting.matchResturn;
import robocode.util.Utils;

public class PatternMatch
extends Aim {
    public final int WINDOW_SIZE = 7;
    private Vector start;
    private double startHeading;
    List<Vector> window = new ArrayList<Vector>();
    private boolean isRightTurn;
    List<localMinimum> matches = new ArrayList<localMinimum>();
    private boolean finalSuccess;

    public PatternMatch(DataList scans_) {
        super(scans_);
    }

    @Override
    public void drawTargeting(Graphics2D g) {
        if (this.start == null) {
            return;
        }
        if (this.isRightTurn) {
            g.setColor(Color.RED);
        } else {
            g.setColor(Color.MAGENTA);
        }
        for (Vector v : this.window) {
            Draw.drawPoint(g, this.start.add(v), 8);
        }
        if (this.matches.isEmpty()) {
            return;
        }
        System.out.println(String.format("\nPrint Target", new Object[0]));
        boolean count = false;
        int iPointSize = 4;
        for (localMinimum match : this.matches) {
            if (!match.succeeded) continue;
            EnemyData e = this.scans.getEnemyData(this.getTargetName());
            ListIterator<ScanData> scanIt = e.getScanIterator(match.index);
            if (match.isRightTurn) {
                g.setColor(Color.RED);
            } else {
                g.setColor(Color.MAGENTA);
            }
            System.out.println(String.format("\nindex %d", match.index));
            Vector firstPoint = null;
            if (scanIt.hasPrevious()) {
                ScanData s = scanIt.previous();
                Draw.drawPoint(g, s.vHisPos, 8);
                if (firstPoint == null) {
                    firstPoint = s.vHisPos;
                }
            }
            if (!match.succeeded) continue;
            Draw.drawPoint(g, match.target, iPointSize);
        }
    }

    @Override
    public void printAimingData(long time) {
        super.printAimingData(time);
    }

    @Override
    public boolean processAiming(Vector myCurPos, double firePower, long time) {
        this.finalSuccess = false;
        this.firedData = null;
        this.setMyCurPos(myCurPos);
        this.setFirepower(firePower);
        this.determineWindow();
        this.determineMatchList();
        this.predictMovement();
        this.chooseFinalTarget();
        return this.finalSuccess;
    }

    private void determineWindow() {
        EnemyData e = this.scans.getEnemyData(this.getTargetName());
        if (e == null) {
            return;
        }
        ListIterator<ScanData> scanIt = e.getScanIterator(EnemyData.END_OF_LIST);
        if (!scanIt.hasPrevious()) {
            return;
        }
        ScanData s = scanIt.previous();
        this.start = s.vHisPos;
        this.startHeading = s.heading;
        Vector behind = null;
        Vector last = null;
        this.window.clear();
        while (scanIt.hasPrevious() && this.window.size() <= 7) {
            s = scanIt.previous();
            Vector diff = s.vHisPos.substract(this.start);
            this.window.add(diff);
            if (behind == null) {
                behind = s.vHisPos;
            }
            last = s.vHisPos;
        }
        this.isRightTurn = this.isRightTurn(this.start, behind, last);
    }

    private matchResturn matchedMSEAtIndex(int index) {
        double mse = 0.0;
        EnemyData e = this.scans.getEnemyData(this.getTargetName());
        if (e == null) {
            return null;
        }
        ListIterator<ScanData> scanIt = e.getScanIterator(index);
        if (scanIt == null) {
            return null;
        }
        if (!scanIt.hasPrevious()) {
            return null;
        }
        ScanData sIndex = scanIt.previous();
        ScanData s = null;
        Vector behind = null;
        Vector last = null;
        double angle = Utils.normalRelativeAngle((double)(sIndex.heading - this.startHeading));
        for (Vector v : this.window) {
            if (!scanIt.hasPrevious()) {
                return null;
            }
            Vector origPoint = this.start.add(v);
            s = scanIt.previous();
            Vector diff = s.vHisPos.substract(sIndex.vHisPos);
            Vector diffTurned = diff.turnByAngle(angle);
            Vector shiftedPoint = this.start.add(diffTurned);
            Vector match = origPoint.substract(shiftedPoint);
            mse += Math.pow(match.getLength(), 2.0);
            if (behind == null) {
                behind = s.vHisPos;
            }
            last = s.vHisPos;
        }
        matchResturn ret = new matchResturn();
        ret.mse = Math.sqrt(mse);
        ret.isRightTurn = this.isRightTurn(sIndex.vHisPos, behind, last);
        return ret;
    }

    private void determineMatchList() {
        EnemyData e = this.scans.getEnemyData(this.getTargetName());
        if (e == null) {
            return;
        }
        double mseCur = Double.MAX_VALUE;
        double mseOld = Double.MAX_VALUE;
        boolean detectNegative = false;
        this.matches.clear();
        System.out.println("\nMatch");
        int max = e.getNumOfScans();
        for (int i = 7; i < max; ++i) {
            matchResturn ret = this.matchedMSEAtIndex(i);
            if (ret == null) continue;
            mseCur = ret.mse;
            System.out.println(String.format("Match %d MSE %.3e is Right %b velo %.0f", i, mseCur, ret.isRightTurn, this.scans.getScan((String)this.getTargetName(), (int)i).velocity));
            if (mseCur < 1.0) {
                // empty if block
            }
            localMinimum mini = new localMinimum();
            mini.index = i;
            mini.mse = mseCur;
            mini.isRightTurn = ret.isRightTurn;
            this.matches.add(mini);
            detectNegative = false;
        }
        this.matches.sort(null);
    }

    private void predictMovement() {
        if (this.matches.isEmpty()) {
            return;
        }
        boolean targets = false;
        block0: for (localMinimum match : this.matches) {
            match.succeeded = false;
            match.target = null;
            if (match.mse > 1.0) continue;
            EnemyData e = this.scans.getEnemyData(this.getTargetName());
            ListIterator<ScanData> scanIt = e.getScanIterator(match.index);
            if (!scanIt.hasNext()) {
                return;
            }
            ScanData bestMatchPosition = scanIt.next();
            ScanData lastScan = e.getLastScan();
            double bestMatchAngle = bestMatchPosition.vHisMovement.getDirection();
            double lastScanAngle = lastScan.vHisMovement.getDirection();
            double angleCorr = Utils.normalRelativeAngle((double)(bestMatchAngle - lastScanAngle));
            boolean count = false;
            while (scanIt.hasNext()) {
                double enemyTime;
                ScanData s = scanIt.next();
                if (s == null) {
                    return;
                }
                Vector hisMove = s.vHisPos.substract(bestMatchPosition.vHisPos);
                match.target = lastScan.vHisPos.add(hisMove.turnByAngle(angleCorr));
                match.target.x = Math.max(18.0, match.target.x);
                match.target.x = Math.min(this.battleSize.x - 18.0, match.target.x);
                match.target.y = Math.max(18.0, match.target.y);
                match.target.y = Math.min(this.battleSize.y - 18.0, match.target.y);
                Vector bulletDist = match.target.substract(this.getMyCurPos());
                double bulletTime = bulletDist.getLength() / this.getBulletVelocity();
                if (!(bulletTime < (enemyTime = (double)(s.time - bestMatchPosition.time)))) continue;
                match.succeeded = true;
                continue block0;
            }
        }
    }

    private void chooseFinalTarget() {
        if (this.matches.isEmpty()) {
            return;
        }
        localMinimum mini = this.matches.get(0);
        if (mini.target == null) {
            return;
        }
        System.out.println(String.format("\nChoose Target %d", mini.index));
        Vector direction = mini.target.substract(this.getMyCurPos());
        this.firedData = new FiredBullet();
        this.firedData.targetDirection = direction.getDirection();
        this.firedData.aimingAlgo = Aiming.INDEX_PatterMatch;
        this.firedData.expectedPos = mini.target;
        this.firedData.targetName = this.getTargetName();
        this.finalSuccess = true;
    }

    public boolean isRightTurn(Vector firstPos, Vector behind, Vector last) {
        if (firstPos == null) {
            return false;
        }
        if (behind == null) {
            return false;
        }
        if (last == null) {
            return false;
        }
        double angelBehind = behind.substract(firstPos).getDirection();
        double angleLast = last.substract(firstPos).getDirection();
        double diff = Utils.normalRelativeAngle((double)(angleLast - angelBehind));
        boolean isRigth = diff < 0.0;
        return isRigth;
    }
}

