/*
 * Decompiled with CFR 0.152.
 */
package tcf;

import java.util.ArrayList;
import java.util.List;
import tcf.DataSegmenter;
import tcf.Debug;
import tcf.GfBase;
import tcf.Prediction;
import tcf.Seg;
import tcf.SimpleSeg;
import tcf.SimpleWeight;
import tcf.StaticStore;
import tcf.TestGf;
import tcf.WeightBase;

class CtGuessFactor
implements GfBase {
    public static final int L1_N = 7;
    public static final int L2_N = 21;
    boolean m_mainGun;
    List<DataSegmenter> m_segs = new ArrayList<DataSegmenter>();
    List<Prediction[]> m_p = new ArrayList<Prediction[]>();
    List<WeightBase[]> m_w = new ArrayList<WeightBase[]>();

    CtGuessFactor(String string, boolean bl) {
        this.createSegments();
        Debug.printf("CtGuessFactor(%s)\n", string);
        String string2 = bl ? "main" : "surfer";
        this.m_mainGun = bl;
        if (StaticStore.get(string + "." + string2 + ".p") != null) {
            this.m_p = (List)StaticStore.get(string + "." + string2 + ".p");
            this.m_w = (List)StaticStore.get(string + "." + string2 + ".w");
        } else {
            StaticStore.put(string + "." + string2 + ".p", this.m_p);
            StaticStore.put(string + "." + string2 + ".w", this.m_w);
            for (int i = 0; i < this.m_segs.size(); ++i) {
                int n = this.m_segs.get(i).size();
                Prediction[] predictionArray = new Prediction[n];
                WeightBase[] weightBaseArray = new WeightBase[n];
                for (int j = 0; j < n; ++j) {
                    predictionArray[j] = new Prediction();
                    weightBaseArray[j] = new SimpleWeight(1.0);
                }
                this.m_p.add(predictionArray);
                this.m_w.add(weightBaseArray);
            }
        }
    }

    private void createSegments() {
        Seg[] segArray = new Seg[]{new SimpleSeg(0.0, 8.0, 3), new SimpleSeg(50.0, 650.0, 3), new SimpleSeg(-1.5, 1.5, 3), new SimpleSeg(50.0, 350.0, 3), new SimpleSeg(0.0, 45.0, 3), new SimpleSeg(-4.0, 4.0, 3), new SimpleSeg(0.0, 450.0, 3)};
        Seg[] segArray2 = new Seg[]{new SimpleSeg(0.0, 8.0, 3), new SimpleSeg(50.0, 650.0, 3), new SimpleSeg(-1.5, 1.5, 3), new SimpleSeg(50.0, 350.0, 3), new SimpleSeg(0.0, 45.0, 3), new SimpleSeg(-4.0, 4.0, 3), new SimpleSeg(-400.0, 400.0, 4)};
        int n = 0;
        int n2 = segArray2.length - 2;
        int n3 = 1;
        int n4 = segArray2.length - 1;
        int n5 = 2;
        int n6 = segArray2.length;
        while (n < n2) {
            this.m_segs.add(new DataSegmenter(n, segArray2[n], n3, segArray2[n3], n5, segArray2[n5]));
            if (++n5 < n6) continue;
            if (++n3 >= n4) {
                n3 = ++n + 1;
            }
            n5 = n3 + 1;
        }
    }

    public int nSegments() {
        return this.m_segs.size();
    }

    public int calcIndex(double[] dArray, int n) {
        return this.m_segs.get(n).seg(dArray);
    }

    public int getPredSize(int n) {
        return this.m_p.get(n).length;
    }

    public Prediction getPrediction(int n, int n2) {
        return this.m_p.get(n)[n2];
    }

    public WeightBase getWeight(int n, int n2) {
        return this.m_w.get(n)[n2];
    }

    public void learn(double[] dArray, double d) {
        int n;
        int n2 = Prediction.gfToIndex(d);
        Prediction prediction = new Prediction();
        for (n = 0; n < 101; ++n) {
            double d2 = (double)(n2 - n) / 3.0;
            prediction.set(n, 1.0 / (1.0 + d2 * d2));
        }
        for (n = 0; n < this.m_segs.size(); ++n) {
            int n3 = this.calcIndex(dArray, n);
            Prediction prediction2 = this.m_p.get(n)[n3];
            this.m_w.get(n)[n3].learn(d, prediction2);
            if (this.m_mainGun) {
                prediction2.accumulate(prediction, 1.0);
                continue;
            }
            prediction2.roll(prediction, 3.0);
        }
    }

    public void predict(double[] dArray, Prediction prediction) {
        prediction.clear();
        for (int i = 0; i < this.m_segs.size(); ++i) {
            int n = this.calcIndex(dArray, i);
            Prediction prediction2 = this.m_p.get(i)[n];
            WeightBase weightBase = this.m_w.get(i)[n];
            double d = prediction2.totalValue();
            double d2 = (d == 0.0 ? 1.0 : 1.0 / d) * weightBase.getWeight();
            prediction.accumulate(prediction2, d2);
        }
    }

    public double[][] bestList(double[] dArray) {
        return null;
    }

    public double best(double[] dArray, double d, TestGf testGf) {
        Prediction prediction = new Prediction();
        this.predict(dArray, prediction);
        int n = 0;
        double[] dArray2 = new double[]{1.0};
        double d2 = 0.0;
        double d3 = 0.5;
        for (int i = 100; i >= 0; --i) {
            double d4 = Prediction.indexToGf(i);
            if (!testGf.test(d4)) continue;
            double d5 = 0.0;
            for (int j = -n; j <= n; ++j) {
                int n2 = i + j;
                if (n2 < 0 || n2 >= 101) continue;
                d5 += prediction.get(n2) * dArray2[n + j];
            }
            if (!(d2 < d5)) continue;
            d2 = d5;
            d3 = d4;
        }
        return d3;
    }
}

