/*
 * Decompiled with CFR 0.152.
 */
package inonit.script.runtime.io;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.LinkedList;

public class Streams {
    public void copy(InputStream in, OutputStream out, boolean closeInputStream) throws IOException {
        int i;
        in = new BufferedInputStream(in);
        out = new BufferedOutputStream(out);
        while ((i = in.read()) != -1) {
            out.write(i);
        }
        out.flush();
        if (closeInputStream) {
            in.close();
        }
    }

    public void copy(InputStream in, OutputStream out) throws IOException {
        this.copy(in, out, true);
    }

    public void copy(Reader in, Writer out) throws IOException {
        int i;
        in = new BufferedReader(in);
        out = new BufferedWriter(out);
        while ((i = in.read()) != -1) {
            out.write(i);
        }
        out.flush();
        in.close();
    }

    public OutputStream split(OutputStream one, OutputStream two) {
        return Bytes.Splitter.create(one, two);
    }

    public byte[] readBytes(InputStream in, boolean closeInputStream) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.copy(in, out, closeInputStream);
        return out.toByteArray();
    }

    public byte[] readBytes(InputStream in) throws IOException {
        return this.readBytes(in, true);
    }

    public String readString(Reader in) throws IOException {
        StringWriter writer = new StringWriter();
        this.copy(in, writer);
        return writer.toString();
    }

    public String readString(InputStream in) throws IOException {
        return this.readString(new InputStreamReader(in));
    }

    public void writeString(String string, OutputStream out) throws IOException {
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(out));
        writer.write(string);
        ((Writer)writer).flush();
    }

    public String readLine(Reader reader, String lineTerminator) throws IOException {
        int i;
        String rv = "";
        do {
            if ((i = reader.read()) == -1) continue;
            char c = (char)i;
            rv = rv + c;
        } while (i != -1 && !rv.endsWith(lineTerminator));
        return rv;
    }

    public static class Bytes {

        public static abstract class Flusher {
            public static final Flusher ALWAYS = new Flusher(){

                @Override
                public void initialize(OutputStream out) {
                }

                @Override
                public void writing(OutputStream out, byte[] bytes) {
                }

                @Override
                public void wrote(OutputStream out, byte[] bytes) throws IOException {
                    out.flush();
                }

                @Override
                public void flushing(OutputStream out) {
                }

                @Override
                public void flushed(OutputStream out) {
                }

                @Override
                public void closing(OutputStream out) {
                }

                @Override
                public void closed(OutputStream out) {
                }
            };

            public abstract void initialize(OutputStream var1);

            public abstract void writing(OutputStream var1, byte[] var2);

            public abstract void wrote(OutputStream var1, byte[] var2) throws IOException;

            public abstract void flushing(OutputStream var1);

            public abstract void flushed(OutputStream var1);

            public abstract void closing(OutputStream var1);

            public abstract void closed(OutputStream var1);

            public final OutputStream decorate(final OutputStream out) {
                this.initialize(out);
                return new OutputStream(){

                    @Override
                    public void write(int i) throws IOException {
                        out.write(i);
                        Flusher.this.wrote(out, new byte[]{(byte)i});
                    }

                    @Override
                    public void close() throws IOException {
                        Flusher.this.closing(out);
                        out.close();
                        Flusher.this.closed(out);
                    }

                    @Override
                    public void flush() throws IOException {
                        Flusher.this.flushing(out);
                        out.flush();
                        Flusher.this.flushed(out);
                    }

                    @Override
                    public void write(byte[] bytes, int off, int len) throws IOException {
                        byte[] portion = new byte[len];
                        for (int i = off; i < off + len; ++i) {
                            portion[i] = bytes[off + i];
                        }
                        Flusher.this.writing(out, portion);
                        out.write(bytes, off, len);
                        Flusher.this.wrote(out, portion);
                    }

                    @Override
                    public void write(byte[] bytes) throws IOException {
                        Flusher.this.writing(out, bytes);
                        out.write(bytes);
                        Flusher.this.wrote(out, bytes);
                    }
                };
            }
        }

        public static class Splitter
        extends OutputStream {
            private OutputStream a;
            private OutputStream b;

            public static Splitter create(OutputStream a, OutputStream b) {
                return new Splitter(a, b);
            }

            Splitter(OutputStream a, OutputStream b) {
                this.a = a;
                this.b = b;
            }

            @Override
            public void write(int i) throws IOException {
                this.a.write(i);
                this.b.write(i);
            }
        }

        public static class Buffer {
            private LinkedList<Byte> bytes = new LinkedList();
            private boolean closed;
            private MyInputStream in = new MyInputStream();
            private MyOutputStream out = new MyOutputStream();

            public String toString() {
                return super.toString() + " in=" + this.in + " out=" + this.out;
            }

            public InputStream getInputStream() {
                return this.in;
            }

            public OutputStream getOutputStream() {
                return this.out;
            }

            private synchronized int available() {
                return this.bytes.size();
            }

            private synchronized int read() {
                while (this.bytes.size() == 0 && !this.closed) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException(e);
                    }
                }
                if (this.bytes.size() == 0 && this.closed) {
                    return -1;
                }
                Byte bObject = this.bytes.removeFirst();
                int b = bObject.byteValue();
                if (b < 0) {
                    b += 256;
                }
                return b;
            }

            private synchronized int read(byte[] b, int off, int len) {
                int i = this.read();
                if (i == -1) {
                    return -1;
                }
                b[off] = (byte)i;
                return 1;
            }

            private synchronized void write(int i) {
                this.bytes.addLast(new Byte((byte)i));
                this.notifyAll();
            }

            private synchronized void close() {
                this.closed = true;
                this.notifyAll();
            }

            private class MyOutputStream
            extends OutputStream {
                private MyOutputStream() {
                }

                @Override
                public void write(int i) {
                    Buffer.this.write(i);
                }

                @Override
                public void close() {
                    Buffer.this.close();
                }
            }

            private class MyInputStream
            extends InputStream {
                private MyInputStream() {
                }

                @Override
                public int read() {
                    return Buffer.this.read();
                }

                @Override
                public int read(byte[] b, int off, int len) {
                    return Buffer.this.read(b, off, len);
                }

                @Override
                public int read(byte[] b) {
                    return this.read(b, 0, 1);
                }

                @Override
                public int available() {
                    return Buffer.this.available();
                }

                @Override
                public void close() {
                    Buffer.this.close();
                }
            }
        }
    }

    public static class Null {
        public static final InputStream INPUT_STREAM = new InputStream(){

            @Override
            public int read() {
                return -1;
            }
        };
        public static final Reader READER = new Reader(){

            @Override
            public void close() throws IOException {
            }

            @Override
            public int read(char[] c, int i, int i0) {
                return -1;
            }
        };
        public static final OutputStream OUTPUT_STREAM = new OutputStream(){

            @Override
            public void write(int i) {
            }
        };
        public static final Writer WRITER = new Writer(){

            @Override
            public void flush() {
            }

            @Override
            public void close() {
            }

            @Override
            public void write(char[] c, int i, int i0) {
            }
        };
    }
}

