/*
 * Decompiled with CFR 0.152.
 */
package amarok;

import amarok.AbstractStrategy;
import amarok.Arena;
import amarok.BotConstants;
import amarok.BotMath;
import amarok.Enemy;
import amarok.FireSolution;
import amarok.Strategy;
import robocode.AdvancedRobot;

public class FireSelected
extends AbstractStrategy
implements Strategy,
BotConstants {
    public double getGoodness() {
        return 0.5;
    }

    public void doOneTurn() {
        Enemy nme = this.arena.getEnemy();
        if (nme == null) {
            return;
        }
        AdvancedRobot me = this.arena.getMe();
        FireSolution fireSolution = this.arena.getFireSolution();
        if (fireSolution.isSolved() && fireSolution.getCalculatedFiringTime() > 0L) {
            me.setTurnGunRightRadians(fireSolution.getCalculatedGunHeading());
            long now = me.getTime();
            if (now >= fireSolution.getCalculatedFiringTime()) {
                me.fire(fireSolution.getCalculatedGunPower());
                fireSolution.setSolved(false);
                this.arena.setFired(true);
            }
        } else {
            double gunOffset = me.getGunHeadingRadians() - nme.getBearing();
            gunOffset = BotMath.optimizeOffset(gunOffset);
            me.setTurnGunLeftRadians(gunOffset);
        }
    }

    public FireSelected(Arena a) {
        super(a);
    }
}

