/*
 * Decompiled with CFR 0.152.
 */
package alk.lap.strategy.targetting;

import alk.lap.LoudAndProud;
import alk.lap.bothandling.WaveSurfer;
import alk.lap.strategy.FireWave;
import alk.lap.strategy.TacticalLead;
import alk.lap.strategy.targetting.TargetStrategy;
import alk.lap.utils.DVektor;
import alk.lap.utils.LapUtils;
import java.awt.Color;

public class MirrorEnemyTargeting
implements TargetStrategy {
    private static final double BEAM_ANGLE = 8.0;
    public static final String NAME = "AntiMirror";
    private double fireEnergy = 3.0;
    LoudAndProud proud;
    private String name = "AntiMirror";

    public String describe() {
        return this.name;
    }

    public TargetStrategy.StrategyType getType() {
        return TargetStrategy.StrategyType.MoveBased;
    }

    public double[] getFireAngleTo(int target, FireWave wave) {
        DVektor nextGunnerPosition;
        double angle = 0.0;
        if (target == 1) {
            throw new RuntimeException("Diese Strat ist nicht f\u00fcr Gegner anwendbar!");
        }
        if (!(this.proud.getDriver() instanceof WaveSurfer)) {
            return LapUtils.toDArray(this.proud.getRadarHeading());
        }
        WaveSurfer driver = (WaveSurfer)this.proud.getDriver();
        TacticalLead tLead = this.proud.getTacticLead();
        if (!tLead.isEnemySpotted()) {
            return LapUtils.toDArray(this.proud.getRadarHeading());
        }
        DVektor targetPosition = tLead.getEnemyPos().copy();
        DVektor gunnerPosition = this.proud.getPosition().copy();
        double bulletVel = 20.0 - 3.0 * this.fireEnergy;
        double bulletTravelTime = gunnerPosition.getDistanceTo(targetPosition) / bulletVel;
        long nextTargetSearchTurn = driver.getRemainingMoveTurns();
        if (nextTargetSearchTurn > 0L) {
            targetPosition.add(DVektor.sub(gunnerPosition, driver.getTarget()));
            this.proud.getVc().drawPoint(targetPosition.copy(), "RestTarget", Color.white);
        }
        if ((nextGunnerPosition = tLead.getNextTarget(nextTargetSearchTurn = (long)bulletTravelTime, driver.getTarget())) == null) {
            this.proud.getVc().drawPoint(targetPosition, "No-new Target at " + nextTargetSearchTurn);
        } else {
            DVektor mirrorMove = DVektor.sub(gunnerPosition, nextGunnerPosition);
            targetPosition.add(mirrorMove);
            this.proud.getVc().drawPoint(targetPosition, "Target to be reached at " + this.proud.timeToReach(nextGunnerPosition));
            nextTargetSearchTurn += this.proud.timeToReach(nextGunnerPosition);
        }
        angle = gunnerPosition.getDirectionTo(targetPosition);
        return LapUtils.toDArray(angle);
    }

    protected double getEnemyAccelerationRate(TacticalLead lead) {
        return lead.getEnemyAccRate();
    }

    protected double getEnemyTurnRate(TacticalLead lead) {
        return lead.getEnemyTurnRate();
    }

    protected double getVEnemy(TacticalLead lead) {
        return lead.getEnemyVelocitiy();
    }

    protected double getVProud(FireWave wave) {
        return wave.proudsVelocityAtEmission;
    }

    public double getFireEnergy() {
        return this.fireEnergy;
    }

    public double getBeamAngle() {
        return 8.0;
    }

    public MirrorEnemyTargeting setName(String name) {
        this.name = name;
        return this;
    }

    public MirrorEnemyTargeting setFireEnergy(double fireEnergy) {
        this.fireEnergy = fireEnergy;
        return this;
    }

    public Color getColorCode() {
        return Color.cyan;
    }

    public void newRound(LoudAndProud proud) {
        this.proud = proud;
    }

    public int signum(double d) {
        if (d == 0.0) {
            return 0;
        }
        if (d > 0.0) {
            return 1;
        }
        return -1;
    }
}

