/*
 * Decompiled with CFR 0.152.
 */
package josago;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Ellipse2D;
import java.util.ArrayList;
import java.util.HashMap;
import josago.GestorArmas;
import josago.GestorMovimiento;
import josago.GestorObjetivos;
import josago.InfoArmas;
import josago.InfoBala;
import josago.InfoRobot;
import josago.Utilidades;
import robocode.AdvancedRobot;
import robocode.Bullet;
import robocode.BulletHitBulletEvent;
import robocode.BulletMissedEvent;
import robocode.RobotDeathEvent;
import robocode.Rules;
import robocode.ScannedRobotEvent;
import robocode.util.Utils;

public class Jorgito
extends AdvancedRobot {
    private InfoRobot yo = new InfoRobot("Jorgito 0.16");
    private boolean voyMarchaAtras;
    private double MAPA_DIAGONAL;
    private static final double RADAR_FACTOR_BLOQUEO = 2.0;
    private static final double RADAR_UMBRAL_CALOR = 0.3;
    private static final int RADAR_POSICION_GIRO = 0;
    private static final int RADAR_POSICION_BLOQUEO = 1;
    private static final int RADAR_GIRO_HORARIO = 1;
    private static final int RADAR_GIRO_ANTIHORARIO = -1;
    private int radarPosicion;
    private int radarSentidoGiro;
    private GestorObjetivos gestorObjetivos = new GestorObjetivos();
    private String enemigoFijado = null;
    private HashMap enemigos = new HashMap();
    private HashMap balas_mias = new HashMap();
    private ArrayList<InfoBala> balas_enemigas = new ArrayList();
    private static final double ARMA_UMBRAL_ANGULO_TIRO = 0.04908738521234052;
    private static final int ARMAS_NUMERO = 5;
    private static final int ARMA_ANGULO_PATRONES = 0;
    private static final int ARMA_ANGULO_MCU = 1;
    private static final int ARMA_ANGULO_MRU = 2;
    private static final int ARMA_ANGULO_DIRECTO = 3;
    private static final int ARMA_ANGULO_ALEATORIO = 4;
    private InfoArmas infoArmas = new InfoArmas();

    private void inicializar() {
        this.MAPA_DIAGONAL = Math.sqrt(Math.pow(this.getBattleFieldWidth(), 2.0) + Math.pow(this.getBattleFieldHeight(), 2.0));
        this.radarPosicion = 0;
        this.radarSentidoGiro = 1;
        this.setAdjustRadarForGunTurn(true);
        this.setAdjustGunForRobotTurn(true);
        this.setColors(Color.black, Color.red, Color.orange);
    }

    private void actualizarDatosBalas() {
        InfoBala bala;
        Object[] array_balas = this.balas_mias.values().toArray();
        for (int i = 0; i < array_balas.length; ++i) {
            bala = (InfoBala)array_balas[i];
            String nombre_enemigo = bala.objetivo;
            InfoRobot enemigo = (InfoRobot)this.enemigos.get(nombre_enemigo);
            if (enemigo != null) {
                double x_enemigo = enemigo.datos[0].x;
                double y_enemigo = enemigo.datos[0].y;
                boolean[] aciertos = bala.angulosBuenos(x_enemigo, y_enemigo, this.getTime());
                if (aciertos == null) continue;
                this.balas_mias.remove(bala.bala);
                this.infoArmas.actualizarAciertos(nombre_enemigo, aciertos);
                continue;
            }
            this.balas_mias.remove(bala.bala);
        }
        for (int b = 0; b < this.balas_enemigas.size(); ++b) {
            bala = this.balas_enemigas.get(b);
            double distancia_recorrida = Rules.getBulletSpeed((double)bala.potencia) * (double)(this.getTime() - bala.t_lanzamiento + 1L);
            if (!(distancia_recorrida >= Utilidades.distancia(this.getX(), this.getY(), bala.x_lanzamiento, bala.y_lanzamiento))) continue;
            this.balas_enemigas.remove(b);
        }
    }

    private void eliminarRobotsMuertos() {
        if (this.getOthers() < this.enemigos.size() && this.getTime() > 100L) {
            this.enemigos.clear();
            this.gestorObjetivos.deseleccionarEnemigo();
            this.enemigoFijado = null;
            this.radarPosicion = 0;
        }
    }

    public void run() {
        this.inicializar();
        double[] punto_destino = null;
        while (true) {
            this.yo.actualizar(this.getX(), this.getY(), this.getHeadingRadians(), this.getEnergy(), this.getVelocity(), this.getTime());
            if (this.radarPosicion == 0) {
                this.setTurnRadarRightRadians(Double.POSITIVE_INFINITY * (double)this.radarSentidoGiro);
            }
            if (punto_destino == null || Utilidades.distancia((double)punto_destino[0], (double)punto_destino[1], this.getX(), this.getY()) < 16.0) {
                punto_destino = GestorMovimiento.movimientoMenorRiesgo(this.getX(), this.getY(), this.balas_enemigas, this.enemigos, this.getTime(), this.getBattleFieldWidth(), this.getBattleFieldHeight());
            }
            double direccion_movimiento = Math.atan2(punto_destino[0] - this.getX(), punto_destino[1] - this.getY());
            double angulo_a_girar = direccion_movimiento - this.getHeadingRadians();
            if (this.voyMarchaAtras) {
                angulo_a_girar -= Math.PI;
            }
            if (Math.abs(Utils.normalRelativeAngle((double)angulo_a_girar)) >= 1.5707963267948966) {
                boolean bl = this.voyMarchaAtras = !this.voyMarchaAtras;
            }
            if (this.voyMarchaAtras) {
                this.setBack(Double.POSITIVE_INFINITY);
            } else {
                this.setAhead(Double.POSITIVE_INFINITY);
            }
            angulo_a_girar = Utils.normalAbsoluteAngle((double)angulo_a_girar);
            if (angulo_a_girar < Math.PI * 2 - angulo_a_girar) {
                this.setTurnRightRadians(angulo_a_girar);
            } else {
                this.setTurnLeftRadians(Math.PI * 2 - angulo_a_girar);
            }
            this.actualizarDatosBalas();
            this.eliminarRobotsMuertos();
            this.execute();
        }
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        InfoRobot enemigo = (InfoRobot)this.enemigos.get(e.getName());
        if (enemigo == null) {
            enemigo = new InfoRobot(e.getName());
            this.enemigos.put(e.getName(), enemigo);
            this.infoArmas.nuevoEnemigo(e.getName());
        }
        double angulo_enemigo = Utils.normalRelativeAngle((double)(this.getHeadingRadians() + e.getBearingRadians()));
        double x_enemigo = this.getX() + e.getDistance() * Math.sin(angulo_enemigo);
        double y_enemigo = this.getY() + e.getDistance() * Math.cos(angulo_enemigo);
        enemigo.actualizar(x_enemigo, y_enemigo, e.getHeadingRadians(), e.getEnergy(), e.getVelocity(), this.getTime());
        if (enemigo.datosGuardados >= 2 && enemigo.datos[1].energia - enemigo.datos[0].energia <= 3.0 && enemigo.datos[1].energia - enemigo.datos[0].energia >= 0.1) {
            Double[] posibles_angulos;
            double diferencia_energia = enemigo.datos[1].energia - enemigo.datos[0].energia;
            posibles_angulos = new Double[]{Utils.normalRelativeAngle((double)(angulo_enemigo + Math.PI)), GestorArmas.anguloRectificacionMCU(diferencia_energia, e.getHeadingRadians(), x_enemigo, y_enemigo, this.yo, posibles_angulos[0] - e.getHeadingRadians(), this.getBattleFieldWidth(), this.getBattleFieldHeight())};
            if (posibles_angulos[1] == null) {
                posibles_angulos[1] = GestorArmas.anguloRectificacionMRU(diferencia_energia, e.getHeadingRadians(), x_enemigo, y_enemigo, this.yo, posibles_angulos[0] - e.getHeadingRadians(), this.getBattleFieldWidth(), this.getBattleFieldHeight());
            }
            Double[] doubleArray = posibles_angulos;
            Double.valueOf(doubleArray[1] + posibles_angulos[0]);
            this.balas_enemigas.add(new InfoBala(x_enemigo, y_enemigo, diferencia_energia, this.getTime(), posibles_angulos));
        }
        this.enemigoFijado = this.gestorObjetivos.seleccionarObjetivo(this.enemigos, this.getOthers(), this.getX(), this.getY(), this.MAPA_DIAGONAL, this.getTime());
        this.radarPosicion = this.getOthers() == 1 || e.getName().equals(this.enemigoFijado) && this.getGunHeat() <= 0.3 ? 1 : 0;
        if (e.getName().equals(this.enemigoFijado)) {
            double potencia_disparo = GestorArmas.potenciaDisparo(e, this.getEnergy(), this.MAPA_DIAGONAL);
            Double[] angulos_giro_armas = new Double[5];
            for (int a = 0; a < 5; ++a) {
                Double angulo_rectificacion = null;
                switch (a) {
                    case 3: {
                        angulo_rectificacion = 0.0;
                        break;
                    }
                    case 4: {
                        angulo_rectificacion = GestorArmas.anguloRectificacionAleatorio(potencia_disparo);
                        break;
                    }
                    case 2: {
                        angulo_rectificacion = GestorArmas.anguloRectificacionMRU(potencia_disparo, this.getHeadingRadians(), this.getX(), this.getY(), enemigo, e.getBearingRadians(), this.getBattleFieldWidth(), this.getBattleFieldHeight());
                        break;
                    }
                    case 1: {
                        angulo_rectificacion = GestorArmas.anguloRectificacionMCU(potencia_disparo, this.getHeadingRadians(), this.getX(), this.getY(), enemigo, e.getBearingRadians(), this.getBattleFieldWidth(), this.getBattleFieldHeight());
                        break;
                    }
                    case 0: {
                        angulo_rectificacion = GestorArmas.anguloRectificacionPatrones(e, potencia_disparo, this.getHeadingRadians(), this.getX(), this.getY(), enemigo, this.getBattleFieldWidth(), this.getBattleFieldHeight());
                    }
                }
                angulos_giro_armas[a] = angulo_rectificacion == null ? null : Double.valueOf(angulo_enemigo + angulo_rectificacion);
            }
            double[] porcentaje_aciertos = this.infoArmas.porcentajeAciertos(e.getName());
            double mejor_porcentaje = -1.0;
            int arma_a_utilizar = -1;
            for (int a = 0; a < 5; ++a) {
                if (!(porcentaje_aciertos[a] > mejor_porcentaje) || angulos_giro_armas[a] == null) continue;
                mejor_porcentaje = porcentaje_aciertos[a];
                arma_a_utilizar = a;
            }
            double angulo_a_girar_arma = Utils.normalRelativeAngle((double)(angulos_giro_armas[arma_a_utilizar] - this.getGunHeadingRadians()));
            this.setTurnGunRightRadians(Utils.normalRelativeAngle((double)angulo_a_girar_arma));
            if (this.radarPosicion == 1) {
                double angulo_a_girar_radar = Utils.normalRelativeAngle((double)(angulo_enemigo - this.getRadarHeadingRadians()));
                this.setTurnRadarRightRadians(2.0 * angulo_a_girar_radar + 0.01);
                this.radarSentidoGiro = angulo_a_girar_radar > 0.0 ? 1 : -1;
                if (this.getGunHeat() == 0.0 && Math.abs(angulo_a_girar_arma) < 0.04908738521234052) {
                    Bullet bala = this.setFireBullet(potencia_disparo);
                    this.balas_mias.put(bala, new InfoBala(bala, e.getName(), this.getX(), this.getY(), this.getTime(), angulos_giro_armas));
                    this.infoArmas.actualizarDisparos(e.getName(), angulos_giro_armas);
                }
            }
        }
    }

    public void onRobotDeath(RobotDeathEvent e) {
        this.enemigos.remove(e.getName());
        if (e.getName().equals(this.enemigoFijado)) {
            this.gestorObjetivos.deseleccionarEnemigo();
            this.enemigoFijado = null;
            this.radarPosicion = 0;
        }
    }

    public void onBulletMissed(BulletMissedEvent e) {
        this.balas_mias.remove(e.getBullet());
    }

    public void onBulletHitBullet(BulletHitBulletEvent e) {
        this.balas_mias.remove(e.getBullet());
    }

    public void onPaint(Graphics2D g) {
        Object[] array_balas;
        for (Object o : array_balas = this.balas_mias.values().toArray()) {
            InfoBala bala = (InfoBala)o;
            if (bala.bala == null) continue;
            double radio = Rules.getBulletSpeed((double)bala.potencia) * (double)(this.getTime() - bala.t_lanzamiento);
            Ellipse2D.Double circulo = new Ellipse2D.Double(bala.x_lanzamiento - radio, bala.y_lanzamiento - radio, radio * 2.0, radio * 2.0);
            g.setColor(new Color(255, 255, 255, 128));
            g.draw(circulo);
            for (int a = 0; a < 5; ++a) {
                Double angulo = bala.angulos_lanzamiento[a];
                if (angulo == null) continue;
                switch (a) {
                    case 3: {
                        g.setColor(new Color(255, 0, 0, 128));
                        break;
                    }
                    case 4: {
                        g.setColor(new Color(255, 255, 0, 128));
                        break;
                    }
                    case 2: {
                        g.setColor(new Color(0, 255, 0, 128));
                        break;
                    }
                    case 1: {
                        g.setColor(new Color(0, 0, 255, 128));
                        break;
                    }
                    case 0: {
                        g.setColor(new Color(255, 0, 255, 128));
                    }
                }
                g.drawLine((int)bala.x_lanzamiento, (int)bala.y_lanzamiento, (int)(bala.x_lanzamiento + radio * Math.sin(angulo)), (int)(bala.y_lanzamiento + radio * Math.cos(angulo)));
            }
        }
        for (int b = 0; b < this.balas_enemigas.size(); ++b) {
            InfoBala bala = this.balas_enemigas.get(b);
            for (int a = 0; a < bala.angulos_lanzamiento.length; ++a) {
                if (bala.angulos_lanzamiento[a] == null) continue;
                double x_bala = bala.x_lanzamiento + (double)(this.getTime() - bala.t_lanzamiento + 1L) * Rules.getBulletSpeed((double)bala.potencia) * Math.sin(bala.angulos_lanzamiento[a]);
                double y_bala = bala.y_lanzamiento + (double)(this.getTime() - bala.t_lanzamiento + 1L) * Rules.getBulletSpeed((double)bala.potencia) * Math.cos(bala.angulos_lanzamiento[a]);
                double distancia = Math.sqrt(Math.pow(x_bala - this.getX(), 2.0) + Math.pow(y_bala - this.getY(), 2.0));
                if (!(distancia <= this.MAPA_DIAGONAL)) continue;
                Ellipse2D.Double circulo = new Ellipse2D.Double(x_bala - 3.0, y_bala - 3.0, 6.0, 6.0);
                g.setColor(new Color(1.0f, (float)(distancia / this.MAPA_DIAGONAL), 0.0f, 0.9f));
                g.fill(circulo);
            }
        }
    }
}

