/*
 * Decompiled with CFR 0.152.
 */
package cb.util;

import cb.ml.Features;
import cb.util.BattleFieldUtils;
import cb.util.MovementState;
import java.awt.geom.Point2D;
import robocode.Bullet;
import robocode.Rules;
import robocode.util.Utils;

public class BulletWave {
    private double bulletAngle;
    private long time;
    private Point2D.Double source;
    private double myBulletPower;
    private double bulletVelocity;
    private double distance;
    private double opponentLateralVelocity;
    private double opponentAdvancingVelocity;
    private double opponentCurrentGuessFactor;
    private long opponentTimeSinceLastDeceleration;
    private double opponentForwardWall;
    private double opponentBackwardWall;
    private Point2D.Double target;
    private Point2D.Double minEscapePoint;
    private Point2D.Double maxEscapePoint;
    private int direction;

    public BulletWave(MovementState myState, MovementState opponentState, long otsld, double bulletPower, double cgf, BattleFieldUtils battleField) {
        this.time = myState.time;
        this.source = myState.location;
        this.target = opponentState.location;
        double absoluteBearing = BattleFieldUtils.absoluteBearing(myState.location, opponentState.location);
        double latVel = opponentState.velocity * Math.sin(opponentState.heading - absoluteBearing);
        this.direction = opponentState.velocity * Math.sin(opponentState.heading - absoluteBearing) > 0.0 ? 1 : -1;
        this.opponentLateralVelocity = latVel * (double)this.direction;
        this.opponentAdvancingVelocity = opponentState.velocity * Math.cos(opponentState.heading - absoluteBearing);
        this.myBulletPower = bulletPower;
        this.bulletVelocity = Rules.getBulletSpeed((double)this.myBulletPower);
        this.distance = myState.location.distance(opponentState.location);
        MovementState robotState = new MovementState(this.time, opponentState.location, opponentState.heading, opponentState.velocity);
        this.minEscapePoint = battleField.maximumEscapeAngle(-this.direction, robotState, myState.location, bulletPower);
        this.maxEscapePoint = battleField.maximumEscapeAngle(this.direction, robotState, myState.location, bulletPower);
        double minEscapeAngle = BattleFieldUtils.absoluteBearing(myState.location, this.minEscapePoint);
        double maxEscapeAngle = BattleFieldUtils.absoluteBearing(myState.location, this.maxEscapePoint);
        double mea = BattleFieldUtils.maximumEscapeAngle(bulletPower);
        this.opponentForwardWall = Math.abs(Utils.normalRelativeAngle((double)(absoluteBearing - maxEscapeAngle))) / mea;
        this.opponentBackwardWall = Math.abs(Utils.normalRelativeAngle((double)(absoluteBearing - minEscapeAngle))) / mea;
        this.opponentTimeSinceLastDeceleration = otsld;
        this.opponentCurrentGuessFactor = cgf;
    }

    public Point2D.Double getPoint(double guessFactor) {
        if (guessFactor < 0.0) {
            return BattleFieldUtils.between(this.target, this.minEscapePoint, -guessFactor);
        }
        return BattleFieldUtils.between(this.target, this.maxEscapePoint, guessFactor);
    }

    public double getGuessFactor(Point2D.Double point) {
        double absoluteBearing = BattleFieldUtils.absoluteBearing(this.source, this.target);
        double diff = Utils.normalRelativeAngle((double)(BattleFieldUtils.absoluteBearing(this.source, point) - absoluteBearing));
        double guessFactor = diff * (double)this.direction > 0.0 ? diff / Utils.normalRelativeAngle((double)(BattleFieldUtils.absoluteBearing(this.source, this.maxEscapePoint) - absoluteBearing)) : -diff / Utils.normalRelativeAngle((double)(BattleFieldUtils.absoluteBearing(this.source, this.minEscapePoint) - absoluteBearing));
        return BattleFieldUtils.limit(-1.0, guessFactor, 1.0);
    }

    public Features getFeatures() {
        Features features = new Features();
        features.setFeature("opponentLateralVelocity", this.opponentLateralVelocity);
        features.setFeature("opponentAdvancingVelocity", this.opponentAdvancingVelocity);
        features.setFeature("opponentCurrentGuessFactor", this.opponentCurrentGuessFactor);
        features.setFeature("opponentTimeSinceLastDeceleration", this.opponentTimeSinceLastDeceleration);
        features.setFeature("opponentForwardWall", this.opponentForwardWall);
        features.setFeature("opponentBackwardWall", this.opponentBackwardWall);
        features.setFeature("distance", this.distance);
        features.setFeature("myBulletPower", this.myBulletPower);
        return features;
    }

    public void setBullet(Bullet bullet) {
        this.bulletAngle = bullet.getHeadingRadians();
    }

    public Point2D.Double getLocation(long time) {
        return BattleFieldUtils.project(this.source, this.bulletAngle, (double)(time - this.time) * this.bulletVelocity);
    }

    public double getDiffUntilHit(Point2D.Double location, long time) {
        return this.source.distance(location) - (double)(time - this.time) * this.bulletVelocity;
    }

    public double getMyBulletPower() {
        return this.myBulletPower;
    }

    public long getTime() {
        return this.time;
    }
}

