/*
 * Decompiled with CFR 0.152.
 */
package ags.rougedc.movement;

import ags.muse.base.Rules;
import ags.rougedc.movement.RobotDriver;
import ags.rougedc.movement.WallSmoother;
import ags.rougedc.robots.VirtualRobot;
import ags.rougedc.waves.EnemyWave;
import ags.util.points.RelativePoint;
import java.util.List;
import robocode.util.Utils;

public class OrbitDriver
implements RobotDriver {
    private final Rules rules;
    private final double diroffset;
    private final double goaldistance;
    private double turn;
    private double acceleration;

    public OrbitDriver(Rules rules, double goaldistance, double diroffset) {
        this.rules = rules;
        this.diroffset = diroffset;
        this.goaldistance = goaldistance;
    }

    @Override
    public void run(VirtualRobot bot, List<EnemyWave> waves) {
        WallSmoother smoother = new WallSmoother(this.rules);
        if (waves.size() == 0) {
            this.turn = 0.0;
            this.acceleration = -bot.getVelocity().magnitude;
            return;
        }
        RelativePoint origin = RelativePoint.fromPP(bot.getLocation(), waves.get(0).getOrigin());
        double distancing_factor = 1.0;
        double direction = Utils.normalAbsoluteAngle((double)(origin.direction + (distancing_factor -= Math.min(Math.max((origin.magnitude - this.goaldistance) / 200.0, -0.5), 0.5)) * this.diroffset));
        direction = smoother.smoothAngle(bot.getLocation().x, bot.getLocation().y, direction, -((int)Math.signum(this.diroffset)));
        this.turn = Utils.normalRelativeAngle((double)(direction - bot.getVelocity().direction));
        if (Math.abs(this.turn) > 1.5707963267948966) {
            this.turn = Utils.normalRelativeAngle((double)(this.turn + Math.PI));
            this.acceleration = Double.NEGATIVE_INFINITY;
        } else {
            this.acceleration = Double.POSITIVE_INFINITY;
        }
    }

    @Override
    public double getAcceleration() {
        return this.acceleration;
    }

    @Override
    public double getAngularVelocity() {
        return this.turn;
    }
}

