/*
 * Decompiled with CFR 0.152.
 */
package cf.util;

import cf.target;
import cf.util.Calc;
import cf.util.PMData;
import java.awt.Point;
import java.io.PrintWriter;

public class PM {
    PMData[] saves;
    int nextIndex = 0;
    int lastTime = 0;
    int maxData;
    boolean full = false;
    Point e_pos;
    double e_head;
    int deep;
    double sollPower = -1.0;

    public PM(int maxData) {
        this.maxData = maxData;
        this.saves = new PMData[maxData + 1];
        this.deep = 10;
    }

    public void add(boolean data, int time, double speed, double angleChange) {
        int timeDiff = !data ? time - this.lastTime : time;
        this.saves[this.nextIndex] = new PMData(timeDiff, speed, angleChange);
        if (!data) {
            this.lastTime = time;
        }
        if (this.nextIndex < this.maxData) {
            ++this.nextIndex;
        } else {
            this.nextIndex = 0;
            this.full = true;
        }
    }

    public target getTarget(Point botPosition, int time, Point e_pos, double e_head, double sollPower) {
        this.sollPower = sollPower;
        target returnV = this.getTarget(botPosition, time, e_pos, e_head);
        this.sollPower = -1.0;
        return returnV;
    }

    public target getTarget(Point botPosition, int time, Point e_pos, double e_head) {
        this.e_pos = e_pos;
        this.e_head = e_head;
        int start1 = this.nextIndex - this.deep;
        int nearestStartIndex = 9;
        double minAbweichung = Double.POSITIVE_INFINITY;
        int i = 0;
        while (i < this.maxData && this.full || i < this.nextIndex - 2) {
            double thisAbweichung = this.abweichung(start1, i);
            if (thisAbweichung < minAbweichung) {
                minAbweichung = thisAbweichung;
                nearestStartIndex = i;
            }
            ++i;
        }
        target t = this.predictFuture(botPosition, time, nearestStartIndex);
        return t;
    }

    public double abweichung(int start1, int start2) {
        try {
            int startDiff = start1 - start2;
            if (startDiff < this.deep && startDiff > -this.deep) {
                return Double.POSITIVE_INFINITY;
            }
            double returnValue = 0.0;
            int i = 0;
            while (i < this.deep) {
                double einzelAbweichung = 0.0;
                int start1pos = start1 + i;
                int start2pos = start2 + i;
                if (start1pos > this.maxData) {
                    start1pos -= this.maxData;
                }
                if (start2pos > this.maxData) {
                    start2pos -= this.maxData;
                }
                if (start1pos < 0) {
                    start1pos += this.maxData;
                }
                if (start2pos < 0) {
                    start2pos += this.maxData;
                }
                double tA = Math.max(this.saves[start1pos].timeDiff, this.saves[start2pos].timeDiff) - Math.min(this.saves[start1pos].timeDiff, this.saves[start2pos].timeDiff);
                double sA = Math.max(this.saves[start1pos].speed, this.saves[start2pos].speed) - Math.min(this.saves[start1pos].speed, this.saves[start2pos].speed);
                double aCA = Math.max(this.saves[start1pos].angleChange, this.saves[start2pos].angleChange) - Math.min(this.saves[start1pos].angleChange, this.saves[start2pos].angleChange);
                einzelAbweichung = tA * 3.0 + sA * 2.0 + aCA * 2.0;
                returnValue += einzelAbweichung;
                ++i;
            }
            return returnValue;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            e.printStackTrace();
            return Double.POSITIVE_INFINITY;
        }
    }

    public target predictFuture(Point botPosition, int timeNow, int similarIndex) {
        Point prP = this.e_pos;
        double startDist = Calc.distPoints(botPosition, this.e_pos);
        if (startDist < 50.0) {
            return new target(this.e_pos.getX(), this.e_pos.getY(), 3.0, 0);
        }
        double power = this.sollPower < 0.0 ? 500.0 / startDist : this.sollPower;
        int travelTime = (int)Calc.travelTime(startDist, power);
        int hitTime = timeNow + travelTime;
        int simulationTime = timeNow;
        int i = similarIndex + this.deep;
        while (simulationTime <= hitTime - 1) {
            Point TEMPprP;
            if (i > this.maxData || this.saves[i] == null) {
                i = 0;
            }
            if (this.saves[i] == null) {
                return new target(this.e_pos.getX(), this.e_pos.getY(), 1.5, 0);
            }
            simulationTime += this.saves[i].timeDiff;
            double stepDist = this.saves[i].speed * (double)this.saves[i].timeDiff;
            this.e_head += this.saves[i].angleChange;
            double hoch = stepDist * Math.cos(Math.toRadians(this.e_head));
            double rechts = stepDist * Math.sin(Math.toRadians(this.e_head));
            prP = TEMPprP = new Point((int)(prP.getX() + rechts), (int)(prP.getY() + hoch));
            ++i;
        }
        double realBulletSpeed = Calc.dist(botPosition.x, botPosition.y, prP.getX(), prP.getY()) / (double)travelTime;
        double realPower = (realBulletSpeed - 20.0) / -3.0;
        target returnValue = new target(prP.getX(), prP.getY(), realPower, 7);
        return returnValue;
    }

    public PMData getPMData(int index) {
        return this.saves[index];
    }

    public void saveData(PrintWriter Printer) {
        int i = 0;
        while (i <= this.maxData && this.saves[i] != null) {
            Printer.println(this.saves[i].timeDiff + "/" + this.saves[i].speed + "/" + this.saves[i].angleChange);
            ++i;
        }
        System.out.println("--- DONE --- ");
    }
}

