/*
 * Decompiled with CFR 0.152.
 */
package pa3k;

import pa3k.BulletTracking;
import pa3k.Gun;
import pa3k.Log;
import pa3k.Opponent;
import pa3k.Position;
import pa3k.Tracking;
import robocode.AdvancedRobot;
import robocode.Robot;

public class BestAngleGun
extends Gun {
    protected double lastHitProbability;
    protected long targetReevaluate;

    public BestAngleGun(AdvancedRobot advancedRobot, Tracking tracking) {
        super(advancedRobot, tracking);
    }

    @Override
    public void init() {
        this.lastHitProbability = 0.0;
    }

    @Override
    public void turn() {
        int n;
        double d;
        double d2;
        Position position = new Position((Robot)this.robot);
        position.modify(1L, this.robot.getVelocity(), this.robot.getHeadingRadians());
        if (this.targetReevaluate <= 0L || this.target == null || this.target.lastSeen(this.robot.getTime()) > 3L) {
            this.targetReevaluate = 30L;
            Object[] objectArray = this.tracking.getTargets();
            double d3 = 0.0;
            for (int i = 0; i < objectArray.length; ++i) {
                Opponent opponent = (Opponent)objectArray[i];
                if (opponent.lastSeen(this.robot.getTime()) >= 3L) continue;
                BulletTracking bulletTracking = new BulletTracking(1.8, position, opponent, this.tracking, this.robot.getTime());
                d2 = bulletTracking.getRandomHitProbability();
                d = opponent.getSelfAiming().getHittingRatio();
                if (this.tracking.getLastHitBy() == opponent) {
                    d += 0.4;
                }
                Log.log(3, "Opponent " + opponent + ", r. hit prob. " + d2 + ", hit history " + d);
                if (!(d3 < d2 + d)) break;
                d3 = d2 + d;
                this.target = opponent;
                this.lastHitProbability = d2;
                break;
            }
            if (this.target != null) {
                this.tracking.setOpponentOfInterest(this.target);
                Log.log(2, "Targeting " + this.target + " random hit probability " + this.lastHitProbability);
            }
        }
        if (this.target != null && !this.target.isDead() && this.newBullet == null && this.target.getLastEnergy() >= 0.1 && (n = this.target.getScanPriority(this.robot.getTime())) != -1 && n < 2) {
            BulletTracking bulletTracking = new BulletTracking(1.8, position, this.target, this.tracking, this.robot.getTime());
            double d4 = bulletTracking.getRandomHitProbability();
            assert (d4 != Double.NaN);
            if (this.robot.getGunHeat() == 0.0 && (this.waiting == 0 || this.lastHitProbability > d4 || d4 > 0.4)) {
                double d5 = 2.0;
                if (d4 > 0.09) {
                    d5 = 2.5;
                }
                if (d4 > 0.15) {
                    d5 = 3.0;
                }
                if (d4 < 0.05) {
                    d5 = 1.0;
                }
                if ((this.robot.getEnergy() - 0.1) / 2.0 < d5) {
                    d5 = (this.robot.getEnergy() - 0.1) / 2.0;
                    if (d5 < 0.1) {
                        d5 = 0.1;
                    }
                    Log.log(3, "Saving energy, power decreased to " + d5);
                }
                if (d5 >= this.robot.getEnergy() - 0.1) {
                    d5 = this.robot.getEnergy() - 0.1;
                }
                if (d5 >= 0.1) {
                    d2 = 0.0;
                    if (position.distance(this.target.getLastPosition()) < 200.0) {
                        d2 = 0.05;
                    }
                    if ((d = (this.target.getLastEnergy() - d2) / 4.0) < d5 && (d5 = d) < 0.1) {
                        d5 = 0.1;
                    }
                    this.newBullet = bulletTracking = this.target.getSelfAiming().getBestAimingAngle(position, this.target, this.tracking, d5, this.robot.getTime());
                    this.waiting = 15;
                }
            } else if (this.waiting > 0) {
                --this.waiting;
            }
            this.lastHitProbability = d4;
        }
        --this.targetReevaluate;
        super.turn();
    }
}

