/*
 * Decompiled with CFR 0.152.
 */
package pa3k;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import pa3k.Log;
import pa3k.Opponent;
import robocode.Bullet;
import robocode.Robot;
import robocode.Rules;
import robocode.util.Utils;

public class Position
extends Point2D.Double {
    private static double BATTLEFIELD_WIDTH;
    private static double BATTLEFIELD_HEIGHT;
    private boolean wasWallCorrected = false;
    private static final long serialVersionUID = 5324881552676729162L;

    public static void setBattleField(Robot robot) {
        BATTLEFIELD_WIDTH = robot.getBattleFieldWidth();
        BATTLEFIELD_HEIGHT = robot.getBattleFieldHeight();
    }

    public static Position getCenter() {
        return new Position(BATTLEFIELD_WIDTH / 2.0, BATTLEFIELD_HEIGHT / 2.0);
    }

    public Position(Robot robot) {
        this.x = robot.getX();
        this.y = robot.getY();
    }

    public Position(Position position) {
        this.x = position.x;
        this.y = position.y;
    }

    public Position() {
        this.x = 0.0;
        this.y = 0.0;
    }

    public Position(double d, double d2) {
        super(d, d2);
    }

    public Position(Bullet bullet) {
        super(bullet.getX(), bullet.getY());
    }

    public double getDirectionTo(Position position) {
        double d = position.x - this.x;
        double d2 = position.y - this.y;
        if (d > -0.001 && d < 0.001) {
            return d2 > 0.0 ? 0.0 : Math.PI;
        }
        double d3 = Math.atan(d2 / d);
        if (d < 0.0) {
            d3 += Math.PI;
        }
        d3 -= 1.5707963267948966;
        return Utils.normalAbsoluteAngle((double)(d3 *= -1.0));
    }

    public Position computeEscapePosition(Position position, Position position2, double d, double d2, double d3, int n, double d4) {
        double d5;
        Position position3 = new Position(this);
        double d6 = position3.getDirectionTo(position);
        double d7 = Utils.normalAbsoluteAngle((double)(d6 + 1.5707963267948966));
        double d8 = Utils.normalAbsoluteAngle((double)(d6 - 1.5707963267948966));
        d6 = Math.abs(Utils.normalRelativeAngle((double)(d3 - d7))) < Math.abs(Utils.normalRelativeAngle((double)(d3 - d8))) ? d7 : d8;
        double d9 = Math.pow(d, 2.0);
        double d10 = position.distance(position2) / d - 1.0;
        double d11 = Math.pow(d10, 2.0);
        double d12 = d4;
        double d13 = Math.pow(d12, 2.0);
        double d14 = 0.0;
        double d15 = 0.0;
        if (n == 1) {
            d14 = (d12 - Math.abs(d2)) / 1.0;
            d15 = (d12 - Math.abs(d2)) / 2.0 * d14;
        } else {
            d14 = Math.abs(d2) / 2.0;
            d15 = -Math.abs(d2) / 2.0 * d14;
            d5 = d12 / 1.0;
            d14 += d5;
            d15 += d12 / 2.0 * d5;
        }
        d5 = Math.pow(d14, 2.0);
        double d16 = d9 - d13;
        double d17 = 2.0 * (d10 * d9 - d13 * d10 + d13 * d14 - d12 * d15);
        double d18 = -d11 * d13 + 2.0 * d13 * d10 * d14 - d5 * d13 - 2.0 * d10 * d12 * d15 + 2.0 * d14 * d12 * d15 - d15 * d15;
        double d19 = (-d17 + Math.sqrt(d17 * d17 - 4.0 * d16 * d18)) / (2.0 * d16);
        assert (d19 != Double.NaN);
        if (d2 >= 0.0) {
            position3.modify(1L, (double)n * ((d10 + d19 - d14) * d12 + d15), d6);
        } else {
            position3.modify(1L, (double)(-1 * n) * ((d10 + d19 - d14) * d12 + d15), d6);
        }
        position3.adjustForWalls(this, 1, position, d, d6);
        return position3;
    }

    public boolean adjustForWalls(Position position, int n, Position position2, double d, double d2) {
        int n2 = 18;
        double d3 = this.distance(position);
        assert (!Double.isNaN(d3));
        assert (d3 != 0.0);
        double d4 = position.getDirectionTo(this);
        assert (!Double.isNaN(d4));
        int n3 = 5;
        boolean bl = false;
        while (true) {
            double d5;
            double d6;
            double d7;
            double d8;
            double d9 = d8 = d4;
            int n4 = n;
            if (this.x < (double)n2 && d2 > Math.PI) {
                d9 = Math.acos((position.x - (double)n2) / d3);
                if (this.y < position.y) {
                    n4 *= -1;
                }
                d9 = 4.71238898038469 + (double)n4 * d9;
                assert (!Double.isNaN(d9));
                bl = true;
            } else if (this.x > BATTLEFIELD_WIDTH - (double)n2 && d2 < Math.PI) {
                d9 = Math.acos((BATTLEFIELD_WIDTH - (double)n2 - position.x) / d3);
                if (this.y > position.y) {
                    n4 *= -1;
                }
                d9 = 1.5707963267948966 + (double)n4 * d9;
                assert (!Double.isNaN(d9));
                bl = true;
            } else if (this.y > BATTLEFIELD_HEIGHT - (double)n2 && (d2 < 1.5707963267948966 || d2 > 4.71238898038469)) {
                d9 = Math.acos((BATTLEFIELD_HEIGHT - (double)n2 - position.y) / d3);
                if (this.x < position.x) {
                    n4 *= -1;
                }
                d9 = Utils.normalAbsoluteAngle((double)(Math.PI * 2 + (double)n4 * d9));
                assert (!Double.isNaN(d9));
                bl = true;
            } else if (this.y < (double)n2 && d2 > 1.5707963267948966 && d2 < 4.71238898038469) {
                d9 = Math.acos((position.y - (double)n2) / d3);
                if (this.x > position.x) {
                    n4 *= -1;
                }
                d9 = Math.PI + (double)n4 * d9;
                assert (!Double.isNaN(d9));
                bl = true;
            }
            if (!bl || n3 <= 0) break;
            Log.log(5, "Adjust for walls: (d = " + d3 + ", origHeading = " + d4 + ", prev = " + position + ", new = " + this + ", bounce = " + n + ")");
            this.wasWallCorrected = true;
            assert (!Double.isNaN(d9));
            --n3;
            Log.log(5, "correction = " + d9);
            double d10 = d9 - d8;
            Log.log(5, "Wall hit, new heading: " + (d8 += d10));
            Position position3 = new Position(position);
            position3.modify(1L, d3, d8);
            position3.correctForWalls();
            this.x = position3.x;
            this.y = position3.y;
            if (position2 == null || !((d7 = (d6 = this.distance(position2) / d) / (d5 = this.distance(position) / 8.0)) < 0.9) && !(d7 > 1.1)) break;
            Log.log(4, "Wall correction updating, r = " + d7);
            d3 -= (1.0 - d7) * d3 / 4.0;
            Position position4 = new Position(position);
            position4.modify(1L, d3, d4);
            this.x = position4.x;
            this.y = position4.y;
        }
        if (this.x == Double.NaN || this.y == Double.NaN) assert (false);
        return bl;
    }

    public Position computeEscapePosition(double d, double d2, Position position, double d3, int n, double d4, int n2) {
        double d5 = d;
        Position position2 = new Position(this);
        double d6 = position2.getDirectionTo(position);
        double d7 = Utils.normalAbsoluteAngle((double)(d6 + 1.5707963267948966));
        double d8 = Utils.normalAbsoluteAngle((double)(d6 - 1.5707963267948966));
        d6 = Math.abs(Utils.normalRelativeAngle((double)(d2 - d7))) < Math.abs(Utils.normalRelativeAngle((double)(d2 - d8))) ? d7 : d8;
        int n3 = 0;
        while ((double)n3 < position.distance(position2) / d3 + (double)n2) {
            double d9 = Utils.normalRelativeAngle((double)(d6 - d2));
            double d10 = Math.toRadians(10.0 - 0.75 * Math.abs(d));
            if (d9 > 0.0 && d9 > d10) {
                d9 = d10;
            } else if (d9 < 0.0 && d9 < -d10) {
                d9 = -d10;
            }
            d2 = Utils.normalAbsoluteAngle((double)(d2 + d9));
            d = n == 1 ? (d5 >= 0.0 ? (d += 1.0) : (d -= 1.0)) : (d5 >= 0.0 ? (d > 0.0 ? (d -= 2.0) : (d -= 1.0)) : (d < 0.0 ? (d += 2.0) : (d += 1.0)));
            if (d > d4) {
                d = d4;
            } else if (d < -d4) {
                d = -d4;
            }
            if (d != 0.0) {
                Position position3 = new Position(position2);
                position2.check();
                position2.modify(1L, d, d2);
                position2.adjustForWalls(position3, 1, null, 0.0, d < 0.0 ? Utils.normalAbsoluteAngle((double)(d2 + Math.PI)) : d2);
                position2.check();
            }
            Log.paintPoint(3, position2, n == 1 ? Color.RED : Color.BLACK);
            ++n3;
        }
        return position2;
    }

    public void modify(long l, double d, double d2) {
        this.x += (double)l * d * Math.sin(d2);
        this.y += (double)l * d * Math.cos(d2);
    }

    @Override
    public String toString() {
        return String.format("%.1f,%.1f", this.x, this.y);
    }

    public void drawCross(Graphics2D graphics2D, int n) {
        graphics2D.drawLine((int)this.x - n / 2, (int)this.y - n / 2, (int)this.x + n / 2, (int)this.y + n / 2);
        graphics2D.drawLine((int)this.x - n / 2, (int)this.y + n / 2, (int)this.x + n / 2, (int)this.y - n / 2);
    }

    public Position projectPosition(Position position, double d, double d2, double d3, double d4, double d5, int n) {
        Position position2 = new Position(this);
        double d6 = d2 - d3;
        double d7 = Utils.normalRelativeAngle((double)(d4 - d5));
        if (d6 > 2.0) {
            d6 = 2.0;
        }
        if (d6 < -2.0) {
            d6 = -2.0;
        }
        int n2 = 0;
        while (!(!((double)n2 < position.distance(position2) / d + (double)n) || d6 < -1.5 && (d2 += d6) < 0.0 || d6 > 1.5 && d2 > 0.0)) {
            if (d2 > 8.0) {
                d2 = 8.0;
            } else if (d2 < -8.0) {
                d2 = -8.0;
            }
            if (d2 > 0.1) {
                Position position3 = new Position(position2);
                position2.check();
                position2.modify(1L, d2, d4);
                if (position2.adjustForWalls(position3, 1, null, 0.0, d2 < 0.0 ? Utils.normalAbsoluteAngle((double)(d4 + Math.PI)) : d4)) {
                    position2.check();
                    break;
                }
            }
            Log.paintPoint(3, position2, Color.WHITE);
            double d8 = Math.abs(Rules.getTurnRateRadians((double)Math.abs(d2)));
            if (d7 > d8) {
                d7 = d8;
            }
            if (d7 < -d8) {
                d7 = -d8;
            }
            d4 = Utils.normalAbsoluteAngle((double)(d4 + d7));
            ++n2;
        }
        return position2;
    }

    public double projectAngle(long l, double d, double d2, Opponent opponent, int n, boolean bl) {
        double d3;
        double d4;
        double d5 = 0.0;
        assert (d2 >= 0.0);
        for (d4 = (double)l; n == 1 && d2 > 0.0 && d4 > 0.0; d2 -= 2.0, d4 -= 1.0) {
            d5 -= d2;
        }
        while (n == 0 && d2 > d && d4 > 0.0) {
            d5 += d2;
            d2 -= 2.0;
            d4 -= 1.0;
        }
        if (d2 < 0.0) {
            d2 = 0.0;
        }
        if (d4 > 0.0) {
            if (d2 == 0.0 && bl) {
                d3 = d4 * 1.0 * 2.0 / 3.0;
                if (d3 < d) {
                    d = d3;
                }
                double d6 = d / 1.0;
                d5 += d * d6 / 2.0;
                d4 -= d6;
                d6 = d / 2.0;
                d5 += d * d6 / 2.0;
                d4 -= d6;
            } else if (d2 == 0.0 && !bl) {
                while (d2 < d && d4 > 0.0) {
                    d5 += d2;
                    d2 += 1.0;
                    d4 -= 1.0;
                }
            } else if (bl) {
                while (d2 > 0.0 && d4 > 0.0) {
                    d5 += d2;
                    d2 -= 2.0;
                    d4 -= 1.0;
                }
            }
            d5 += d * d4;
        }
        d3 = Math.asin(1.0 / this.distance(opponent.getLastPosition()));
        return d5 * d3 * (double)(n == 1 ? -1 : 1);
    }

    public Position getAverage(Position position) {
        return new Position((this.x + position.x) / 2.0, (this.y + position.y) / 2.0);
    }

    public boolean inCorner(int n) {
        if (this.x < (double)n && this.y < (double)n) {
            return true;
        }
        if (this.x < (double)n && this.y > BATTLEFIELD_HEIGHT - (double)n) {
            return true;
        }
        if (this.x > BATTLEFIELD_WIDTH - (double)n && this.y < (double)n) {
            return true;
        }
        return this.x > BATTLEFIELD_WIDTH - (double)n && this.y > BATTLEFIELD_HEIGHT - (double)n;
    }

    public void check() {
        assert (!Double.isNaN(this.x));
        assert (!Double.isNaN(this.y));
        assert (this.x >= 18.0 && this.y >= 18.0 && this.x <= BATTLEFIELD_WIDTH - 18.0 && this.y <= BATTLEFIELD_HEIGHT - 18.0);
    }

    public void correctForWalls() {
        double d = 18.0005;
        if (this.x < d) {
            this.x = d;
        }
        if (this.y < d) {
            this.y = d;
        }
        if (this.x > BATTLEFIELD_WIDTH - d) {
            this.x = BATTLEFIELD_WIDTH - d;
        }
        if (this.y > BATTLEFIELD_HEIGHT - d) {
            this.y = BATTLEFIELD_HEIGHT - d;
        }
    }

    protected static Position[] kNeighbors(Position[] positionArray, Position[] positionArray2, int n, int n2) {
        int n3;
        Position[] positionArray3 = positionArray;
        int[] nArray = new int[n2];
        for (n3 = 0; n3 < n2; ++n3) {
            nArray[n3] = 1;
        }
        for (n3 = n; n3 < positionArray2.length; ++n3) {
            double d = 1.0E7;
            int n4 = 0;
            for (int i = 0; i < n2; ++i) {
                double d2 = positionArray3[i].distance(positionArray2[n3]);
                if (!(d2 < d)) continue;
                d = d2;
                n4 = i;
            }
            positionArray3[n4].x = (positionArray3[n4].x * (double)nArray[n4] + positionArray2[n3].x) / (double)(nArray[n4] + 1);
            positionArray3[n4].y = (positionArray3[n4].y * (double)nArray[n4] + positionArray2[n3].y) / (double)(nArray[n4] + 1);
            int n5 = n4;
            nArray[n5] = nArray[n5] + 1;
        }
        int n6 = 0;
        for (int i = 1; i < n2; ++i) {
            if (nArray[i] <= nArray[n6]) continue;
            n6 = i;
        }
        Position position = positionArray3[n6];
        positionArray3[n6] = positionArray3[0];
        positionArray3[0] = position;
        return positionArray3;
    }

    public static Position[] kNeighbors(Position[] positionArray, int n) {
        Position[] positionArray2 = new Position[n];
        for (int i = 0; i < n; ++i) {
            positionArray2[i] = new Position(positionArray[i]);
        }
        Position[] positionArray3 = Position.kNeighbors(positionArray2, positionArray, n, n);
        Position[] positionArray4 = Position.kNeighbors(positionArray3, positionArray, 0, n);
        for (int i = 0; i < n; ++i) {
            Log.paintFilledCircle(3, positionArray4[i], 9, new Color(100, 100, 255, 100), 2);
        }
        return positionArray4;
    }

    public boolean isWallCorrected() {
        return this.wasWallCorrected;
    }

    public boolean isInBattlefield() {
        int n = 18;
        if (this.x > BATTLEFIELD_WIDTH - (double)n) {
            return false;
        }
        if (this.x < (double)n) {
            return false;
        }
        if (this.y > BATTLEFIELD_HEIGHT - (double)n) {
            return false;
        }
        return !(this.y < (double)n);
    }

    public double getWallDistance() {
        double d;
        double d2 = BATTLEFIELD_WIDTH - this.x;
        if (this.x < d2) {
            d2 = this.x;
        }
        if (this.y < (d = BATTLEFIELD_HEIGHT - this.y)) {
            d = this.y;
        }
        return d2 < d ? d2 : d;
    }

    public double getNormalizedWallDistance() {
        return this.getWallDistance() / BATTLEFIELD_HEIGHT;
    }

    public double getCornerDistance() {
        if (this.x < BATTLEFIELD_WIDTH / 2.0) {
            if (this.y < BATTLEFIELD_HEIGHT / 2.0) {
                return this.distance(0.0, 0.0);
            }
            return this.distance(0.0, BATTLEFIELD_HEIGHT);
        }
        if (this.y < BATTLEFIELD_HEIGHT / 2.0) {
            return this.distance(BATTLEFIELD_WIDTH, 0.0);
        }
        return this.distance(BATTLEFIELD_WIDTH, BATTLEFIELD_HEIGHT);
    }

    public double getNormalizedCornerDistance() {
        return this.getWallDistance() / BATTLEFIELD_WIDTH;
    }

    public void projectPosition(double d, double d2, double d3, double d4, int n) {
    }
}

