/*
 * Decompiled with CFR 0.152.
 */
package pa3k;

import pa3k.AngleUtils;
import pa3k.Change;
import pa3k.Opponent;
import pa3k.Position;
import pa3k.SelfTracking;
import pa3k.State;
import robocode.AdvancedRobot;
import robocode.Robot;
import robocode.util.Utils;

class StateCircling
extends State {
    public StateCircling(int n) {
        super(n);
    }

    @Override
    public double advancePosition(Position position, double d, double d2, int n) {
        super.advancePosition(position, d, d2, n);
        return Utils.normalAbsoluteAngle((double)(d + AngleUtils.difference(d, d2)));
    }

    @Override
    public Change amIStillHere(AdvancedRobot advancedRobot, SelfTracking selfTracking, Opponent opponent, long l, State[] stateArray, boolean bl, long l2, boolean bl2, long l3, long l4, double d) throws Exception {
        Position position = new Position((Robot)advancedRobot);
        Position position2 = opponent.getLastPosition();
        double d2 = position2.getDirectionTo(position);
        d2 = Utils.normalAbsoluteAngle((double)(d2 + 1.5707963267948966));
        double d3 = opponent.getLastHeading(l) % Math.PI;
        double d4 = Math.abs(AngleUtils.difference(d2 %= Math.PI, d3));
        int n = (int)Math.abs(Math.round(opponent.getLastVelocity(l)));
        if (n == this.speed && (d4 < 0.2 || this.speed == 0)) {
            return null;
        }
        Change change = null;
        change = n == 0 ? new Change(stateArray[0]) : (d4 < 0.2 ? new Change(stateArray[n]) : new Change(stateArray[8 + n]));
        change.setValues(advancedRobot, opponent, l, selfTracking);
        return this.checkChanges(change, l2, bl2, l3, l4, d);
    }

    public String toString() {
        return "StateCircling(" + this.speed + ")";
    }
}

