/*
 * Decompiled with CFR 0.152.
 */
package pa3k;

import java.awt.Color;
import java.util.Iterator;
import pa3k.Aiming;
import pa3k.AngleUtils;
import pa3k.BulletTracking;
import pa3k.Log;
import pa3k.Opponent;
import pa3k.Position;
import pa3k.Tracking;
import robocode.AdvancedRobot;

public class TronAiming
extends Aiming {
    protected int segmentationType;
    public static final int SEGMENTATION_NONE = 0;
    public static final int SEGMENTATION_WALL_DISTANCE = 1;
    public static final int SEGMENTATION_MIDANGLE = 2;
    public static final int SEGMENTATION_VELOCITY = 3;

    public TronAiming(AdvancedRobot advancedRobot, String string, boolean bl) {
        super(advancedRobot, string, bl);
        this.segmentationType = 2;
    }

    public TronAiming(AdvancedRobot advancedRobot, String string, boolean bl, int n) {
        super(advancedRobot, string, bl);
        this.segmentationType = n;
    }

    @Override
    public void dumpStats() {
        super.dumpStats();
    }

    private void paintBins(double[] dArray, double[] dArray2, Position position, double d, double d2, double d3, double d4, Color color) {
        int n;
        int n2;
        double d5 = (double)dArray2.length / (double)dArray.length;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        for (n2 = 0; n2 < dArray.length; ++n2) {
            if (dArray[n2] > dArray[n3]) {
                n3 = n2;
            }
            if (!(dArray[n2] < dArray[n4])) continue;
            n4 = n2;
        }
        for (n2 = 0; n2 < dArray2.length; ++n2) {
            if (dArray2[n2] > dArray2[n5]) {
                n5 = n2;
            }
            if (!(dArray2[n2] < dArray2[n6])) continue;
            n6 = n2;
        }
        double d6 = dArray2[n6] * d5 < dArray[n4] ? dArray2[n6] * d5 : dArray[n4];
        double d7 = dArray2[n5] * d5 > dArray[n3] ? dArray2[n5] * d5 : dArray[n3];
        double d8 = dArray2[dArray2.length - 1] * d5 + dArray[0];
        d7 = d7 > d8 ? d7 : d8;
        d6 = d6 < d8 ? d6 : d8;
        for (n = 0; n < dArray2.length - 1; ++n) {
            Log.paintArc(3, position, d2 - d3 * (double)(dArray2.length - 1 - n) - d3 / 2.0, d3, d4, new Color(color.getRed(), color.getGreen(), color.getBlue(), 20 + (int)(100.0 * ((dArray2[n] * d5 - d6) / (d7 - d6)))), 0);
            Log.paintLine(3, position, d2 - d3 * (double)(dArray2.length - 1 - n) - d3 / 2.0, new Color(color.getRed(), color.getGreen(), color.getBlue(), 100), 0);
        }
        for (n = 1; n < dArray.length; ++n) {
            Log.paintArc(3, position, d2 + d3 * (double)n - d3 / 2.0, d3, d4, new Color(color.getRed(), color.getGreen(), color.getBlue(), 20 + (int)(100.0 * ((dArray[n] - d6) / (d7 - d6)))), 0);
            Log.paintLine(3, position, d2 + d3 * (double)n - d3 / 2.0, new Color(color.getRed(), color.getGreen(), color.getBlue(), 100), 0);
        }
        Log.paintLine(3, position, d, color, 0);
        Log.paintLine(3, position, d2, color, 0);
    }

    @Override
    public BulletTracking getBestAimingAngle(Position position, Opponent opponent, Tracking tracking, double d, long l) {
        int n;
        BulletTracking bulletTracking = super.getBestAimingAngle(position, opponent, tracking, d, l);
        Log.log(4, "neg " + bulletTracking.getNegativeAngle() + ", mid " + bulletTracking.getMiddleAngle() + ", pos " + bulletTracking.getPositiveAngle() + ", step " + bulletTracking.getAngleAdvance() + (bulletTracking.isTowardWall() ? ", towards wall" : ""));
        double d2 = 1.5;
        double d3 = 1.0;
        double[] dArray = this.getPositiveBins(bulletTracking, 0.6, 1.0, 0.0, 0.1, d2, d3, 10000);
        double[] dArray2 = this.getNegativeBins(bulletTracking, 0.6, 1.0, 0.0, 0.1, d2, d3, 10000);
        double d4 = (double)dArray2.length / (double)dArray.length;
        dArray[0] = dArray[0] + dArray2[dArray2.length - 1] * d4;
        int n2 = 0;
        int n3 = dArray2.length - 1;
        for (n = 0; n < dArray.length; ++n) {
            if (!(dArray[n] > dArray[n2])) continue;
            n2 = n;
        }
        for (n = 0; n < dArray2.length - 1; ++n) {
            if (!(dArray2[n] > dArray2[n3])) continue;
            n3 = n;
        }
        double d5 = 0.0;
        d5 = dArray2[n3] * d4 > dArray[n2] ? bulletTracking.middleAngle - bulletTracking.getAngleAdvance() * (double)(dArray2.length - 1 - n3) : bulletTracking.middleAngle + bulletTracking.getAngleAdvance() * (double)n2;
        bulletTracking.setFiringAngle(d5);
        this.paintBins(dArray, dArray2, position, bulletTracking.getNegativeAngle(), bulletTracking.getMiddleAngle(), bulletTracking.getAngleAdvance(), bulletTracking.getSource().distance(bulletTracking.getTarget()), Color.WHITE);
        Log.paintLine(3, position, d5, Color.RED, 0);
        return bulletTracking;
    }

    @Override
    public double[] getEscapeBins(BulletTracking bulletTracking) {
        int n;
        double d = 1.0;
        double d2 = 1.0;
        double[] dArray = this.getPositiveBins(bulletTracking, 1.0, 0.7, 0.0, d, 2.0, d2, 10000);
        double[] dArray2 = this.getNegativeBins(bulletTracking, 1.0, 0.7, 0.0, d, 2.0, d2, 10000);
        int n2 = dArray.length + dArray2.length - 1;
        double[] dArray3 = new double[n2];
        this.paintBins(dArray, dArray2, bulletTracking.getSource(), bulletTracking.getNegativeAngle(), bulletTracking.getMiddleAngle(), bulletTracking.getAngleAdvance(), bulletTracking.getSource().distance(bulletTracking.getTarget()), Color.RED);
        double d3 = (double)dArray2.length / (double)dArray.length;
        for (n = 0; n < dArray2.length - 1; ++n) {
            dArray3[n] = dArray2[n] * d3;
        }
        for (n = dArray2.length - 1; n < dArray2.length + dArray.length - 1; ++n) {
            dArray3[n] = dArray[n - (dArray2.length - 1)];
        }
        int n3 = dArray2.length - 1;
        dArray3[n3] = dArray3[n3] + dArray2[dArray2.length - 1] * d3;
        if (dArray2.length > 1) {
            int n4 = dArray2.length - 2;
            dArray3[n4] = dArray3[n4] + dArray3[dArray2.length - 1] * d;
        }
        if (dArray.length > 1) {
            int n5 = dArray2.length;
            dArray3[n5] = dArray3[n5] + dArray3[dArray2.length - 1] * d;
        }
        return dArray3;
    }

    private void fillBin(BulletTracking bulletTracking, BulletTracking bulletTracking2, double[] dArray, boolean bl, double d, double d2, double d3) {
        if (bulletTracking.getFiringAngle() == 0.0) {
            return;
        }
        double d4 = bulletTracking.getAimingRatio();
        if (d4 < 0.0 || d4 > 1.0) {
            Log.log(1, "fffffff3:" + bulletTracking);
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
        if (d4 >= 0.5 && bl) {
            d4 -= 0.5;
            d4 *= 2.0;
        } else if (d4 < 0.5 && !bl) {
            d4 *= 2.0;
        } else {
            return;
        }
        int n = (int)(d4 * (double)(dArray.length - 1) + 0.5);
        if (n >= dArray.length) {
            n = dArray.length - 1;
        }
        double[] dArray2 = null;
        switch (this.segmentationType) {
            case 1: {
                dArray2 = new double[]{(bulletTracking2.getTatgetDistanceFromWall() - bulletTracking.getTatgetDistanceFromWall()) * 8.0, (bulletTracking2.getSourceDistanceFromWall() - bulletTracking.getSourceDistanceFromWall()) * 5.0, (bulletTracking2.getDistance() - bulletTracking.getDistance()) / 300.0, (bulletTracking2.getEnergy() - bulletTracking.getEnergy()) * 5.0};
                break;
            }
            case 3: {
                dArray2 = new double[]{(bulletTracking2.getTargetVelocity() - bulletTracking.getTargetVelocity()) / 2.0, (bulletTracking2.getMidAngleRatio() - bulletTracking.getMidAngleRatio()) * 3.0, bulletTracking2.getAcceleration() - bulletTracking.getAcceleration()};
                break;
            }
            case 2: {
                dArray2 = new double[]{(bulletTracking2.getMidAngleRatio() - bulletTracking.getMidAngleRatio()) / 1.0 * 5.0, (bulletTracking2.getRelativeHeading() - bulletTracking.getRelativeHeading()) / (Math.PI * 2) * 4.0, (bulletTracking2.getAcceleration() - bulletTracking.getAcceleration() + 2.0) / 3.0 * 4.0, (bulletTracking2.getDistance() - bulletTracking.getDistance()) / 600.0 * 3.0};
                break;
            }
            default: {
                dArray2 = new double[]{};
            }
        }
        double d5 = d;
        for (double d6 : dArray2) {
            d5 *= Math.exp(-Math.abs(d6 / d3));
        }
        int n2 = n;
        dArray[n2] = dArray[n2] + d5;
        double d7 = d5 * d2;
        if (n > 0) {
            int n3 = n - 1;
            dArray[n3] = dArray[n3] + d7;
        }
        if (n < dArray.length - 1) {
            int n4 = n + 1;
            dArray[n4] = dArray[n4] + d7;
        }
    }

    protected double[] getPositiveBins(BulletTracking bulletTracking, double d, double d2, double d3, double d4, double d5, double d6, int n) {
        int n2 = (int)(AngleUtils.difference(bulletTracking.getPositiveAngle(), bulletTracking.getMiddleAngle()) / bulletTracking.getAngleAdvance()) + 1;
        double[] dArray = new double[n2];
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = 0.0;
        }
        double d7 = d6;
        Iterator iterator = this.hits.iterator();
        Iterator iterator2 = this.possibleHits.iterator();
        Iterator iterator3 = this.misses.iterator();
        Iterator iterator4 = this.all.iterator();
        BulletTracking bulletTracking2 = null;
        BulletTracking bulletTracking3 = null;
        BulletTracking bulletTracking4 = null;
        if (iterator.hasNext()) {
            bulletTracking2 = (BulletTracking)iterator.next();
        }
        if (iterator2.hasNext()) {
            bulletTracking3 = (BulletTracking)iterator2.next();
        }
        if (iterator3.hasNext()) {
            bulletTracking4 = (BulletTracking)iterator3.next();
        }
        while (iterator4.hasNext() && n-- > 0) {
            BulletTracking bulletTracking5 = (BulletTracking)iterator4.next();
            if (bulletTracking5 == bulletTracking3) {
                this.fillBin(bulletTracking5, bulletTracking, dArray, true, d2 * d7, d4, d5);
                bulletTracking3 = iterator2.hasNext() ? (BulletTracking)iterator2.next() : null;
            } else if (bulletTracking5 == bulletTracking2) {
                this.fillBin(bulletTracking5, bulletTracking, dArray, true, d * d7, d4, d5);
                bulletTracking2 = iterator.hasNext() ? (BulletTracking)iterator.next() : null;
            } else if (bulletTracking5 == bulletTracking4) {
                this.fillBin(bulletTracking5, bulletTracking, dArray, true, d3 * d7, d4, d5);
                bulletTracking4 = iterator3.hasNext() ? (BulletTracking)iterator3.next() : null;
            }
            d7 *= d7;
        }
        return dArray;
    }

    protected double[] getNegativeBins(BulletTracking bulletTracking, double d, double d2, double d3, double d4, double d5, double d6, int n) {
        int n2 = (int)(AngleUtils.difference(bulletTracking.getMiddleAngle(), bulletTracking.getNegativeAngle()) / bulletTracking.getAngleAdvance()) + 1;
        double[] dArray = new double[n2];
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = 0.0;
        }
        double d7 = d6;
        Iterator iterator = this.hits.iterator();
        Iterator iterator2 = this.possibleHits.iterator();
        Iterator iterator3 = this.misses.iterator();
        Iterator iterator4 = this.all.iterator();
        BulletTracking bulletTracking2 = null;
        BulletTracking bulletTracking3 = null;
        BulletTracking bulletTracking4 = null;
        if (iterator.hasNext()) {
            bulletTracking2 = (BulletTracking)iterator.next();
        }
        if (iterator2.hasNext()) {
            bulletTracking3 = (BulletTracking)iterator2.next();
        }
        if (iterator3.hasNext()) {
            bulletTracking4 = (BulletTracking)iterator3.next();
        }
        while (iterator4.hasNext() && n-- > 0) {
            BulletTracking bulletTracking5 = (BulletTracking)iterator4.next();
            if (bulletTracking5 == bulletTracking3) {
                this.fillBin(bulletTracking5, bulletTracking, dArray, false, d2 * d7, d4, d5);
                bulletTracking3 = iterator2.hasNext() ? (BulletTracking)iterator2.next() : null;
            } else if (bulletTracking5 == bulletTracking2) {
                this.fillBin(bulletTracking5, bulletTracking, dArray, false, d * d7, d4, d5);
                bulletTracking2 = iterator.hasNext() ? (BulletTracking)iterator.next() : null;
            } else if (bulletTracking5 == bulletTracking4) {
                this.fillBin(bulletTracking5, bulletTracking, dArray, false, d3 * d7, d4, d5);
                bulletTracking4 = iterator3.hasNext() ? (BulletTracking)iterator3.next() : null;
            }
            d7 *= d7;
        }
        return dArray;
    }
}

