/*
 * Decompiled with CFR 0.152.
 */
package cbot.cbot.driver;

import cbot.cbot.CU;
import cbot.cbot.Point;
import cbot.cbot.Pray;
import cbot.cbot.driver.AbstractDriver;
import java.util.ArrayList;
import java.util.Iterator;
import robocode.AdvancedRobot;

public class AntiGravityDriver
extends AbstractDriver {
    private ArrayList bullets = new ArrayList();
    private ArrayList gravPoints = new ArrayList();
    private int dodgeDirection = 1;
    private boolean avoidingWall = false;
    private int parallelCounter = 0;
    private double lastDodgePower;

    public AntiGravityDriver(AdvancedRobot advancedRobot) {
        super(advancedRobot);
        this.addCornerGravPoints();
    }

    public void drive(Pray pray) {
        super.drive(pray);
        this.avoidingWall = false;
        this.robot.setMaxVelocity(8.0);
        Point point = this.getGoToPoint();
        double d = this.getGoToAngle(point);
        double d2 = Math.pow(10.0, 10.0) * Math.pow(Math.abs(this.getRoboCord().getDistance(point)), 3.0);
        if (!this.avoidingWall) {
            this.steerRight(d);
        }
        if (this.parallelCounter++ % 20 == 0) {
            d = this.getParallelAngle();
        }
        this.forward(d2);
    }

    public void victoryDance() {
        Point point = new Point(this.robot.getBattleFieldWidth() / 2.0, this.robot.getBattleFieldHeight() / 2.0);
        Point point2 = new Point((this.robot.getBattleFieldWidth() - 50.0) / 2.0, this.robot.getBattleFieldHeight() / 2.0);
        this.gravPoints.add(new TimeGravPoint(point, -500, 100L));
        this.gravPoints.add(new TimeGravPoint(point2, 400, 100L));
        this.robot.setAdjustGunForRobotTurn(false);
        this.robot.setTurnGunRight(720.0 - (this.robot.getGunHeading() - this.robot.getHeading()));
    }

    public void handleBeeingHit() {
        Point point = this.getRoboCord();
        point.x += Math.random() * 100.0 - 50.0;
        point.y += Math.random() * 100.0 - 50.0;
        point = this.adjustGravPointToWall(point, 300.0);
        this.gravPoints.add(new TimeGravPoint(point, 4000, 20L));
    }

    private Point getGoToPoint() {
        this.addPrayGravPoints();
        this.addBulletGravPoints();
        this.removeOldGravPoints();
        GravForce gravForce = this.getTotGravForce();
        gravForce = this.handleWallAvoidance(gravForce);
        if (Math.random() * 3.0 > 1.0) {
            if (Math.abs(gravForce.x) < 0.001) {
                gravForce.x = 0.0;
            }
            if (Math.abs(gravForce.y) < 0.001) {
                gravForce.y = 0.0;
            }
        }
        Point point = this.getRoboCord();
        return new Point(point.getX() - gravForce.x / 2.0, point.getY() - gravForce.y / 2.0);
    }

    private GravForce getTotGravForce() {
        GravForce gravForce = new GravForce(0.0, 0.0);
        Point point = this.getRoboCord();
        Iterator iterator = this.gravPoints.iterator();
        while (iterator.hasNext()) {
            GravPoint gravPoint = (GravPoint)iterator.next();
            Point point2 = gravPoint.getCordinate();
            double d = gravPoint.getPower();
            double d2 = point.getAngle(point2);
            double d3 = point.getDistance(point2);
            double d4 = d / Math.pow(d3, 2.0);
            gravForce.x += Math.sin(d2) * d4;
            gravForce.y += Math.cos(d2) * d4;
        }
        return gravForce;
    }

    private void removeOldGravPoints() {
        Iterator iterator = this.gravPoints.iterator();
        while (iterator.hasNext()) {
            if (!((GravPoint)iterator.next()).isDead()) continue;
            iterator.remove();
        }
    }

    private GravForce handleWallAvoidance(GravForce gravForce) {
        double d = 50.0;
        int n = 50;
        Point point = this.getRoboCord();
        int[] nArray = CU.getCloseWalls(point, n);
        switch (nArray[0]) {
            case 4: {
                gravForce.x -= d / Math.pow(point.getX(), 3.0);
                break;
            }
            case 2: {
                gravForce.x += d / Math.pow(this.robot.getBattleFieldWidth() - point.getX(), 3.0);
                break;
            }
            case 3: {
                gravForce.y -= d / Math.pow(point.getY(), 3.0);
                break;
            }
            case 1: {
                gravForce.y += d / Math.pow(this.robot.getBattleFieldHeight() - point.getY(), 3.0);
            }
        }
        double d2 = this.turnToAvoideWall(75);
        if (d2 != 0.0) {
            this.avoidingWall = true;
        }
        return gravForce;
    }

    private void addBulletGravPoints() {
        int n = (int)(Math.random() * 70.0 + 40.0);
        int n2 = (int)(Math.random() * 8.0) + 10;
        int n3 = n2 + 10;
        if (n < 45 && this.lastDodgePower < 45.0) {
            n = 70;
        }
        this.lastDodgePower = n;
        Iterator iterator = this.bullets.iterator();
        while (iterator.hasNext()) {
            Bullet bullet = (Bullet)iterator.next();
            if (!bullet.timeToMove(n2)) continue;
            this.gravPoints.add(new TimeGravPoint(bullet.getAGCordinate(), n, n3));
            iterator.remove();
        }
    }

    private void addPrayGravPoints() {
        int n;
        int n2 = n = this.doAttackMode() ? -250 : 150;
        if (this.currentPray == null) {
            return;
        }
        this.gravPoints.add(new TimeGravPoint(this.currentPray.getCordinate(), n, 1L));
    }

    private void addCornerGravPoints() {
        int n = 150;
        long l = 100000L;
        int n2 = (int)this.robot.getBattleFieldWidth();
        int n3 = (int)this.robot.getBattleFieldHeight();
        this.gravPoints.add(new TimeGravPoint(new Point(0.0, 0.0), n, l));
        this.gravPoints.add(new TimeGravPoint(new Point(0.0, n3), n, l));
        this.gravPoints.add(new TimeGravPoint(new Point(n2, 0.0), n * 2, l));
        this.gravPoints.add(new TimeGravPoint(new Point(n2, n3), n, l));
        if (this.robot.getOthers() > 1) {
            this.gravPoints.add(new TimeGravPoint(new Point(n2 / 2, n3 / 2), 75, l));
        }
    }

    public void handleBeingFiredAt(Pray pray, double d, double d2) {
        Point point;
        Point[] pointArray = new Point[1];
        Point point2 = this.getRoboCord();
        Point point3 = pray.getCordinate();
        if (Math.random() < 0.75) {
            this.dodgeDirection *= -1;
        }
        double d3 = (Math.random() * 1.5707963267948966 + 0.7853981633974483) * (double)this.dodgeDirection;
        double d4 = point2.getAngle(point3) + d3;
        pointArray[pointArray.length - 1] = point = Point.getNewPoint(point2, 75.0, d4);
        int n = 0;
        while (n < pointArray.length) {
            if (pointArray[n] != null) {
                point = this.adjustGravPointToWall(pointArray[n], 150.0);
                double d5 = point.getDistance(point3);
                double d6 = d5 / CU.getBulletVelocity(d);
                this.bullets.add(new Bullet(point, d6, d2));
            }
            ++n;
        }
    }

    private Point adjustGravPointToWall(Point point, double d) {
        double d2 = this.robot.getX();
        double d3 = this.robot.getY();
        double d4 = d;
        double d5 = Math.random() * 10.0;
        if (d2 < d4 && point.x > d2) {
            point.x = d2 - d5;
        }
        if (d2 > this.robot.getBattleFieldWidth() - d4 && point.x < d2) {
            point.x = d2 + d5;
        }
        if (d3 < d4 && point.y > d3) {
            point.y = d3 - d5;
        }
        if (d3 > this.robot.getBattleFieldHeight() - d4 && point.y < d3) {
            point.y = d3 + d5;
        }
        return point;
    }

    private boolean doAttackMode() {
        try {
            return this.robot.getOthers() == 1 && this.currentPray.getEnergy() < 0.5;
        }
        catch (Exception exception) {
            return false;
        }
    }

    class GravForce {
        public double x;
        public double y;

        public GravForce(double d, double d2) {
            this.x = d;
            this.y = d2;
        }

        public String toString() {
            return "x=" + this.x + "|y=" + this.y;
        }
    }

    class DistanceGravPoint
    extends GravPoint {
        public DistanceGravPoint(Point point, double d) {
            super(null, 10000.0);
            Point point2 = AntiGravityDriver.this.getRoboCord();
            double d2 = point.getDistance(point2);
            double d3 = point.getAngle(point2);
            double d4 = d2 / Math.cos(d);
            this.cordinate = Point.getNewPoint(point, d4, d);
        }

        public boolean isDead() {
            return AntiGravityDriver.this.getRoboCord().getDistance(this.cordinate) < 20.0;
        }
    }

    class TimeGravPoint
    extends GravPoint {
        private long effectiveTime;
        private long timeOfBirth;

        public TimeGravPoint(Point point, int n, long l) {
            super(point, n);
            this.effectiveTime = l;
            this.timeOfBirth = AntiGravityDriver.this.robot.getTime();
        }

        public boolean isDead() {
            return AntiGravityDriver.this.robot.getTime() - this.timeOfBirth >= this.effectiveTime;
        }
    }

    abstract class GravPoint {
        public Point cordinate;
        public double power;

        public GravPoint(Point point, double d) {
            this.cordinate = point;
            this.power = d;
        }

        public abstract boolean isDead();

        public Point getCordinate() {
            return this.cordinate;
        }

        public double getPower() {
            return this.power;
        }

        public String toString() {
            return this.cordinate + " p=" + this.power;
        }
    }

    class Bullet {
        public Point cordinate;
        public double travelTime;
        public double fireTime;

        public Bullet(Point point, double d, double d2) {
            this.cordinate = point;
            this.travelTime = d;
            this.fireTime = d2;
        }

        public boolean timeToMove(double d) {
            return d <= this.travelTime - ((double)AntiGravityDriver.this.robot.getTime() - this.fireTime);
        }

        public Point getAGCordinate() {
            return this.cordinate;
        }
    }
}

