/*
 * Decompiled with CFR 0.152.
 */
package dk.config;

import dk.Base;
import dk.Enemy;
import dk.FireController;
import dk.MovementController;
import dk.ScanController;
import dk.TargetSelector;
import dk.Util;
import dk.fire.Constant;
import dk.predict.PredictionController;
import dk.scan.OptimalSweep;
import dk.target.Closest;

public class Config {
    public MovementController movementController;
    public PredictionController predictionController;
    public TargetSelector targetSelector;
    public ScanController scanController;
    public FireController fireController;
    public double FIRE_ENERGY_LOW = 10.0;
    public double FIRE_RANGE_SHORT = 150.0;
    public double FIRE_RANGE_LONG = 600.0;
    public double FIRE_RANGE_MAX = 800.0;
    public int FIRE_MAX_SCAN_AGE = 10;
    public double FIRE_AIM_EPSILON = Math.PI / 90;
    public double FIRE_CONSTANT_POWER = 2.99;
    public boolean MAGNETIC_REVERSE = false;
    public double MAGNETIC_TURN_THRESHOLD = Util.toRadians(20.0);
    public double MAGNETIC_TURN_FACTOR = 4.0;
    public double MAGNETIC_MIN_MOVE = 0.0;
    public double MAGNETIC_JITTER_DESTINATION = 100.0;
    public double MAGNETIC_AVOID_ROBOT_STRENGTH = -6.0;
    public double MAGNETIC_AVOID_WALL_STRENGTH = -200.0;
    public double MAGNETIC_AVOID_WALL_SIZE = 100.0;
    public double MAGNETIC_AVOID_CENTER_STRENGTH = -5.0;
    public double MAGNETIC_TARGET_STRENGTH = 12.0;
    public double MAGNETIC_FOLLOW_BEARING = 5.654866776461628;
    public double MAGNETIC_FOLLOW_DISTANCE = 275.0;
    public double MAGNETIC_FOLLOW_STRENGTH = 12.0;
    public double MAGNETIC_DEST_EPSILON = 10.0;
    public double MAGNETIC_DEST_STRENGTH = 8.0;
    public double MAGNETIC_DEST_COUNTDOWN_MIN = 30.0;
    public double MAGNETIC_DEST_COUNTDOWN_JITTER = 200.0;
    public double MAGNETIC_BULLET_DODGE_STRENGTH = -100.0;
    public double MAGNETIC_BULLET_DODGE_RADIUS = 40.0;
    public int SCAN_MAX_SCAN_AGE = 10;
    public int SCAN_LEAD_TURNS = 4;
    public double SCAN_OPTIMAL_OVERSCAN = Util.toRadians(19.0);
    public int MAX_ROBOTS_DUEL = 1;
    public int PREDICT_TRACER_MAX_AGE = 4;

    public Config() {
        this.targetSelector = new Closest();
        this.fireController = new Constant();
        this.scanController = new OptimalSweep();
    }

    public void doTurn(Base robot) {
        if (this.predictionController != null) {
            this.predictionController.doTurn(robot, true);
        }
        if (this.movementController != null) {
            this.movementController.setMovement(robot);
        }
        if (this.scanController != null) {
            this.scanController.setScan(robot);
        }
        if (this.fireController != null) {
            this.fireController.setAim(robot);
        }
    }

    public void onEnemyBulletFired(Base robot, Enemy e, double power) {
        this.movementController.onEnemyBulletFired(robot, e, power);
    }

    public void setTarget(Enemy t) {
        this.movementController.setTarget(t);
        this.scanController.setTarget(t);
        this.fireController.setTarget(t);
    }

    public TargetSelector getTargetSelector() {
        return this.targetSelector;
    }
}

